/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.lang.reflect.Constructor;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.DatabaseVersion;
import org.jumpmind.db.platform.DdlException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatformFactory;
import org.jumpmind.db.platform.ase.AseDatabasePlatform;
import org.jumpmind.db.platform.cassandra.CassandraPlatform;
import org.jumpmind.db.platform.db2.Db2DatabasePlatform;
import org.jumpmind.db.platform.derby.DerbyDatabasePlatform;
import org.jumpmind.db.platform.firebird.FirebirdDatabasePlatform;
import org.jumpmind.db.platform.firebird.FirebirdDialect1DatabasePlatform;
import org.jumpmind.db.platform.generic.GenericJdbcDatabasePlatform;
import org.jumpmind.db.platform.greenplum.GreenplumPlatform;
import org.jumpmind.db.platform.h2.H2DatabasePlatform;
import org.jumpmind.db.platform.hana.HanaDatabasePlatform;
import org.jumpmind.db.platform.hbase.HbasePlatform;
import org.jumpmind.db.platform.hsqldb.HsqlDbDatabasePlatform;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2DatabasePlatform;
import org.jumpmind.db.platform.informix.InformixDatabasePlatform;
import org.jumpmind.db.platform.ingres.IngresDatabasePlatform;
import org.jumpmind.db.platform.interbase.InterbaseDatabasePlatform;
import org.jumpmind.db.platform.kafka.KafkaPlatform;
import org.jumpmind.db.platform.mariadb.MariaDBDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2005DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2016DatabasePlatform;
import org.jumpmind.db.platform.mysql.MySqlDatabasePlatform;
import org.jumpmind.db.platform.nuodb.NuoDbDatabasePlatform;
import org.jumpmind.db.platform.oracle.Oracle122DatabasePlatform;
import org.jumpmind.db.platform.oracle.OracleDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSql95DatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.platform.raima.RaimaDatabasePlatform;
import org.jumpmind.db.platform.redshift.RedshiftDatabasePlatform;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhere12DatabasePlatform;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDatabasePlatform;
import org.jumpmind.db.platform.sqlite.SqliteDatabasePlatform;
import org.jumpmind.db.platform.tibero.TiberoDatabasePlatform;
import org.jumpmind.db.platform.voltdb.VoltDbDatabasePlatform;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatabasePlatformFactory
implements IDatabasePlatformFactory {
    public static final String JDBC_PREFIX = "jdbc:";
    private static final Logger log = LoggerFactory.getLogger(JdbcDatabasePlatformFactory.class);
    protected Map<String, Class<? extends IDatabasePlatform>> platforms = new HashMap<String, Class<? extends IDatabasePlatform>>();
    protected Map<String, Class<? extends IDatabasePlatform>> jdbcSubProtocolToPlatform = new HashMap<String, Class<? extends IDatabasePlatform>>();
    private static IDatabasePlatformFactory instance;

    protected JdbcDatabasePlatformFactory() {
        this.addPlatform(this.platforms, "ase", AseDatabasePlatform.class);
        this.addPlatform(this.platforms, "cassandra", CassandraPlatform.class);
        this.addPlatform(this.platforms, "db2", Db2DatabasePlatform.class);
        this.addPlatform(this.platforms, "derby", DerbyDatabasePlatform.class);
        this.addPlatform(this.platforms, "firebird", FirebirdDatabasePlatform.class);
        this.addPlatform(this.platforms, "firebird_dialect1", FirebirdDialect1DatabasePlatform.class);
        this.addPlatform(this.platforms, "generic", GenericJdbcDatabasePlatform.class);
        this.addPlatform(this.platforms, "greenplum", GreenplumPlatform.class);
        this.addPlatform(this.platforms, "h2", H2DatabasePlatform.class);
        this.addPlatform(this.platforms, "hdb", HanaDatabasePlatform.class);
        this.addPlatform(this.platforms, "hbase", HbasePlatform.class);
        this.addPlatform(this.platforms, "hsqldb", HsqlDbDatabasePlatform.class);
        this.addPlatform(this.platforms, "hsqldb2", HsqlDb2DatabasePlatform.class);
        this.addPlatform(this.platforms, "ingres", IngresDatabasePlatform.class);
        this.addPlatform(this.platforms, "informix", InformixDatabasePlatform.class);
        this.addPlatform(this.platforms, "interbase", InterbaseDatabasePlatform.class);
        this.addPlatform(this.platforms, "kafka", KafkaPlatform.class);
        this.addPlatform(this.platforms, "mssql", MsSql2000DatabasePlatform.class);
        this.addPlatform(this.platforms, "mssql2000", MsSql2000DatabasePlatform.class);
        this.addPlatform(this.platforms, "mssql2005", MsSql2005DatabasePlatform.class);
        this.addPlatform(this.platforms, "mssql2008", MsSql2008DatabasePlatform.class);
        this.addPlatform(this.platforms, "mssql2016", MsSql2016DatabasePlatform.class);
        this.addPlatform(this.platforms, "mssqlazure", MsSql2016DatabasePlatform.class);
        this.addPlatform(this.platforms, "mysql", MySqlDatabasePlatform.class);
        this.addPlatform(this.platforms, "nuodb", NuoDbDatabasePlatform.class);
        this.addPlatform(this.platforms, "oracle", OracleDatabasePlatform.class);
        this.addPlatform(this.platforms, "oracle122", Oracle122DatabasePlatform.class);
        this.addPlatform(this.platforms, "postgres", PostgreSqlDatabasePlatform.class);
        this.addPlatform(this.platforms, "postgres95", PostgreSql95DatabasePlatform.class);
        this.addPlatform(this.platforms, "sqlite", SqliteDatabasePlatform.class);
        this.addPlatform(this.platforms, "sqlanywhere", SqlAnywhere12DatabasePlatform.class);
        this.addPlatform(this.platforms, "sqlanywhere12", SqlAnywhere12DatabasePlatform.class);
        this.addPlatform(this.platforms, "raima", RaimaDatabasePlatform.class);
        this.addPlatform(this.platforms, "redshift", RedshiftDatabasePlatform.class);
        this.addPlatform(this.platforms, "tibero", TiberoDatabasePlatform.class);
        this.addPlatform(this.platforms, "voltdb", VoltDbDatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server8", MsSql2000DatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server9", MsSql2005DatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server10", MsSql2008DatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server11", MsSql2008DatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server12", MsSql2008DatabasePlatform.class);
        this.addPlatform(this.platforms, "microsoft sql server13", MsSql2016DatabasePlatform.class);
        this.addPlatform(this.platforms, "HSQL Database Engine2", HsqlDb2DatabasePlatform.class);
        this.addPlatform(this.platforms, "Adaptive Server Enterprise", AseDatabasePlatform.class);
        this.addPlatform(this.platforms, "Adaptive Server Anywhere", SqlAnywhereDatabasePlatform.class);
        this.addPlatform(this.platforms, "SQL Anywhere", SqlAnywhereDatabasePlatform.class);
        this.addPlatform(this.platforms, "Microsoft SQL Server", MsSql2016DatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("sybase:Tds", AseDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("db2", Db2DatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("derby", DerbyDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("firebirdsql", FirebirdDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("h2", H2DatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("sap", HanaDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("phoenix", HbasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("hsqldb", HsqlDbDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("informix-sqli", InformixDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("ingres", IngresDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("interbase", InterbaseDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("mariadb", MariaDBDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("jtds", MsSql2000DatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("mysql", MySqlDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("nuodb", NuoDbDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("oracle:thin", OracleDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("oracle:oci8", OracleDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("oracle:dnldthin", OracleDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("postgresql", PostgreSqlDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("sqlite", SqliteDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("sybase:Tds", SqlAnywhereDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("raima", RaimaDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("redshift", RedshiftDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("tibero:thin", TiberoDatabasePlatform.class);
        this.jdbcSubProtocolToPlatform.put("voltdb", VoltDbDatabasePlatform.class);
    }

    public static synchronized IDatabasePlatformFactory getInstance() {
        if (instance == null) {
            instance = (IDatabasePlatformFactory)AppUtils.newInstance(IDatabasePlatformFactory.class, JdbcDatabasePlatformFactory.class);
        }
        return instance;
    }

    public synchronized IDatabasePlatform create(DataSource dataSource, SqlTemplateSettings settings, boolean delimitedIdentifierMode, boolean caseSensitive) throws DdlException {
        return this.create(dataSource, settings, delimitedIdentifierMode, caseSensitive, false, false);
    }

    public synchronized IDatabasePlatform create(DataSource dataSource, SqlTemplateSettings settings, boolean delimitedIdentifierMode, boolean caseSensitive, boolean isLoadOnly, boolean isLogBased) throws DdlException {
        if (isLoadOnly) {
            TypedProperties properties = settings.getProperties();
            String dbUrl = properties.get("db.url");
            String dbDriver = properties.get("db.driver");
            if (dbUrl != null && dbUrl.startsWith("cassandra://")) {
                return new CassandraPlatform(settings, dbUrl.substring(12));
            }
            if (dbDriver != null && dbDriver.contains("kafka")) {
                return new KafkaPlatform(settings);
            }
        }
        DatabaseVersion nameVersion = this.determineDatabaseNameVersionSubprotocol(dataSource);
        Class<? extends IDatabasePlatform> clazz = this.findPlatformClass(nameVersion);
        try {
            Constructor<? extends IDatabasePlatform> construtor = clazz.getConstructor(DataSource.class, SqlTemplateSettings.class);
            IDatabasePlatform platform = construtor.newInstance(dataSource, settings);
            log.info("The IDatabasePlatform being used is " + platform.getClass().getCanonicalName());
            platform.getDdlBuilder().setDelimitedIdentifierModeOn(delimitedIdentifierMode);
            platform.getDdlBuilder().setCaseSensitive(caseSensitive);
            platform.getDdlBuilder().getDatabaseInfo().setLogBased(isLogBased);
            platform.getDdlBuilder().initCteExpression();
            return platform;
        }
        catch (Exception e) {
            throw new DdlException("Could not create a platform of type " + nameVersion.getName(), (Throwable)e);
        }
    }

    protected synchronized Class<? extends IDatabasePlatform> findPlatformClass(DatabaseVersion nameVersion) {
        Class<Object> platformClass = this.platforms.get(String.format("%s%s", nameVersion.getName(), nameVersion.getVersionAsString()).toLowerCase());
        if (platformClass == null) {
            platformClass = this.platforms.get(nameVersion.getName().toLowerCase());
        }
        if (platformClass == null) {
            platformClass = this.jdbcSubProtocolToPlatform.get(nameVersion.getProtocol());
        }
        if (platformClass == null) {
            platformClass = GenericJdbcDatabasePlatform.class;
        }
        return platformClass;
    }

    public DatabaseVersion determineDatabaseNameVersionSubprotocol(DataSource dataSource) {
        DatabaseVersion nameVersion = new DatabaseVersion();
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            nameVersion.setName(metaData.getDatabaseProductName());
            nameVersion.setVersion(metaData.getDatabaseMajorVersion());
            String url = metaData.getURL();
            if (StringUtils.isNotBlank((CharSequence)url) && url.length() > JDBC_PREFIX.length() && (url = url.substring(JDBC_PREFIX.length())).indexOf(":") > 0) {
                url = url.substring(0, url.indexOf(":"));
            }
            nameVersion.setProtocol(url);
            this.determineDatabaseNameVersionSubprotocol(dataSource, connection, metaData, nameVersion);
            log.info("Detected database '" + nameVersion.getName() + "', version '" + nameVersion.getVersion() + "', protocol '" + nameVersion.getProtocol() + "'");
        }
        catch (Throwable ex) {
            throw new SqlException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        return nameVersion;
    }

    protected void determineDatabaseNameVersionSubprotocol(DataSource dataSource, Connection connection, DatabaseMetaData metaData, DatabaseVersion nameVersion) throws SQLException {
        if (nameVersion.getProtocol().equalsIgnoreCase("postgresql")) {
            if (this.isGreenplumDatabase(connection)) {
                nameVersion.setName("greenplum");
                nameVersion.setVersion(this.getGreenplumVersion(connection));
            } else if (metaData.getDatabaseMajorVersion() > 9 || metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() >= 5) {
                nameVersion.setName("postgres95");
            }
        }
        if (nameVersion.getProtocol().equalsIgnoreCase("firebirdsql") && this.isFirebirdDialect1(connection)) {
            nameVersion.setName("firebird_dialect1");
        }
        if (nameVersion.getName().equalsIgnoreCase("oracle")) {
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            if ((majorVersion > 12 || majorVersion == 12 && minorVersion >= 2) && this.isOracle122Compatible(connection)) {
                nameVersion.setName("oracle122");
            }
        }
        if (nameVersion.getProtocol().equalsIgnoreCase("sqlserver")) {
            int engineEdition = this.getMsSqlEngineEdition(connection);
            if (this.isMSSQLAzureManagedInstance(engineEdition)) {
                nameVersion.setName("mssqlazure");
            } else if (engineEdition >= 5) {
                nameVersion.setName("mssql2016");
            }
        }
        if (nameVersion.getProtocol().equalsIgnoreCase("sybase") && nameVersion.getVersion() >= 12 && !nameVersion.getName().equals("Adaptive Server Enterprise")) {
            nameVersion.setName("sqlanywhere12");
        }
    }

    private boolean isGreenplumDatabase(Connection connection) {
        int count = 0;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("select count(*) from information_schema.tables where table_name = 'gp_id'");){
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return count > 0;
    }

    private int getGreenplumVersion(Connection connection) {
        String versionName = null;
        int productVersion = 0;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("select productversion from gp_version_at_initdb");){
            while (rs.next()) {
                versionName = rs.getString(1);
            }
            if (versionName.indexOf(46) != -1) {
                versionName = versionName.substring(0, versionName.indexOf(46));
            }
            try {
                productVersion = Integer.parseInt(versionName);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return productVersion;
    }

    private boolean isFirebirdDialect1(Connection connection) {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        Statement stmt;
        boolean isDialect1 = false;
        try {
            stmt = connection.createStatement();
            throwable2 = null;
            try {
                rs2 = stmt.executeQuery("select current_time from rdb$database");
                throwable = null;
                try {
                    rs2.next();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            isDialect1 = true;
        }
        if (isDialect1) {
            try {
                stmt = connection.createStatement();
                throwable2 = null;
                try {
                    rs2 = stmt.executeQuery("select cast(1 as numeric(10,0)) from rdb$database");
                    throwable = null;
                    try {
                        rs2.next();
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                log.error("The client sql dialect does not match the database, which is not a supported mode.  You must add ?sql_dialect=1 to the end of the JDBC URL.");
            }
        }
        return isDialect1;
    }

    private boolean isMSSQLAzureManagedInstance(int engineEdition) {
        return engineEdition == 8;
    }

    private int getMsSqlEngineEdition(Connection connection) {
        int engineEdition = -1;
        try (Statement s = connection.createStatement();){
            ResultSet rs = s.executeQuery("SELECT CAST(SERVERPROPERTY('EngineEdition') AS INT)");
            if (rs.next()) {
                engineEdition = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            log.info("Unable to get Sql Server Engine Edition");
        }
        return engineEdition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOracle122Compatible(Connection connection) {
        String[] valueArr;
        boolean isOracle122 = false;
        String compatible = null;
        try (Statement s = connection.createStatement();){
            try {
                s.executeUpdate("begin dbms_output.enable(); end;");
                s.executeUpdate("declare lver varchar(100); lcomp varchar(100); begin dbms_utility.db_version(lver, lcomp); dbms_output.put_line(lcomp); end;");
                String sql = "declare num integer := 1; begin dbms_output.get_lines(?, num); end;";
                try (CallableStatement call = connection.prepareCall(sql);){
                    call.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
                    call.execute();
                    Array array = call.getArray(1);
                    if (array != null) {
                        String[] compatibleArray = (String[])array.getArray();
                        if (compatibleArray != null && compatibleArray.length > 0) {
                            compatible = compatibleArray[0];
                        }
                        array.free();
                    }
                }
            }
            finally {
                s.executeUpdate("begin dbms_output.disable(); end;");
            }
        }
        catch (SQLException e) {
            log.warn("Could not check Oracle compatible parameter", (Throwable)e);
        }
        if (compatible != null && (valueArr = compatible.split("\\.")) != null) {
            try {
                isOracle122 = valueArr.length > 0 && Integer.parseInt(valueArr[0]) > 12 || valueArr.length > 1 && Integer.parseInt(valueArr[0]) == 12 && Integer.parseInt(valueArr[1]) >= 2;
            }
            catch (Exception e) {
                log.warn("Could not parse Oracle compatible version " + compatible + " because ", (Object)e.getMessage());
            }
        }
        return isOracle122;
    }

    protected synchronized void addPlatform(Map<String, Class<? extends IDatabasePlatform>> platformMap, String platformName, Class<? extends IDatabasePlatform> platformClass) {
        if (!IDatabasePlatform.class.isAssignableFrom(platformClass)) {
            throw new IllegalArgumentException("Cannot register class " + platformClass.getName() + " because it does not implement the " + IDatabasePlatform.class.getName() + " interface");
        }
        platformMap.put(platformName.toLowerCase(), platformClass);
    }

    public static boolean isJdbcUrl(String dbUrl) {
        return dbUrl != null && dbUrl.startsWith(JDBC_PREFIX);
    }
}

