/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class DerbyDdlReader
extends AbstractJdbcDdlReader {
    public DerbyDdlReader(IDatabasePlatform platform) {
        super(platform);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            if ("GENERATED_BY_DEFAULT".equals(defaultValue) || defaultValue.startsWith("AUTOINCREMENT:")) {
                column.setDefaultValue(null);
                column.setAutoIncrement(true);
            } else if (column.isGenerated() && defaultValue.startsWith("GENERATED ALWAYS AS")) {
                int closingParen;
                int openingParen = (defaultValue = defaultValue.replace("GENERATED ALWAYS AS", "")).indexOf("(");
                if (openingParen != -1) {
                    defaultValue = defaultValue.substring(openingParen + 1);
                }
                if ((closingParen = defaultValue.lastIndexOf(")")) != -1) {
                    defaultValue = defaultValue.substring(0, closingParen);
                }
                column.setDefaultValue(defaultValue.trim());
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
            }
        }
        if (column.getJdbcTypeCode() == 93) {
            this.resetColumnSize(column, "6");
            this.removePlatformColumnSize(column);
        } else if (column.getJdbcTypeCode() == 92) {
            this.resetColumnSize(column, "0");
            this.removePlatformColumnSize(column);
        } else if (column.getJdbcTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        return this.isInternalIndex(index);
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return this.isInternalIndex(index);
    }

    private boolean isInternalIndex(IIndex index) {
        String name = index.getName();
        if (name != null && name.startsWith("SQL")) {
            try {
                Long.parseLong(name.substring(3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT TRIG.TRIGGERNAME as TRIGGER_NAME, TAB.TABLENAME as TABLE_NAME, SC.SCHEMANAME as SCHEMA_NAME, TRIG.CREATIONTIMESTAMP, TRIG.EVENT as TRIGGER_TYPE, TRIG.STATE, TRIG.FIRINGTIME as TRIGGER_TIME, TRIG.WHENSTMTID, TRIG.ACTIONSTMTID, TRIG.REFERENCEDCOLUMNS, TRIG.TRIGGERDEFINITION as source, TRIG.REFERENCINGOLD, TRIG.REFERENCINGNEW, TRIG.OLDREFERENCINGNAME, TRIG.NEWREFERENCINGNAME, TRIG.TYPE, TRIG.TRIGGERID, TRIG.TABLEID, TRIG.SCHEMAID FROM SYS.SYSTRIGGERS AS TRIG INNER JOIN SYS.SYSTABLES AS TAB ON TAB.TABLEID = TRIG.TABLEID INNER JOIN SYS.SYSSCHEMAS AS SC ON SC.SCHEMAID = TRIG.SCHEMAID WHERE TABLENAME=? and SC.SCHEMANAME=? ";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setSchemaName(row.getString("SCHEMA_NAME"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                if (row.getString("STATE").equals("E")) {
                    row.put("STATE", (Object)"ENABLED");
                    trigger.setEnabled(true);
                } else if (row.getString("STATE").equals("D")) {
                    row.put("STATE", (Object)"DISABLED");
                    trigger.setEnabled(false);
                }
                String event = row.getString("TRIGGER_TYPE");
                switch (event.charAt(0)) {
                    case 'I': {
                        event = "INSERT";
                        break;
                    }
                    case 'D': {
                        event = "DELETE";
                        break;
                    }
                    case 'U': {
                        event = "UPDATE";
                    }
                }
                row.put("TRIGGER_TYPE", (Object)event);
                trigger.setTriggerType(Trigger.TriggerType.valueOf((String)event));
                if (row.getString("TRIGGER_TIME").equals("A")) {
                    row.put("TRIGGER_TIME", (Object)"AFTER");
                } else if (row.getString("TRIGGER_TIME").equals("B")) {
                    row.put("TRIGGER_TIME", (Object)"BEFORE");
                }
                trigger.setMetaData((Map)row);
                trigger.setSource(row.getString("source"));
                row.remove((Object)"source");
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }
}

