/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.informix;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.informix.InformixDdlBuilder;
import org.jumpmind.db.platform.informix.InformixDdlReader;
import org.jumpmind.db.platform.informix.InformixJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.mapper.StringMapper;

public class InformixDatabasePlatform
extends AbstractJdbcDatabasePlatform
implements IDatabasePlatform {
    public static final String JDBC_DRIVER = "com.informix.jdbc.IfxDriver";
    public static final String JDBC_SUBPROTOCOL = "informix-sqli";
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();

    public InformixDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "current");
    }

    protected InformixDdlBuilder createDdlBuilder() {
        return new InformixDdlBuilder();
    }

    @Override
    protected InformixDdlReader createDdlReader() {
        return new InformixDdlReader(this);
    }

    @Override
    protected InformixJdbcSqlTemplate createSqlTemplate() {
        return new InformixJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public boolean allowsUniqueIndexDuplicatesWithNulls() {
        return false;
    }

    public String getName() {
        return "informix";
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select trim(user) from sysmaster:sysdual", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public boolean isClob(int type) {
        return type == 2005;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, null);
        ISqlReadCursor cursor = null;
        String catalog = null;
        try {
            String sql = "select dbinfo('dbname') from sysmaster:sysdual";
            result.setTestDetails(sql);
            catalog = this.getSqlTemplate().queryForString(sql, new Object[0]);
            sql = "select 1 from sysmaster:sysdual";
            result.setTestDetails(sql);
            cursor = this.getSqlTemplate().queryForCursor(sql, (ISqlRowMapper)new StringMapper());
        }
        catch (Exception e) {
            if (cursor != null) {
                cursor.close();
            }
            if (e instanceof SqlException && ((SqlException)((Object)e)).getErrorCode() == -79746) {
                result.setStatus(PermissionResult.Status.FAIL);
                result.setSolution("Logging required: ondblog buf " + catalog + "; ontape -s -L 0");
                return result;
            }
            result.setSolution("Problem during check of logging");
            result.setStatus(PermissionResult.Status.FAIL);
            return result;
        }
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER DELETE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " FOR EACH ROW(DELETE FROM " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " WHERE TEST_ID IS NULL)";
        result.setTestDetails(triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"select")) {
            sql = StringUtils.replaceIgnoreCase((String)sql, (String)"select", (String)("select skip " + offset + " first " + limit));
        }
        return sql;
    }
}

