/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2005DdlBuilder;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class MsSql2005DatabasePlatform
extends MsSql2000DatabasePlatform {
    public MsSql2005DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.supportsTruncate = false;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new MsSql2005DdlBuilder();
    }

    @Override
    public String getName() {
        return "mssql2005";
    }

    @Override
    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select SCHEMA_NAME()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public List<Transaction> getTransactions() {
        String sql = "select  r.session_id,  s.login_name,  c.client_net_address,  s.host_name,  r.status,  r.reads,  r.writes,  r.blocking_session_id,  r.start_time,  sql.text from sys.dm_exec_requests as r left join sys.dm_exec_connections as c  on r.connection_id = c.connection_id join sys.dm_exec_sessions as s  on r.session_id = s.session_id cross apply sys.dm_exec_sql_text(r.sql_handle) as sql;";
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (Row row : this.getSqlTemplate().query(sql)) {
            Transaction transaction = new Transaction(row.getString("session_id"), row.getString("login_name"), row.getString("blocking_session_id"), row.getDateTime("start_time"), row.getString("text"));
            transaction.setRemoteIp(row.getString("client_net_address"));
            transaction.setRemoteHost(row.getString("host_name"));
            transaction.setStatus(row.getString("status"));
            transaction.setReads(row.getInt("reads"));
            transaction.setWrites(row.getInt("writes"));
            transactions.add(transaction);
        }
        return transactions;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (this.sqlTemplate.getDatabaseMajorVersion() >= 11) {
            return sql + " offset " + offset + " rows fetch next " + limit + " rows only;";
        }
        int orderIndex = StringUtils.lastIndexOfIgnoreCase((CharSequence)sql, (CharSequence)"order by");
        String order = sql.substring(orderIndex);
        String innerSql = sql.substring(0, orderIndex - 1);
        innerSql = StringUtils.replaceIgnoreCase((String)innerSql, (String)" from", (String)(", ROW_NUMBER() over (" + order + ") as RowNum from"));
        return "select * from (" + innerSql + ") A where RowNum between " + (offset + 1) + " and " + (offset + limit);
    }

    public boolean supportsSliceTables() {
        return true;
    }

    public String getSliceTableSql(String columnName, int sliceNum, int totalSlices) {
        return "ascii(substring(" + columnName + ", 1, 1)) % " + totalSlices + " = " + sliceNum;
    }

    public String getCharSetName() {
        return (String)this.getSqlTemplate().queryForObject("select collation_name from sys.databases where name =\r\ndb_name()", String.class, new Object[0]);
    }
}

