/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.mssql.MsSql2005DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DdlBuilder;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class MsSql2008DatabasePlatform
extends MsSql2005DatabasePlatform {
    public MsSql2008DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.supportsTruncate = true;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new MsSql2008DdlBuilder();
    }

    @Override
    public String getName() {
        return "mssql2008";
    }

    public long getEstimatedRowCount(Table table) {
        String catalog;
        String string = catalog = StringUtils.isNotBlank((CharSequence)table.getCatalog()) ? table.getCatalog() : "";
        if (catalog.length() > 0) {
            if (this.getDdlBuilder().isDelimitedIdentifierModeOn()) {
                catalog = this.getDdlBuilder().getDatabaseInfo().getDelimiterToken() + catalog + this.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
            }
            catalog = catalog + ".";
        }
        return this.getSqlTemplateDirty().queryForLong("select sum(p.rows) from " + catalog + "sys.tables t inner join " + catalog + "sys.partitions p on t.object_id = p.object_id and p.index_id IN (0, 1) inner join " + catalog + "sys.schemas s on t.schema_id = s.schema_id where t.name = ? and s.name = ?", new Object[]{table.getName(), table.getSchema()});
    }

    @Override
    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "");
        try {
            if (this.getSqlTemplate().queryForInt("SELECT COUNT(*) FROM fn_my_permissions(NULL, 'SERVER') WHERE permission_name='ALTER ANY DATABASE'", new Object[0]) > 0) {
                result.setStatus(PermissionResult.Status.PASS);
            } else if (this.getSqlTemplate().queryForInt("SELECT COUNT(*) FROM sys.change_tracking_databases WHERE database_id=DB_ID()", new Object[0]) > 0) {
                result.setStatus(PermissionResult.Status.PASS);
            } else {
                result.setStatus(PermissionResult.Status.FAIL);
                result.setSolution("Grant alter any database to this user. Or, enable change tracking for this database.");
            }
        }
        catch (Exception e) {
            result.setSolution("Error occurred checking user permissions");
            result.setException(e);
        }
        return result;
    }
}

