/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.oracle.OracleDdlBuilder;
import org.jumpmind.db.platform.oracle.OracleDdlReader;
import org.jumpmind.db.platform.oracle.OracleJdbcSqlTemplate;
import org.jumpmind.db.platform.oracle.OracleLobHandler;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class OracleDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public static final String JDBC_DRIVER_OLD = "oracle.jdbc.dnlddriver.OracleDriver";
    public static final String JDBC_SUBPROTOCOL_THIN = "oracle:thin";
    public static final String JDBC_SUBPROTOCOL_OCI8 = "oracle:oci8";
    public static final String JDBC_SUBPROTOCOL_THIN_OLD = "oracle:dnldthin";

    public OracleDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected OracleDdlBuilder createDdlBuilder() {
        return new OracleDdlBuilder();
    }

    @Override
    protected OracleDdlReader createDdlReader() {
        return new OracleDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected OracleJdbcSqlTemplate createSqlTemplate() {
        return new OracleJdbcSqlTemplate(this.dataSource, this.settings, new OracleLobHandler(this.settings.getJdbcLobHandling()), this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public String getName() {
        return "oracle";
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM dual", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return !this.isLob(column.getJdbcTypeCode()) && !this.isGeometry(column) && super.canColumnBeUsedInWhereClause(column);
    }

    private boolean isGeometry(Column column) {
        String name = column.getJdbcTypeName();
        return name != null && (name.toUpperCase().contains("GEOMETRY") || name.toUpperCase().contains("GEOGRAPHY"));
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE OR REPLACE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " BEGIN END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getExecuteSymPermission() {
        String executeSql = "SELECT DBMS_LOB.GETLENGTH('TEST'), UTL_RAW.CAST_TO_RAW('TEST') FROM DUAL";
        PermissionResult result = new PermissionResult(PermissionType.EXECUTE, executeSql);
        try {
            this.getSqlTemplate().update(executeSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant EXECUTE on DBMS_LOB and UTL_RAW");
        }
        return result;
    }

    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "Use LogMiner");
        try {
            StringBuilder missingGrants = new StringBuilder();
            for (String name : new String[]{"EXECUTE_CATALOG_ROLE"}) {
                if (this.hasPrivilege(name)) continue;
                if (missingGrants.length() > 0) {
                    missingGrants.append(", ");
                }
                missingGrants.append(name);
            }
            Object[] systemPrivs = new String[]{"SELECT ANY DICTIONARY", "ALTER SESSION", "SELECT ANY TRANSACTION"};
            if (this.sqlTemplate.getDatabaseMajorVersion() >= 12) {
                systemPrivs = (String[])ArrayUtils.add((Object[])systemPrivs, (Object)"LOGMINING");
            }
            for (Object name : systemPrivs) {
                if (this.hasSystemPrivilege((String)name)) continue;
                if (missingGrants.length() > 0) {
                    missingGrants.append(", ");
                }
                missingGrants.append((String)name);
            }
            String logMode = this.getSqlTemplate().queryForString("SELECT LOG_MODE FROM V$DATABASE", new Object[0]);
            if (!logMode.equals("ARCHIVELOG")) {
                if (missingGrants.length() > 0) {
                    missingGrants.append(", ");
                }
                missingGrants.append("DATABASE MUST BE IN ARCHIVE LOG MODE");
            }
            if (missingGrants.length() > 0) {
                this.log.error("Missing privileges: {}", (Object)missingGrants.toString());
                result.setSolution("Grant " + missingGrants.toString());
                result.setStatus(PermissionResult.Status.FAIL);
            } else {
                result.setStatus(PermissionResult.Status.PASS);
            }
            String supplementalLogging = this.sqlTemplate.queryForString("select SUPPLEMENTAL_LOG_DATA_ALL from v$database", new Object[0]);
            if ("NO".equals(supplementalLogging)) {
                this.log.error("Missing Oracle log miner alter for supplemental log data.");
                result.setSolution("alter database add supplemental log data (all) columns");
                result.setStatus(PermissionResult.Status.FAIL);
                return result;
            }
        }
        catch (Exception e) {
            this.log.error("Error checking privileges", (Throwable)e);
            result.setException(e);
            result.setStatus(PermissionResult.Status.FAIL);
            return result;
        }
        return result;
    }

    private boolean hasSystemPrivilege(String name) {
        return this.getSqlTemplate().queryForInt("select count(*) from user_sys_privs where privilege = ?", new Object[]{name}) > 0;
    }

    private boolean hasPrivilege(String name) {
        return this.getSqlTemplate().queryForInt("select count(*) from user_role_privs where granted_role = ?", new Object[]{name}) > 0;
    }

    public long getEstimatedRowCount(Table table) {
        return this.getSqlTemplateDirty().queryForLong("select nvl(num_rows, -1) from all_tables where table_name = ? and owner = ?", new Object[]{table.getName(), table.getSchema()});
    }

    public List<Transaction> getTransactions() {
        ISqlTemplate template = this.getSqlTemplate();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (template.getDatabaseMajorVersion() >= 10) {
            String sql = "select  blocked.sid,  blocked.username,  blocked.status,  blocked.blocking_session,  sql.last_load_time,  sql.sql_text from v$session blocked left join v$sqlarea sql  on blocked.sql_id = sql.sql_id";
            for (Row row : template.query(sql)) {
                Transaction transaction = new Transaction(row.getString("sid"), row.getString("username"), row.getString("blocking_session"), row.getDateTime("last_load_time"), row.getString("sql_text"));
                transaction.setStatus(row.getString("status"));
                transactions.add(transaction);
            }
        }
        return transactions;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        int orderIndex = StringUtils.lastIndexOfIgnoreCase((CharSequence)sql, (CharSequence)"order by");
        String order = sql.substring(orderIndex);
        String innerSql = sql.substring(0, orderIndex - 1);
        innerSql = StringUtils.replaceIgnoreCase((String)innerSql, (String)" from", (String)(", ROW_NUMBER() over (" + order + ") as row_num from"));
        return "select * from (" + innerSql + ") where row_num between " + (offset + 1) + " and " + (offset + limit);
    }

    public String massageForObjectAlreadyExists(String sql) {
        if (sql.toUpperCase().contains("CREATE TABLE")) {
            return sql;
        }
        return StringUtils.replaceOnceIgnoreCase((String)sql, (String)"create", (String)"create or replace");
    }

    public boolean supportsSliceTables() {
        return true;
    }

    public String getSliceTableSql(String columnName, int sliceNum, int totalSlices) {
        return "mod(ora_hash(rowid), " + totalSlices + ") = " + sliceNum;
    }

    public String getCharSetName() {
        return (String)this.getSqlTemplate().queryForObject("select value from nls_database_parameters where\r\nparameter='NLS_CHARACTERSET'", String.class, new Object[0]);
    }
}

