/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.raima;

import javax.sql.DataSource;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.raima.RaimaDdlBuilder;
import org.jumpmind.db.platform.raima.RaimaDdlReader;
import org.jumpmind.db.platform.raima.RaimaJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class RaimaDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.raima.rdm.jdbc.RDMDriverr";
    public static final String JDBC_SUBPROTOCOL = "raima";

    public RaimaDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.supportsTruncate = false;
        this.getDatabaseInfo().setRequiresAutoCommitForDdl(true);
    }

    protected RaimaDdlBuilder createDdlBuilder() {
        return new RaimaDdlBuilder();
    }

    @Override
    protected RaimaDdlReader createDdlReader() {
        return new RaimaDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected RaimaJdbcSqlTemplate createSqlTemplate() {
        return new RaimaJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        return null;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String createTriggerSql = "create trigger test_trigger after insert on SYM_PERMISSION_TEST for each row begin atomic end";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, createTriggerSql);
        try {
            this.getSqlTemplate().update(createTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE DATABASE permission and TRIGGER permission");
        }
        return result;
    }

    protected PermissionResult getDropSymTriggerPermission() {
        String dropTriggerSql = "drop trigger test_trigger";
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE DATABASE permission and TRIGGER permission");
        }
        return result;
    }
}

