/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;

public class RedshiftDdlReader
extends AbstractJdbcDdlReader {
    protected static Map<String, String> columnNames = RedshiftDdlReader.mapNames();

    public RedshiftDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
    }

    protected static Map<String, String> mapNames() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("IS_NULLABLE", "NULLABLE");
        return values;
    }

    @Override
    protected String getName(String defaultName) {
        String name = columnNames.get(defaultName);
        if (name == null) {
            name = super.getName(defaultName);
        }
        return name;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
        }
        return table;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String defaultValue;
        Column column = super.readColumn(metaData, values);
        if (column.getJdbcTypeCode() == 12 && column.getSizeAsInt() == 65535) {
            column.setJdbcTypeCode(-1);
            column.setMappedTypeCode(-1);
            column.setSize(null);
        }
        if ((defaultValue = column.getDefaultValue()) != null && defaultValue.length() > 0) {
            if (defaultValue.startsWith("\"identity\"")) {
                column.setAutoIncrement(true);
                defaultValue = null;
            } else {
                switch (column.getMappedTypeCode()) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: {
                        defaultValue = this.extractUndelimitedDefaultValue(defaultValue);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        defaultValue = this.extractDelimitedDefaultValue(defaultValue);
                    }
                }
                if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                    defaultValue = this.unescape(defaultValue, "'", "''");
                }
            }
            column.setDefaultValue(defaultValue);
        }
        return column;
    }

    private String extractDelimitedDefaultValue(String defaultValue) {
        int valueEnd;
        if (defaultValue.startsWith("'") && (valueEnd = defaultValue.indexOf("'::")) > 0) {
            return defaultValue.substring("'".length(), valueEnd);
        }
        return defaultValue;
    }

    private String extractUndelimitedDefaultValue(String defaultValue) {
        int valueEnd = defaultValue.indexOf("::");
        if (valueEnd > 0) {
            defaultValue = defaultValue.substring(0, valueEnd);
            int startParen = defaultValue.indexOf("(");
            int endParen = defaultValue.indexOf(")");
            if (startParen > 0 && endParen < 0) {
                defaultValue = defaultValue + ")";
            }
        } else if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
            defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
        }
        return defaultValue;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return table.doesIndexContainOnlyPrimaryKeyColumns(index);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT trigger_name, trigger_schema, trigger_catalog, event_manipulation AS trigger_type, event_object_table AS table_name,trig.*, pgproc.prosrc FROM INFORMATION_SCHEMA.TRIGGERS AS trig INNER JOIN pg_catalog.pg_trigger AS pgtrig ON pgtrig.tgname=trig.trigger_name INNER JOIN pg_catalog.pg_proc AS pgproc ON pgproc.oid=pgtrig.tgfoid WHERE event_object_table=? AND event_object_schema=?;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setCatalogName(row.getString("trigger_catalog"));
                trigger.setSchemaName(row.getString("trigger_schema"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("prosrc"));
                row.remove((Object)"prosrc");
                String triggerType = row.getString("trigger_type");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    @Override
    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }

    @Override
    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
    }
}

