/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlanywhere;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class SqlAnywhereDdlReader
extends AbstractJdbcDdlReader {
    private Pattern isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
    private Pattern isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");

    public SqlAnywhereDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            Column[] columns;
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
            for (Column column : columns = table.getColumns()) {
                if (!column.isAutoIncrement() || !"autoincrement".equalsIgnoreCase(column.getDefaultValue())) continue;
                column.setDefaultValue(null);
            }
        }
        return table;
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.toUpperCase().startsWith("TEXT")) {
            return -1;
        }
        if (typeName != null && typeName.toUpperCase().startsWith("NTEXT")) {
            return -16;
        }
        if (typeName != null && typeName.toUpperCase().startsWith("LONG NVARCHAR")) {
            return -16;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 1) {
            column.setMappedTypeCode(12);
            column.setMappedType("VARCHAR");
        }
        if (column.getMappedTypeCode() == 2 && column.getSizeAsInt() == 19 && column.getScale() == 0) {
            column.setMappedTypeCode(-5);
        } else if (column.getDefaultValue() != null) {
            if (column.getMappedTypeCode() == 93) {
                Matcher matcher = this.isoDatePattern.matcher(column.getDefaultValue());
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this.isoTimePattern.matcher(column.getDefaultValue());
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
            }
        }
        return column;
    }

    @Override
    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, IIndex> knownIndices) throws SQLException {
        String indexName;
        if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() && (indexName = (String)values.get("INDEX_NAME")) != null) {
            String delimiter = this.getPlatformInfo().getDelimiterToken();
            if (indexName != null && indexName.startsWith(delimiter) && indexName.endsWith(delimiter)) {
                indexName = indexName.substring(delimiter.length(), indexName.length() - delimiter.length());
                values.put("INDEX_NAME", indexName);
            }
        }
        super.readIndex(metaData, values, knownIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT name = si.name FROM dbo.sysindexes si, dbo.sysobjects so WHERE so.name = '");
        query.append(table.getName());
        query.append("' AND si.name = '");
        query.append(index.getName());
        query.append("' AND so.id = si.id AND (si.status & 2048) > 0");
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery(query.toString());
            boolean result = rs.next();
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT trigname AS trigger_name, owner, tname AS table_name, event AS trigger_type, trigtime AS trigger_time, trigdefn FROM SYS.SYSTRIGGERS WHERE tname=? and owner=? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setSchemaName(row.getString("owner"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("trigdefn"));
                row.remove((Object)"trigdefn");
                String triggerType = row.getString("trigger_type");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }
}

