/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlite;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.sqlite.SqliteDdlBuilder;
import org.jumpmind.db.platform.sqlite.SqliteDdlReader;
import org.jumpmind.db.platform.sqlite.SqliteDmlStatement;
import org.jumpmind.db.platform.sqlite.SqliteJdbcSqlTemplate;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class SqliteDatabasePlatform
extends AbstractJdbcDatabasePlatform
implements IDatabasePlatform {
    public static final String JDBC_DRIVER = "org.sqlite.JDBC";
    public static final String JDBC_SUBPROTOCOL = "sqlite";
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();

    public SqliteDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "strftime('%Y-%m-%d %H:%M:%f','now','localtime')");
        this.sqlScriptReplacementTokens.put("\\{ts([^<]*?)\\}", "$1");
        this.sqlScriptReplacementTokens.put("\\{d([^<]*?)\\}", "$1");
        this.supportsTruncate = false;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        return null;
    }

    protected SqliteDdlBuilder createDdlBuilder() {
        return new SqliteDdlBuilder();
    }

    protected SqliteDdlReader createDdlReader() {
        return new SqliteDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected ISqlTemplate createSqlTemplate() {
        return new SqliteJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        SqliteJdbcSqlTemplate sqlTemplateDirty = new SqliteJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
        sqlTemplateDirty.setIsolationLevel(1);
        return sqlTemplateDirty;
    }

    public DmlStatement createDmlStatement(DmlStatementOptions options) {
        return new SqliteDmlStatement(options.databaseInfo(this.getDatabaseInfo()));
    }

    protected String getDateTimeStringValue(String name, int type, Row row, boolean useVariableDates) {
        return row.getString(name);
    }

    protected Object parseBigDecimal(String value) {
        if ("".equals(value)) {
            return value;
        }
        return super.parseBigDecimal(value);
    }

    protected Object parseBigInteger(String value) {
        if ("".equals(value)) {
            return value;
        }
        return super.parseBigInteger(value);
    }

    protected Object parseInteger(String value) {
        if ("".equals(value)) {
            return value;
        }
        return super.parseInteger(value);
    }

    protected PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + "FOR EACH ROW BEGIN SELECT 1; END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsMultiThreadedTransactions() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }
}

