/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.tibero;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.tibero.TiberoDdlBuilder;
import org.jumpmind.db.platform.tibero.TiberoDdlReader;
import org.jumpmind.db.platform.tibero.TiberoJdbcSqlTemplate;
import org.jumpmind.db.platform.tibero.TiberoLobHandler;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class TiberoDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.tmax.tibero.jdbc.TbDriver";
    public static final String JDBC_SUBPROTOCOL_THIN = "tibero:thin";

    public TiberoDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected TiberoDdlBuilder createDdlBuilder() {
        return new TiberoDdlBuilder();
    }

    @Override
    protected TiberoDdlReader createDdlReader() {
        return new TiberoDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected TiberoJdbcSqlTemplate createSqlTemplate() {
        return new TiberoJdbcSqlTemplate(this.dataSource, this.settings, new TiberoLobHandler(), this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public String getName() {
        return "tibero";
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM dual", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        String jdbcTypeName = column.getJdbcTypeName();
        return !this.isLob(column.getJdbcTypeCode()) && !column.isOfBinaryType() && !"RAW".equals(jdbcTypeName) && super.canColumnBeUsedInWhereClause(column);
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE OR REPLACE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " BEGIN END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getExecuteSymPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String executeSql = "SELECT DBMS_LOB.GETLENGTH('TEST'), UTL_RAW.CAST_TO_RAW('TEST') FROM DUAL";
        PermissionResult result = new PermissionResult(PermissionType.EXECUTE, executeSql);
        try {
            this.getSqlTemplate().update(executeSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant EXECUTE on DBMS_LOB and UTL_RAW");
        }
        return result;
    }

    public long getEstimatedRowCount(Table table) {
        return this.getSqlTemplateDirty().queryForLong("select nvl(num_rows,-1) from all_tables where table_name = ? and owner = ?", new Object[]{table.getName(), table.getSchema()});
    }
}

