/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.compression.CompressionServletResponseWrapper;

public abstract class AbstractCompressionUriHandler
extends AbstractUriHandler {
    public AbstractCompressionUriHandler(String uriPattern, IParameterService parameterService, IInterceptor ... interceptors) {
        super(uriPattern, parameterService, interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        boolean compressionEnabled;
        boolean bl = compressionEnabled = !this.parameterService.is("web.compression.disabled");
        if (compressionEnabled) {
            int compressionLevel = this.parameterService.getInt("compression.level");
            int compressionStrategy = this.parameterService.getInt("compression.strategy");
            this.log.debug("@doFilter");
            boolean supportCompression = false;
            this.log.debug("requestURI= {}", (Object)req.getRequestURI());
            String s = req.getParameter("gzip");
            if ("false".equals(s)) {
                this.log.debug("Got parameter of gzip=false.  Don't compress, just chain filter.");
                this.handleWithCompression(req, res);
                return;
            }
            Enumeration e = req.getHeaders("Accept-Encoding");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.indexOf("gzip") != -1) {
                    this.log.debug("Supports compression.");
                    supportCompression = true;
                    continue;
                }
                this.log.debug("Does not support compression.");
            }
            if (!supportCompression) {
                this.log.debug("doFilter gets called without compression");
                this.handleWithCompression(req, res);
                return;
            }
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(res, compressionLevel, compressionStrategy);
            this.log.debug("doFilter gets called with compression");
            try {
                this.handleWithCompression(req, (HttpServletResponse)wrappedResponse);
            }
            finally {
                wrappedResponse.finishResponse();
            }
            return;
        }
        this.handleWithCompression(req, res);
    }

    protected abstract void handleWithCompression(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
}

