/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.web.AuthenticationSession;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInterceptor
implements IInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private INodeService nodeService;
    private ISecurityService securityService;
    private Map<String, AuthenticationSession> sessions = new ConcurrentHashMap<String, AuthenticationSession>();
    private boolean useSessionAuth;
    private int sessionExpireMillis;
    private int maxSessions;
    private long maxSessionsLastTime;

    public AuthenticationInterceptor(INodeService nodeService, ISecurityService securityService, boolean useSessionAuth, int sessionExpireSeconds, int maxSessions) {
        this.nodeService = nodeService;
        this.securityService = securityService;
        this.useSessionAuth = useSessionAuth;
        this.sessionExpireMillis = sessionExpireSeconds * 1000;
        this.maxSessions = maxSessions;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean before(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AuthenticationSession session;
        X509Certificate[] certs;
        String nodeId = null;
        String securityToken = null;
        INodeService.AuthenticationStatus status = null;
        if (this.log.isDebugEnabled() && (certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
            this.log.debug("Client cert: " + certs[0].getSubjectX500Principal().getName());
        }
        if (this.useSessionAuth && req.getHeader("Session-ID") != null) {
            session = this.getSession(req, false);
            if (session == null) {
                nodeId = req.getParameter("nodeId");
                this.log.debug("Node '{}' has unknown session ID", (Object)nodeId);
                ServletUtils.sendError(resp, 669);
                return false;
            }
            nodeId = (String)session.getAttribute("nodeId");
            securityToken = (String)session.getAttribute("securityToken");
            if (!StringUtils.isEmpty((CharSequence)securityToken) && !StringUtils.isEmpty((CharSequence)nodeId)) {
                status = this.nodeService.getAuthenticationStatus(nodeId, securityToken);
            }
            if (status == null || status == INodeService.AuthenticationStatus.FORBIDDEN || status == INodeService.AuthenticationStatus.ACCEPTED && this.sessionExpireMillis > 0 && System.currentTimeMillis() - session.getCreationTime() > (long)this.sessionExpireMillis) {
                this.log.debug("Node '{}' needs to renew authentication", (Object)nodeId);
                ServletUtils.sendError(resp, 669);
                return false;
            }
        } else {
            securityToken = req.getHeader("Security-Token");
            if (securityToken == null) {
                securityToken = req.getParameter("securityToken");
            }
            nodeId = req.getParameter("nodeId");
            if (StringUtils.isEmpty((CharSequence)securityToken) || StringUtils.isEmpty((CharSequence)nodeId)) {
                if (!StringUtils.isEmpty((CharSequence)nodeId)) {
                    this.log.warn("Node '{}' failed to authenticate.  It is missing the security token", (Object)nodeId);
                }
                ServletUtils.sendError(resp, 659);
                return false;
            }
            status = this.nodeService.getAuthenticationStatus(nodeId, securityToken);
            if (this.useSessionAuth && status == INodeService.AuthenticationStatus.ACCEPTED) {
                session = this.getSession(req, true);
                session.setAttribute("nodeId", nodeId);
                session.setAttribute("securityToken", securityToken);
                resp.setHeader("Set-Session-ID", session.getId());
            }
        }
        if (status == INodeService.AuthenticationStatus.ACCEPTED) {
            this.log.debug("Node '{}' successfully authenticated", (Object)nodeId);
            this.nodeService.resetNodeFailedLogins(nodeId);
            return true;
        }
        if (status == INodeService.AuthenticationStatus.REGISTRATION_REQUIRED) {
            this.log.debug("Node '{}' failed to authenticate.  It was not registered", (Object)nodeId);
            ServletUtils.sendError(resp, 657);
            return false;
        }
        if (status == INodeService.AuthenticationStatus.SYNC_DISABLED) {
            this.log.debug("Node '{}' failed to authenticate.  It was not enabled", (Object)nodeId);
            ServletUtils.sendError(resp, 658);
            return false;
        }
        if (status == INodeService.AuthenticationStatus.LOCKED) {
            this.log.warn("Node '{}' failed to authenticate.  It had too many login attempts", (Object)nodeId);
        } else {
            this.log.warn("Node '{}' failed to authenticate.  It had the wrong password", (Object)nodeId);
            this.nodeService.incrementNodeFailedLogins(nodeId);
        }
        ServletUtils.sendError(resp, 659);
        return false;
    }

    protected AuthenticationSession getSession(HttpServletRequest req, boolean create) {
        String sessionId = req.getHeader("Session-ID");
        AuthenticationSession session = null;
        if (sessionId != null) {
            session = this.sessions.get(sessionId);
        }
        if (session == null && create) {
            String nodeId = req.getParameter("nodeId");
            for (AuthenticationSession existingSession : this.sessions.values()) {
                if (!nodeId.equals(existingSession.getAttribute("nodeId"))) continue;
                session = existingSession;
                session.setCreationTime(System.currentTimeMillis());
                break;
            }
            if (session == null) {
                if (this.sessions.size() >= this.maxSessions) {
                    this.removeOldSessions();
                }
                String id = this.securityService.nextSecureHexString(30);
                session = new AuthenticationSession(id);
                this.sessions.put(id, session);
            }
        }
        return session;
    }

    protected synchronized void removeOldSessions() {
        long now = System.currentTimeMillis();
        int removedSessions = 0;
        AuthenticationSession oldestSession = null;
        Iterator<AuthenticationSession> iter = this.sessions.values().iterator();
        while (iter.hasNext()) {
            AuthenticationSession session = iter.next();
            if (now - session.getCreationTime() > (long)this.sessionExpireMillis) {
                iter.remove();
                ++removedSessions;
                continue;
            }
            if (oldestSession != null && session.getCreationTime() >= oldestSession.getCreationTime()) continue;
            oldestSession = session;
        }
        if (removedSessions == 0 && oldestSession != null) {
            this.sessions.remove(oldestSession.getId());
        }
        if (this.maxSessionsLastTime == 0L || now - this.maxSessionsLastTime > 60000L) {
            this.maxSessionsLastTime = now;
            this.log.warn("Max node authentication sessions reached, removing old sessions. See parameter http.session.max.count");
        }
    }

    @Override
    public void after(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
    }
}

