/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.BandwidthTestResults;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.util.AppUtils;

public class BandwidthSamplerUriHandler
extends AbstractUriHandler {
    protected long defaultTestSlowBandwidthDelay = 0L;
    protected Gson gson = new Gson();

    public BandwidthSamplerUriHandler(IParameterService parameterService, IInterceptor[] interceptors) {
        super("/bandwidth/*", parameterService, interceptors);
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String direction = req.getParameter("direction");
        if (direction != null && direction.equals("pull")) {
            this.handlePull(req, res);
        } else if (direction != null && direction.equals("push")) {
            this.handlePush(req, res);
        } else {
            throw new IOException("Unknown direction: " + direction);
        }
    }

    private void handlePull(HttpServletRequest req, HttpServletResponse res) throws IOException {
        long testSlowBandwidthDelay = this.parameterService != null ? this.parameterService.getLong("test.slow.bandwidth.delay") : this.defaultTestSlowBandwidthDelay;
        long sampleSize = 1000L;
        try {
            sampleSize = Long.parseLong(req.getParameter("sampleSize"));
        }
        catch (Exception ex) {
            this.log.warn("Unable to parse sampleSize of {}", (Object)req.getParameter("sampleSize"));
        }
        ServletOutputStream os = res.getOutputStream();
        int i = 0;
        while ((long)i < sampleSize) {
            os.write(1);
            if (testSlowBandwidthDelay > 0L) {
                AppUtils.sleep((long)testSlowBandwidthDelay);
            }
            ++i;
        }
    }

    private void handlePush(HttpServletRequest req, HttpServletResponse res) throws IOException {
        BandwidthTestResults bwtr = new BandwidthTestResults();
        bwtr.start();
        byte[] b = new byte[1024];
        int count = 0;
        InputStream inputStream = this.createInputStream(req);
        ServletOutputStream outputStream = res.getOutputStream();
        while ((count = inputStream.read(b, 0, b.length)) != -1) {
            bwtr.transmitted(count);
        }
        bwtr.stop();
        this.log.debug(this.gson.toJson((Object)bwtr));
        outputStream.write(this.gson.toJson((Object)bwtr).getBytes(Charset.defaultCharset()));
    }

    @Override
    protected InputStream createInputStream(HttpServletRequest req) throws IOException {
        Object is = null;
        String contentType = req.getHeader("Content-Type");
        boolean useCompression = contentType != null && contentType.equalsIgnoreCase("gzip");
        is = req.getInputStream();
        if (useCompression) {
            is = new GZIPInputStream((InputStream)is);
        }
        return is;
    }

    public void setDefaultTestSlowBandwidthDelay(long defaultTestSlowBandwidthDelay) {
        this.defaultTestSlowBandwidthDelay = defaultTestSlowBandwidthDelay;
    }
}

