/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class FileSyncPushUriHandler
extends AbstractUriHandler {
    private ISymmetricEngine engine;

    public FileSyncPushUriHandler(ISymmetricEngine engine, IInterceptor ... interceptors) {
        super("/filesync/push/*", engine.getParameterService(), interceptors);
        this.engine = engine;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, FileUploadException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            ServletUtils.sendError(res, 400, "Node must be specified");
            return;
        }
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            ServletUtils.sendError(res, 400, "We only handle multipart requests");
            return;
        }
        this.log.debug("File sync push request received from {}", (Object)nodeId);
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator iter = upload.getItemIterator(req);
        while (iter.hasNext()) {
            FileItemStream item = iter.next();
            String name = item.getFieldName();
            if (item.isFormField()) continue;
            this.log.debug("Processing upload file field " + name + " with file name " + item.getName() + " detected.");
            this.engine.getFileSyncService().loadFilesFromPush(nodeId, item.openStream(), (OutputStream)res.getOutputStream());
        }
        res.flushBuffer();
    }
}

