/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConcurrencyInterceptor
implements IInterceptor {
    private static Logger log = LoggerFactory.getLogger(NodeConcurrencyInterceptor.class);
    private IConcurrentConnectionManager concurrentConnectionManager;
    private IConfigurationService configurationService;
    private INodeService nodeService;
    private IStatisticManager statisticManager;

    public NodeConcurrencyInterceptor(IConcurrentConnectionManager concurrentConnectionManager, IConfigurationService configurationService, INodeService nodeService, IStatisticManager statisticManager) {
        this.concurrentConnectionManager = concurrentConnectionManager;
        this.configurationService = configurationService;
        this.nodeService = nodeService;
        this.statisticManager = statisticManager;
    }

    @Override
    public boolean before(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        String method = req.getMethod();
        String threadChannel = req.getHeader("threadChannel");
        boolean isPush = ServletUtils.normalizeRequestUri(req).contains("push");
        if (method.equals("HEAD") && isPush) {
            NodeSecurity nodeSecurity;
            NodeSecurity identity;
            resp.setContentLength(0);
            if (!this.concurrentConnectionManager.reserveConnection(nodeId, threadChannel, poolId, IConcurrentConnectionManager.ReservationType.SOFT)) {
                this.statisticManager.incrementNodesRejected(1L);
                ServletUtils.sendError(resp, 670);
            } else {
                try {
                    this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
                }
                catch (Exception ex) {
                    this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
                    log.error("Error building response headers", (Throwable)ex);
                    ServletUtils.sendError(resp, 601);
                }
            }
            if (this.configurationService.isMasterToMaster() && this.nodeService.isDataLoadStarted() && (identity = this.nodeService.findNodeSecurity(this.nodeService.findIdentityNodeId(), true)) != null && nodeId != null && "registration".equals(identity.getInitialLoadCreateBy()) && !nodeId.equals(identity.getCreatedAtNodeId())) {
                log.debug("Not allowing push from node {} until initial load from {} is complete", (Object)nodeId, (Object)identity.getCreatedAtNodeId());
                ServletUtils.sendError(resp, 668);
            }
            if ((nodeSecurity = this.nodeService.findNodeSecurity(nodeId, true)) != null) {
                String createdAtNodeId = nodeSecurity.getCreatedAtNodeId();
                if (nodeSecurity.isRegistrationEnabled() && (createdAtNodeId == null || createdAtNodeId.equals(this.nodeService.findIdentityNodeId()))) {
                    if (nodeSecurity.getRegistrationTime() != null) {
                        ServletUtils.sendError(resp, 667);
                    }
                    ServletUtils.sendError(resp, 657);
                }
            }
            return false;
        }
        if (threadChannel != null) {
            if (this.concurrentConnectionManager.reserveConnection(nodeId, threadChannel, poolId, IConcurrentConnectionManager.ReservationType.HARD)) {
                try {
                    this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
                    return true;
                }
                catch (Exception ex) {
                    this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
                    log.error("Error building response headers", (Throwable)ex);
                    ServletUtils.sendError(resp, 601);
                    return false;
                }
            }
            this.statisticManager.incrementNodesRejected(1L);
            if (isPush) {
                log.warn("Missing reservation for push, so rejecting node {}", new Object[]{nodeId});
            }
            ServletUtils.sendError(resp, isPush ? 604 : 670);
            return false;
        }
        if (this.concurrentConnectionManager.reserveConnection(nodeId, poolId, IConcurrentConnectionManager.ReservationType.HARD)) {
            try {
                this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
                return true;
            }
            catch (Exception ex) {
                this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
                log.error("Error building response headers", (Throwable)ex);
                ServletUtils.sendError(resp, 601);
                return false;
            }
        }
        this.statisticManager.incrementNodesRejected(1L);
        ServletUtils.sendError(resp, isPush ? 604 : 670);
        return false;
    }

    protected String getNodeId(HttpServletRequest req) {
        String nodeId = StringUtils.trimToNull((String)req.getParameter("nodeId"));
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = StringUtils.trimToNull((String)req.getParameter("externalId"));
        }
        return nodeId;
    }

    @Override
    public void after(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        String threadChannel = req.getHeader("threadChannel");
        this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
    }

    protected void buildSuspendIgnoreResponseHeaders(String nodeId, ServletResponse resp) {
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
        httpResponse.setHeader("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
        httpResponse.setHeader("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
    }
}

