/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.RegistrationPendingException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class PushUriHandler
extends AbstractUriHandler {
    private IDataLoaderService dataLoaderService;
    private IStatisticManager statisticManager;
    private INodeService nodeService;

    public PushUriHandler(IParameterService parameterService, IDataLoaderService dataLoaderService, IStatisticManager statisticManager, INodeService nodeService, IInterceptor ... interceptors) {
        super("/push/*", parameterService, interceptors);
        this.dataLoaderService = dataLoaderService;
        this.statisticManager = statisticManager;
        this.nodeService = nodeService;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        this.log.debug("Push requested from node {} at remote address {}", (Object)nodeId, (Object)req.getRemoteAddr());
        InputStream inputStream = this.createInputStream(req);
        ServletOutputStream outputStream = res.getOutputStream();
        String threadChannel = req.getHeader("threadChannel");
        int rc = this.push(nodeId, threadChannel, inputStream, (OutputStream)outputStream);
        if (rc != 200) {
            res.sendError(rc);
        }
        res.flushBuffer();
        this.log.debug("Push completed for {} at remote address {}", (Object)nodeId, (Object)req.getRemoteAddr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int push(String sourceNodeId, String channelId, InputStream inputStream, OutputStream outputStream) throws IOException {
        long ts = System.currentTimeMillis();
        try {
            Node sourceNode = this.nodeService.findNode(sourceNodeId, true);
            this.dataLoaderService.loadDataFromPush(sourceNode, channelId, inputStream, outputStream);
        }
        catch (RegistrationPendingException e) {
            int n = 667;
            return n;
        }
        catch (RegistrationRequiredException e) {
            int n = 657;
            return n;
        }
        finally {
            this.statisticManager.incrementNodesPushed(1L);
            this.statisticManager.incrementTotalNodesPushedTime(System.currentTimeMillis() - ts);
        }
        return 200;
    }
}

