/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;

public class ServletUtils {
    public static boolean sendError(HttpServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static String whereAreYou(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean sendError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (!resp.isCommitted()) {
            resp.sendError(statusCode, StringEscapeUtils.escapeHtml4((String)message));
            retVal = true;
        }
        return retVal;
    }

    public static boolean sendError(ServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static boolean sendError(ServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (resp instanceof HttpServletResponse) {
            retVal = ServletUtils.sendError((HttpServletResponse)resp, statusCode, message);
        }
        return retVal;
    }

    public static String normalizeRequestUri(HttpServletRequest httpRequest) {
        String servletPath;
        String contextPath;
        String retVal = httpRequest.getRequestURI();
        if (retVal.startsWith(contextPath = httpRequest.getContextPath())) {
            retVal = retVal.substring(contextPath.length());
        }
        if (retVal.startsWith(servletPath = httpRequest.getServletPath())) {
            retVal = retVal.substring(servletPath.length());
        }
        return retVal;
    }

    public static String getParameter(HttpServletRequest request, String name) {
        return StringUtils.trimToNull((String)request.getParameter(name));
    }

    public static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToNull((String)request.getParameter(name)), (CharSequence)defaultValue);
    }

    public static long getParameterAsNumber(HttpServletRequest request, String name) {
        return NumberUtils.toLong((String)StringUtils.trimToNull((String)request.getParameter(name)));
    }

    public static SymmetricEngineHolder getSymmetricEngineHolder(ServletContext ctx) {
        return (SymmetricEngineHolder)ctx.getAttribute("symmetricEngineHolder");
    }
}

