/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.extension.IProgressListener;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.IInitialLoadService;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.IMailService;
import org.jumpmind.symmetric.service.IMonitorService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOfflinePullService;
import org.jumpmind.symmetric.service.IOfflinePushService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.IUpdateService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.slf4j.Logger;

public interface ISymmetricEngine {
    public void stop();

    public void destroy();

    public void uninstall();

    public String getSyncUrl();

    public Properties getProperties();

    public String getEngineName();

    public void setup();

    public boolean start();

    public boolean start(boolean var1);

    public String reloadNode(String var1, String var2);

    public String sendSQL(String var1, String var2, String var3, String var4, String var5);

    public RemoteNodeStatuses push();

    public boolean syncTriggers();

    public boolean forceTriggerRebuild();

    public NodeStatus getNodeStatus();

    public RemoteNodeStatuses pull();

    public void route();

    public void purge();

    public boolean isConfigured();

    public void heartbeat(boolean var1);

    public void openRegistration(String var1, String var2);

    public void reOpenRegistration(String var1);

    public boolean isRegistered();

    public boolean isStarted();

    public boolean isInitialized();

    public boolean isStarting();

    public void clearCaches();

    public void setupDatabase(boolean var1);

    public void removeAndCleanupNode(String var1);

    public IConfigurationService getConfigurationService();

    public IParameterService getParameterService();

    public INodeService getNodeService();

    public IRegistrationService getRegistrationService();

    public IClusterService getClusterService();

    public IPurgeService getPurgeService();

    public IDataService getDataService();

    public ISymmetricDialect getSymmetricDialect();

    public ISymmetricDialect getTargetDialect();

    public IJobManager getJobManager();

    public IOutgoingBatchService getOutgoingBatchService();

    public IAcknowledgeService getAcknowledgeService();

    public IBandwidthService getBandwidthService();

    public IDataExtractorService getDataExtractorService();

    public IDataExtractorService getFileSyncExtractorService();

    public IDataLoaderService getDataLoaderService();

    public IIncomingBatchService getIncomingBatchService();

    public IPullService getPullService();

    public IPushService getPushService();

    public IOfflinePullService getOfflinePullService();

    public IOfflinePushService getOfflinePushService();

    public IRouterService getRouterService();

    public ISecurityService getSecurityService();

    public IStatisticService getStatisticService();

    public ITriggerRouterService getTriggerRouterService();

    public IGroupletService getGroupletService();

    public IStatisticManager getStatisticManager();

    public String getDeploymentType();

    public String getDeploymentSubType();

    public IConcurrentConnectionManager getConcurrentConnectionManager();

    public ITransformService getTransformService();

    public ILoadFilterService getLoadFilterService();

    public IInitialLoadService getInitialLoadService();

    public ITransportManager getTransportManager();

    public INodeCommunicationService getNodeCommunicationService();

    public ISequenceService getSequenceService();

    public String getTablePrefix();

    public Logger getLog();

    public IExtensionService getExtensionService();

    public IMonitorService getMonitorService();

    public IMailService getMailService();

    public IStagingManager getStagingManager();

    public ISqlTemplate getSqlTemplate();

    public IFileSyncService getFileSyncService();

    public IContextService getContextService();

    public IUpdateService getUpdateService();

    public Date getLastRestartTime();

    public <T> T getDataSource();

    public IDatabasePlatform getDatabasePlatform();

    public File snapshot(IProgressListener var1);

    public List<File> listSnapshots();

    public String getNodeId();

    public Throwable getLastException();

    public String getLastExceptionMessage();

    public String getEngineDescription(String var1);

    public ICacheManager getCacheManager();
}

