/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupChannelWindow;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IParameterService;

public class ConfigurationCache {
    private IParameterService parameterService;
    private IConfigurationService configurationService;
    private Object configurationCacheLock = new Object();
    private volatile Map<String, List<NodeChannel>> nodeChannelCache;
    private volatile Map<String, Channel> channelsCache;
    private volatile List<NodeGroupLink> nodeGroupLinksCache;
    private volatile Map<String, List<NodeGroupChannelWindow>> channelWindowsByChannelCache;
    private volatile long channelCacheTime;
    private volatile long nodeChannelCacheTime;
    private volatile long nodeGroupLinkCacheTime;
    private volatile long channelWindowsByChannelCacheTime;

    public ConfigurationCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.configurationService = engine.getConfigurationService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeChannel> getNodeChannels(String nodeId) {
        List<NodeChannel> nodeChannels;
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms");
        Object object = this.configurationCacheLock;
        synchronized (object) {
            List<NodeChannel> list = nodeChannels = this.nodeChannelCache != null ? this.nodeChannelCache.get(nodeId) : null;
            if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || nodeChannels == null) {
                if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || this.nodeChannelCache == null) {
                    this.nodeChannelCache = new HashMap<String, List<NodeChannel>>();
                    this.nodeChannelCacheTime = System.currentTimeMillis();
                }
                if (nodeId != null) {
                    nodeChannels = this.configurationService.getNodeChannelsFromDb(nodeId);
                    this.nodeChannelCache.put(nodeId, nodeChannels);
                } else {
                    nodeChannels = new ArrayList<NodeChannel>(0);
                }
            }
        }
        return nodeChannels;
    }

    public long getNodeChannelCacheTime() {
        return this.nodeChannelCacheTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Channel> getChannels(boolean refreshCache) {
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms", 60000L);
        if (System.currentTimeMillis() - this.channelCacheTime >= channelCacheTimeoutInMs || this.channelsCache == null || refreshCache) {
            Object object = this.configurationCacheLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.channelCacheTime >= channelCacheTimeoutInMs || this.channelsCache == null || refreshCache) {
                    this.channelsCache = this.configurationService.getChannelsFromDb();
                    this.channelCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.channelsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeGroupLink> getNodeGroupLinks(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.node.group.link.time.ms");
        if (System.currentTimeMillis() - this.nodeGroupLinkCacheTime >= cacheTimeoutInMs || this.nodeGroupLinksCache == null || refreshCache) {
            Object object = this.configurationCacheLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.nodeGroupLinkCacheTime >= cacheTimeoutInMs || this.nodeGroupLinksCache == null || refreshCache) {
                    this.nodeGroupLinksCache = this.configurationService.getNodeGroupLinksFromDb();
                    this.nodeGroupLinkCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.nodeGroupLinksCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<NodeGroupChannelWindow>> getNodeGroupChannelWindows() {
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms", 60000L);
        if (System.currentTimeMillis() - this.channelWindowsByChannelCacheTime >= channelCacheTimeoutInMs || this.channelWindowsByChannelCache == null) {
            Object object = this.configurationCacheLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.channelWindowsByChannelCacheTime >= channelCacheTimeoutInMs || this.channelWindowsByChannelCache == null) {
                    this.channelWindowsByChannelCache = this.configurationService.getNodeGroupChannelWindowsFromDb();
                    this.channelWindowsByChannelCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.channelWindowsByChannelCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNodeChannels() {
        Object object = this.configurationCacheLock;
        synchronized (object) {
            this.nodeChannelCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushChannels() {
        Object object = this.configurationCacheLock;
        synchronized (object) {
            this.channelCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNodeGroupLinks() {
        Object object = this.configurationCacheLock;
        synchronized (object) {
            this.nodeGroupLinkCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNodeGroupChannelWindows() {
        Object object = this.configurationCacheLock;
        synchronized (object) {
            this.channelWindowsByChannelCacheTime = 0L;
        }
    }
}

