/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.Notification;
import org.jumpmind.symmetric.service.IMonitorService;
import org.jumpmind.symmetric.service.IParameterService;

public class MonitorCache {
    private IParameterService parameterService;
    private IMonitorService monitorService;
    private volatile List<Monitor> activeMonitorCache;
    private volatile long activeMonitorCacheTime;
    private volatile List<Monitor> activeUnresolvedMonitorCache;
    private volatile long activeUnresolvedMonitorCacheTime;
    private volatile List<Notification> activeNotificationCache;
    private volatile long activeNotificationCacheTime;
    private volatile Object monitorCacheLock = new Object();

    public MonitorCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.monitorService = engine.getMonitorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Monitor> getMonitorsForNode(String nodeGroupId, String externalId) {
        long cacheTimeout = this.parameterService.getLong("cache.monitor.time.ms");
        if (this.activeMonitorCache == null || System.currentTimeMillis() - this.activeMonitorCacheTime > cacheTimeout) {
            Object object = this.monitorCacheLock;
            synchronized (object) {
                if (this.activeMonitorCache == null || System.currentTimeMillis() - this.activeMonitorCacheTime > cacheTimeout) {
                    this.activeMonitorCache = this.monitorService.getActiveMonitorsForNodeFromDb(nodeGroupId, externalId);
                    this.activeMonitorCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.activeMonitorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Monitor> getMonitorsUnresolvedForNode(String nodeGroupId, String externalId) {
        long cacheTimeout = this.parameterService.getLong("cache.monitor.time.ms");
        if (this.activeUnresolvedMonitorCache == null || System.currentTimeMillis() - this.activeUnresolvedMonitorCacheTime > cacheTimeout) {
            Object object = this.monitorCacheLock;
            synchronized (object) {
                if (this.activeUnresolvedMonitorCache == null || System.currentTimeMillis() - this.activeUnresolvedMonitorCacheTime > cacheTimeout) {
                    this.activeUnresolvedMonitorCache = this.monitorService.getActiveMonitorsUnresolvedForNodeFromDb(nodeGroupId, externalId);
                    this.activeUnresolvedMonitorCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.activeUnresolvedMonitorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushMonitorCache() {
        Object object = this.monitorCacheLock;
        synchronized (object) {
            this.activeMonitorCacheTime = 0L;
            this.activeUnresolvedMonitorCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Notification> getNotificationsForNode(String nodeGroupId, String externalId) {
        long cacheTimeout = this.parameterService.getLong("cache.notification.time.ms");
        if (this.activeNotificationCache == null || System.currentTimeMillis() - this.activeNotificationCacheTime > cacheTimeout) {
            Object object = this.monitorCacheLock;
            synchronized (object) {
                if (this.activeNotificationCache == null || System.currentTimeMillis() - this.activeNotificationCacheTime > cacheTimeout) {
                    this.activeNotificationCache = this.monitorService.getActiveNotificationsForNodeFromDb(nodeGroupId, externalId);
                    this.activeNotificationCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.activeNotificationCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNotificationCache() {
        Object object = this.monitorCacheLock;
        synchronized (object) {
            this.activeNotificationCacheTime = 0L;
        }
    }
}

