/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;

public class DirectorySnapshot
extends ArrayList<FileSnapshot> {
    private static final long serialVersionUID = 1L;
    private FileTriggerRouter fileTriggerRouter;

    public DirectorySnapshot(FileTriggerRouter fileTriggerRouter, List<FileSnapshot> snapshot) {
        this(fileTriggerRouter);
        this.addAll(snapshot);
    }

    public DirectorySnapshot(FileTriggerRouter fileTriggerRouter) {
        this.fileTriggerRouter = fileTriggerRouter;
    }

    protected void merge(DirectorySnapshot snapshot) {
        HashSet<FileSnapshot> toAdd = new HashSet<FileSnapshot>();
        HashSet<FileSnapshot> toRemove = new HashSet<FileSnapshot>();
        for (FileSnapshot fileChange : snapshot) {
            for (FileSnapshot file : this) {
                if (!fileChange.getFileName().equals(file.getFileName())) continue;
                toRemove.add(file);
                if (fileChange.getLastEventType() != FileSnapshot.LastEventType.MODIFY) continue;
                toAdd.add(fileChange);
            }
        }
        for (FileSnapshot fileChange : toRemove) {
            if (fileChange.getLastEventType() != FileSnapshot.LastEventType.CREATE) continue;
            toAdd.add(fileChange);
        }
        this.removeAll(toRemove);
        this.addAll(toAdd);
    }

    public DirectorySnapshot diff(DirectorySnapshot anotherSnapshot) {
        boolean found;
        DirectorySnapshot differences = new DirectorySnapshot(anotherSnapshot.getFileTriggerRouter());
        for (FileSnapshot anotherFile : anotherSnapshot) {
            found = false;
            for (FileSnapshot file : this) {
                if (!anotherFile.sameFile(file)) continue;
                found = true;
                if ((file.getLastEventType() == FileSnapshot.LastEventType.MODIFY || file.getLastEventType() == FileSnapshot.LastEventType.CREATE) && anotherFile.getLastEventType() == FileSnapshot.LastEventType.CREATE) {
                    file.setLastEventType(FileSnapshot.LastEventType.MODIFY);
                    anotherFile.setLastEventType(FileSnapshot.LastEventType.MODIFY);
                }
                if (anotherFile.equals(file)) continue;
                differences.add(anotherFile);
            }
            if (found) continue;
            differences.add(anotherFile);
        }
        for (FileSnapshot file : this) {
            found = false;
            for (FileSnapshot anotherFile : anotherSnapshot) {
                if (!anotherFile.sameFile(file)) continue;
                found = true;
            }
            if (file.getLastEventType() == FileSnapshot.LastEventType.DELETE || found) continue;
            FileSnapshot copy = new FileSnapshot(file);
            copy.setLastEventType(FileSnapshot.LastEventType.DELETE);
            differences.add(copy);
        }
        return differences;
    }

    public FileTriggerRouter getFileTriggerRouter() {
        return this.fileTriggerRouter;
    }
}

