/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTriggerFileModifiedListener
extends FileAlterationListenerAdaptor {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected FileTriggerRouter fileTriggerRouter;
    protected DirectorySnapshot snapshot;
    protected Date fromDate;
    protected Date toDate;
    protected FileModifiedCallback fileModifiedCallback;
    protected ProcessInfo processInfo;
    protected boolean isSyncOnCtlFile;
    protected boolean useCrc;
    protected ISymmetricEngine engine;
    protected Map<String, DirectorySnapshot> modifiedDirs = new HashMap<String, DirectorySnapshot>();
    protected long startTime;
    protected long ts = this.startTime = System.currentTimeMillis();
    protected long fileCount = 0L;
    protected long changeCount = 0L;

    public FileTriggerFileModifiedListener(FileTriggerRouter fileTriggerRouter, Date fromDate, Date toDate, ProcessInfo processInfo, boolean useCrc, FileModifiedCallback fileModifiedCallback, ISymmetricEngine engine) {
        this.fileTriggerRouter = fileTriggerRouter;
        this.snapshot = new DirectorySnapshot(fileTriggerRouter);
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fileModifiedCallback = fileModifiedCallback;
        this.processInfo = processInfo;
        this.isSyncOnCtlFile = fileTriggerRouter.getFileTrigger().isSyncOnCtlFile();
        this.useCrc = useCrc;
        this.engine = engine;
        this.processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
    }

    public void onStart(FileAlterationObserver observer) {
        long lastModified = observer.getDirectory().lastModified();
        if (this.fromDate == null || this.fromDate != null && lastModified >= this.fromDate.getTime() && lastModified <= this.toDate.getTime()) {
            this.modifiedDirs.put(".", new DirectorySnapshot(this.fileTriggerRouter));
        }
    }

    public void onFileCreate(File file) {
        this.log.debug("onFileCreate: " + file);
        if (this.isSyncOnCtlFile) {
            File ctlFile = this.engine.getFileSyncService().getControleFile(file);
            if (ctlFile.exists()) {
                this.log.debug("Control file detected: {}", (Object)file.getAbsolutePath());
                this.addSnapshot(file, FileSnapshot.LastEventType.CREATE, false);
            }
        } else {
            this.log.debug("File create detected: {}", (Object)file.getAbsolutePath());
            this.addSnapshot(file, FileSnapshot.LastEventType.CREATE, false);
        }
    }

    public void onDirectoryCreate(File directory) {
        this.log.debug("File create detected: {}", (Object)directory.getAbsolutePath());
        this.addSnapshot(directory, FileSnapshot.LastEventType.CREATE, true);
    }

    public void onStop(FileAlterationObserver observer) {
        long modifiedDirStartTime;
        if (this.snapshot.size() > 0) {
            this.commit();
        }
        long scanTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        long ts = modifiedDirStartTime = System.currentTimeMillis();
        int modifiedDirCount = 0;
        int modifiedDirFileCount = 0;
        int modifiedDirChangeCount = 0;
        this.processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
        for (String relativeDir : this.modifiedDirs.keySet()) {
            DirectorySnapshot lastSnapshot = this.fileModifiedCallback.getLastDirectorySnapshot(relativeDir);
            DirectorySnapshot currentSnapshot = this.modifiedDirs.get(relativeDir);
            modifiedDirFileCount += currentSnapshot.size();
            DirectorySnapshot changesSinceLastSnapshot = lastSnapshot.diff(currentSnapshot);
            this.processInfo.setCurrentDataCount(this.processInfo.getCurrentDataCount() + (long)lastSnapshot.size() + (long)currentSnapshot.size());
            if (changesSinceLastSnapshot.size() > 0) {
                ++modifiedDirCount;
                modifiedDirChangeCount += changesSinceLastSnapshot.size();
                this.fileModifiedCallback.commit(changesSinceLastSnapshot);
            }
            if (System.currentTimeMillis() - ts <= 60000L) continue;
            this.log.info("File tracker has been processing modified directories for {} seconds.  The following stats have been gathered: {}", new Object[]{(System.currentTimeMillis() - modifiedDirStartTime) / 1000L, "{ modifiedDirCount=" + modifiedDirCount + " of " + this.modifiedDirs.size() + ", modifiedDirFileCount=" + modifiedDirFileCount + ", modifiedDirChangeCount= " + modifiedDirChangeCount + " }"});
            ts = System.currentTimeMillis();
        }
        if (this.changeCount > 0L || modifiedDirChangeCount > 0) {
            String extra = ".";
            if (modifiedDirChangeCount > 0) {
                extra = String.format(", slow scan %d directories in %d seconds for %d changes.", modifiedDirCount, (System.currentTimeMillis() - modifiedDirStartTime) / 1000L, modifiedDirChangeCount);
            }
            this.log.info("File tracker fast scan {} files in {} seconds for {} changes" + extra, new Object[]{this.fileCount, scanTime, this.changeCount});
        }
    }

    protected void addSnapshot(File file, FileSnapshot.LastEventType lastEventType, boolean isDir) {
        this.log.debug("addSnapshot: " + file);
        ++this.fileCount;
        this.processInfo.incrementCurrentDataCount();
        FileSnapshot fileSnapshot = new FileSnapshot(this.fileTriggerRouter, file, lastEventType, this.useCrc);
        DirectorySnapshot modifiedDir = this.modifiedDirs.get(fileSnapshot.getRelativeDir());
        if (!isDir && modifiedDir != null) {
            modifiedDir.add(fileSnapshot);
        } else {
            long lastModified = fileSnapshot.getFileModifiedTime();
            if (this.fromDate != null && lastModified >= this.fromDate.getTime() && lastModified <= this.toDate.getTime()) {
                if (isDir) {
                    String relativeDir = StringUtils.removeStart((String)(fileSnapshot.getRelativeDir() + "/" + fileSnapshot.getFileName()), (String)"./");
                    this.modifiedDirs.put(relativeDir, new DirectorySnapshot(this.fileTriggerRouter));
                } else {
                    this.snapshot.add(fileSnapshot);
                    ++this.changeCount;
                    if (this.snapshot.size() >= this.fileModifiedCallback.getCommitSize()) {
                        this.commit();
                    }
                }
            } else {
                this.log.debug("Not processing " + file + " fromDate: " + this.fromDate + " lastModified: " + lastModified + " fromDateTime: " + (this.fromDate != null ? this.fromDate.getTime() : 0L) + " toDateTime: " + (this.toDate != null ? this.toDate.getTime() : 0L));
            }
        }
        if (System.currentTimeMillis() - this.ts > 60000L) {
            this.log.info("File tracker has been processing for {} seconds.  The following stats have been gathered: {}", new Object[]{(System.currentTimeMillis() - this.startTime) / 1000L, "{ fileCount=" + this.fileCount + ", fileChangeCount=" + this.changeCount + " }"});
            this.ts = System.currentTimeMillis();
        }
    }

    protected void commit() {
        this.fileModifiedCallback.commit(this.snapshot);
        this.snapshot.clear();
    }

    public Map<String, DirectorySnapshot> getModifiedDirs() {
        return this.modifiedDirs;
    }

    public static class FileModifiedCallback {
        int commitSize;

        public FileModifiedCallback(int commitSize) {
            this.commitSize = commitSize;
        }

        public void commit(DirectorySnapshot dirSnapshot) {
        }

        public DirectorySnapshot getLastDirectorySnapshot(String relativeDir) {
            return null;
        }

        public int getCommitSize() {
            return this.commitSize;
        }
    }
}

