/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.io.DbCompareUtil;

public class DbCompareReport {
    private List<TableReport> tableReports;
    private final String TABLE_FORMAT = " %-40s%-40s%-13d%-13d%-13d%-13d%-13d%-13d%-13d%n";

    public List<TableReport> getTableReports() {
        return this.tableReports;
    }

    public void setTableReports(List<TableReport> tableReports) {
        this.tableReports = tableReports;
    }

    public void addTableReport(TableReport tableReport) {
        if (this.tableReports == null) {
            this.tableReports = new ArrayList<TableReport>();
        }
        this.tableReports.add(tableReport);
    }

    public void printReportHeader(PrintStream stream) {
        stream.format("+---------------------------------------+---------------------------------------+------------+------------+------------+------------+------------+------------+------------+%n", new Object[0]);
        stream.format("+Source                                  Target                                  Source Rows  Target Rows  Matched      Different    Missing      Extra        Errors       %n", new Object[0]);
        stream.format("+---------------------------------------+---------------------------------------+------------+------------+------------+------------+------------+------------+------------+%n", new Object[0]);
    }

    public void printTableReport(TableReport report, PrintStream stream) {
        String sourceTable = report.getSourceTable();
        String targetTable = report.getTargetTable();
        if (sourceTable.length() > 30) {
            sourceTable = DbCompareUtil.getUnqualifiedTableName(sourceTable);
        }
        if (targetTable.length() > 30) {
            targetTable = DbCompareUtil.getUnqualifiedTableName(targetTable);
        }
        stream.format(" %-40s%-40s%-13d%-13d%-13d%-13d%-13d%-13d%-13d%n", sourceTable, targetTable, report.getSourceRows(), report.getTargetRows(), report.getMatchedRows(), report.getDifferentRows(), report.getMissingRows(), report.getExtraRows(), report.getErrorRows());
    }

    public void printReportFooter(PrintStream stream) {
        stream.format("+---------------------------------------+---------------------------------------+------------+------------+------------+------------+------------+------------+------------+%n", new Object[0]);
    }

    public static class TableReport {
        private String sourceTable;
        private String targetTable;
        private int sourceRows;
        private int targetRows;
        private int matchedRows;
        private int differentRows;
        private int missingRows;
        private int extraRows;
        private int errorRows;
        private Throwable throwable;

        public void countSourceRow() {
            ++this.sourceRows;
        }

        public void countTargetRow() {
            ++this.targetRows;
        }

        public void countMatchedRow() {
            ++this.matchedRows;
        }

        public void countDifferentRow() {
            ++this.differentRows;
        }

        public void countMissingRow() {
            ++this.missingRows;
        }

        public void countExtraRow() {
            ++this.extraRows;
        }

        public void countErrorRows() {
            ++this.errorRows;
        }

        public String getSourceTable() {
            return this.sourceTable;
        }

        public void setSourceTable(String sourceTable) {
            this.sourceTable = sourceTable;
        }

        public String getTargetTable() {
            return this.targetTable;
        }

        public void setTargetTable(String targetTable) {
            this.targetTable = targetTable;
        }

        public int getSourceRows() {
            return this.sourceRows;
        }

        public void setSourceRows(int sourceRows) {
            this.sourceRows = sourceRows;
        }

        public int getTargetRows() {
            return this.targetRows;
        }

        public void setTargetRows(int targetRows) {
            this.targetRows = targetRows;
        }

        public int getMatchedRows() {
            return this.matchedRows;
        }

        public void setMatchedRows(int matchedRows) {
            this.matchedRows = matchedRows;
        }

        public int getDifferentRows() {
            return this.differentRows;
        }

        public void setDifferentRows(int differentRows) {
            this.differentRows = differentRows;
        }

        public int getMissingRows() {
            return this.missingRows;
        }

        public void setMissingRows(int missingRows) {
            this.missingRows = missingRows;
        }

        public int getExtraRows() {
            return this.extraRows;
        }

        public void setExtraRows(int extraRows) {
            this.extraRows = extraRows;
        }

        public int getErrorRows() {
            return this.errorRows;
        }

        public void setErrorRows(int errorRows) {
            this.errorRows = errorRows;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public String toString() {
            return "TableReport [sourceTable=" + this.sourceTable + ", targetTable=" + this.targetTable + ", sourceRows=" + this.sourceRows + ", targetRows=" + this.targetRows + ", matchedRows=" + this.matchedRows + ", differentRows=" + this.differentRows + ", missingRows=" + this.missingRows + ", extraRows=" + this.extraRows + ", errorRows=" + this.errorRows + "]";
        }
    }
}

