/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.DbCompareTables;
import org.jumpmind.symmetric.io.DbValueComparator;

public class DbCompareRow {
    private DbValueComparator dbValueComparator;
    private ISymmetricEngine engine;
    private Table table;
    private Row row;
    private Map<String, String> rowValues;
    private Map<String, String> rowPkValues;

    public DbCompareRow(ISymmetricEngine engine, DbValueComparator dbValueComparator, Table table, Row row) {
        this.engine = engine;
        this.table = table;
        this.row = row;
        this.dbValueComparator = dbValueComparator;
        this.loadRowValues();
    }

    public int comparePks(DbCompareTables tables, DbCompareRow targetRow) {
        for (Column sourcePkColumn : this.table.getPrimaryKeyColumns()) {
            Column targetPkColumn = tables.getColumnMapping().get(sourcePkColumn);
            if (targetPkColumn == null) {
                return 0;
            }
            int result = this.dbValueComparator.compareValues(sourcePkColumn, targetPkColumn, this.rowValues.get(sourcePkColumn.getName()), targetRow.getRowValues().get(targetPkColumn.getName()));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public Map<Column, String> compareTo(DbCompareTables tables, DbCompareRow targetRow) {
        LinkedHashMap<Column, String> deltas = new LinkedHashMap<Column, String>();
        for (Column sourceColumn : this.table.getColumns()) {
            int result;
            Column targetColumn = tables.getColumnMapping().get(sourceColumn);
            if (targetColumn == null || (result = this.dbValueComparator.compareValues(sourceColumn, targetColumn, this.rowValues.get(sourceColumn.getName()), targetRow.getRowValues().get(targetColumn.getName()))) == 0) continue;
            deltas.put(targetColumn, this.rowValues.get(sourceColumn.getName()));
        }
        return deltas;
    }

    protected void loadRowValues() {
        String[] stringValues = this.engine.getDatabasePlatform().getStringValues(BinaryEncoding.HEX, this.table.getColumns(), this.row, false, false);
        LinkedHashMap<String, String> localRowValues = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> localPkRowValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < stringValues.length; ++i) {
            String stringValue;
            String columnName;
            if (i < this.table.getColumnCount()) {
                columnName = this.table.getColumn(i).getName();
                stringValue = stringValues[i];
                localRowValues.put(columnName, stringValue);
            }
            if (i >= this.table.getPrimaryKeyColumnCount()) continue;
            columnName = this.table.getPrimaryKeyColumns()[i].getName();
            stringValue = stringValues[i];
            localPkRowValues.put(columnName, stringValue);
        }
        this.rowValues = localRowValues;
        this.rowPkValues = localPkRowValues;
    }

    public DbValueComparator getDbValueComparator() {
        return this.dbValueComparator;
    }

    public void setDbValueComparator(DbValueComparator dbValueComparator) {
        this.dbValueComparator = dbValueComparator;
    }

    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public Map<String, String> getRowValues() {
        return this.rowValues;
    }

    public void setRowValues(Map<String, String> rowValues) {
        this.rowValues = rowValues;
    }

    public Map<String, String> getRowPkValues() {
        return this.rowPkValues;
    }

    public void setRowPkValues(Map<String, String> rowPkValues) {
        this.rowPkValues = rowPkValues;
    }
}

