/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOfflineClientListener
implements IOfflineClientListener,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IParameterService parameterService;
    protected INodeService nodeService;

    public DefaultOfflineClientListener(IParameterService parameterService, INodeService nodeService) {
        this.parameterService = parameterService;
        this.nodeService = nodeService;
    }

    @Override
    public void busy(Node remoteNode) {
    }

    @Override
    public void notAuthenticated(Node remoteNode) {
    }

    @Override
    public void unknownError(Node remoteNode, Exception ex) {
    }

    @Override
    public void offline(Node remoteNode) {
    }

    @Override
    public void syncDisabled(Node remoteNode) {
        Node identity = this.nodeService.findIdentity();
        if (identity != null && identity.getCreatedAtNodeId() != null && identity.getCreatedAtNodeId().equals(remoteNode.getNodeId())) {
            this.log.warn("Removing identity because sync has been disabled");
            this.nodeService.deleteIdentity();
        }
    }

    @Override
    public void registrationRequired(Node remoteNode) {
    }

    @Override
    public void online(Node remoteNode) {
    }
}

