/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.load.DynamicDatabaseWriterFilter;
import org.jumpmind.symmetric.model.LoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDatabaseWriterFilter
extends DynamicDatabaseWriterFilter {
    public static final String CODE_START = "import org.jumpmind.symmetric.load.*;\nimport org.jumpmind.symmetric.io.data.*;\nimport org.jumpmind.db.model.*;\nimport java.util.*;\npublic class JavaDatabaseWriterFilterExt implements JavaDatabaseWriterFilter.JavaLoadFilter { \n    public boolean execute(DataContext context, Table table, CsvData data, Exception error) {\n\n";
    public static final String CODE_END = "\n\n   }\n}\n";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public JavaDatabaseWriterFilter(ISymmetricEngine engine, Map<String, List<LoadFilter>> loadFilters) {
        super(engine, loadFilters);
    }

    @Override
    protected boolean processLoadFilters(DataContext context, Table table, CsvData data, Exception error, DynamicDatabaseWriterFilter.WriteMethod writeMethod, List<LoadFilter> loadFiltersForTable) {
        boolean writeRow;
        block5: {
            writeRow = true;
            LoadFilter currentFilter = null;
            try {
                Iterator<LoadFilter> iterator = loadFiltersForTable.iterator();
                while (iterator.hasNext()) {
                    LoadFilter filter;
                    currentFilter = filter = iterator.next();
                    if (!(filter.isFilterOnDelete() && data.getDataEventType().equals((Object)DataEventType.DELETE) || filter.isFilterOnInsert() && data.getDataEventType().equals((Object)DataEventType.INSERT)) && (!filter.isFilterOnUpdate() || !data.getDataEventType().equals((Object)DataEventType.UPDATE))) continue;
                    if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.BEFORE_WRITE) && filter.getBeforeWriteScript() != null) {
                        writeRow = this.getCompiledClass(filter.getBeforeWriteScript()).execute(context, table, data, error);
                        continue;
                    }
                    if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.AFTER_WRITE) && filter.getAfterWriteScript() != null) {
                        writeRow = this.getCompiledClass(filter.getAfterWriteScript()).execute(context, table, data, error);
                        continue;
                    }
                    if (!writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.HANDLE_ERROR) || filter.getHandleErrorScript() == null) continue;
                    writeRow = this.getCompiledClass(filter.getHandleErrorScript()).execute(context, table, data, error);
                }
            }
            catch (Exception ex) {
                String formattedMessage = String.format("Error executing Java load filter %s on table %s. The error was: %s", currentFilter != null ? currentFilter.getLoadFilterId() : "N/A", table.getName(), ex.getMessage());
                this.log.error(formattedMessage);
                if (!currentFilter.isFailOnError()) break block5;
                throw new SymmetricException(formattedMessage, ex);
            }
        }
        return writeRow;
    }

    @Override
    protected void executeScripts(DataContext context, String key, Set<String> scripts, boolean isFailOnError) {
        block4: {
            try {
                if (scripts != null) {
                    for (String script : scripts) {
                        this.getCompiledClass(script).execute(context, null, null, null);
                    }
                }
            }
            catch (Exception e) {
                String errorMsg = String.format("Java load filter %s with error %s", key, e.getMessage());
                this.log.error(errorMsg);
                if (!isFailOnError) break block4;
                throw new SymmetricException(errorMsg, new Object[0]);
            }
        }
    }

    public static int countHeaderLines() {
        return CODE_START.split("\n").length;
    }

    public JavaLoadFilter getCompiledClass(String javaExpression) throws Exception {
        String javaCode = CODE_START + javaExpression + CODE_END;
        return (JavaLoadFilter)this.engine.getExtensionService().getCompiledClass(javaCode);
    }

    public static interface JavaLoadFilter {
        public boolean execute(DataContext var1, Table var2, CsvData var3, Exception var4);
    }
}

