/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.Monitor;

public class Notification
implements IModelObject {
    private static final long serialVersionUID = 1L;
    private String notificationId;
    private String nodeGroupId;
    private String externalId;
    private int severityLevel;
    private String type;
    private String expression;
    private boolean enabled;
    private Date createTime;
    private String lastUpdateBy;
    private Date lastUpdateTime;
    private transient String targetNode;

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(int severityLevel) {
        this.severityLevel = severityLevel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getExpression() {
        return this.expression;
    }

    public LogExpression getLogExpression() {
        if (this.type != null && this.type.equals("log") && this.expression != null && this.expression.contains("{")) {
            return (LogExpression)new Gson().fromJson(this.expression, LogExpression.class);
        }
        return new LogExpression();
    }

    public EmailExpression getEmailExpression() {
        if (this.type != null && this.type.equals("email") && this.expression != null && this.expression.contains("{")) {
            return (EmailExpression)new Gson().fromJson(this.expression, EmailExpression.class);
        }
        EmailExpression emailExpression = new EmailExpression();
        if (!StringUtils.isEmpty((CharSequence)this.expression)) {
            emailExpression.setEmails(Arrays.asList(this.expression.split(",", -1)));
        }
        return emailExpression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setExpression(LogExpression expression) {
        this.expression = new Gson().toJson((Object)expression);
    }

    public void setExpression(EmailExpression expression) {
        this.expression = new Gson().toJson((Object)expression);
    }

    public String getSeverityLevelName() {
        String name = Monitor.severityLevelNames.get(this.severityLevel);
        if (name == null) {
            name = "INFO";
        }
        return name;
    }

    public String getTargetNode() {
        if (this.targetNode == null) {
            this.targetNode = this.externalId != null && !this.externalId.equals("ALL") ? this.externalId + " only" : this.nodeGroupId;
        }
        return this.targetNode;
    }

    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.notificationId == null ? 0 : this.notificationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        return !(this.notificationId == null ? other.notificationId != null : !this.notificationId.equals(other.notificationId));
    }

    public class Template {
        private String name;
        private String template;

        public Template(String name, String template) {
            this.name = name;
            this.template = template;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }

    public class EmailExpression {
        private List<String> emails = new ArrayList<String>();
        private String subject = "Monitor events for $(eventTypes) from nodes $(eventNodeIds)";
        private String bodyBefore = "";
        private String bodyAfter = "";
        private String unresolved = "Monitor event for $(eventType) reached threshold of $(eventThreshold) with a value of $(eventValue)";
        private String resolved = "Monitor event for $(eventType) is resolved";
        private List<Template> templates = new ArrayList<Template>();

        public EmailExpression() {
            this.templates.add(new Template("log", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("batchError", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("offlineNodes", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("batchUnsent", "$(eventValue) batches unsent."));
            this.templates.add(new Template("dataUnrouted", "$(eventValue) unrouted data rows."));
            this.templates.add(new Template("dataGap", "$(eventValue) data gap(s) recorded"));
            this.templates.add(new Template("cpu", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("memory", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("disk", "Disk usage is at $(eventValue)%"));
            this.templates.add(new Template("block", "Details: \n$(eventDetails)"));
            this.templates.add(new Template("default", "Details: \n$(eventDetails)"));
        }

        public List<String> getEmails() {
            return this.emails;
        }

        public void setEmails(List<String> emails) {
            this.emails = emails;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getBodyBefore() {
            return this.bodyBefore;
        }

        public void setBodyBefore(String bodyBefore) {
            this.bodyBefore = bodyBefore;
        }

        public String getBodyAfter() {
            return this.bodyAfter;
        }

        public void setBodyAfter(String bodyAfter) {
            this.bodyAfter = bodyAfter;
        }

        public String getUnresolved() {
            return this.unresolved;
        }

        public void setUnresolved(String unresolved) {
            this.unresolved = unresolved;
        }

        public String getResolved() {
            return this.resolved;
        }

        public void setResolved(String resolved) {
            this.resolved = resolved;
        }

        public List<Template> getTemplates() {
            return this.templates;
        }

        public Map<String, String> getTemplateMap() {
            HashMap<String, String> templateMap = new HashMap<String, String>();
            for (Template template : this.templates) {
                templateMap.put(template.getName(), template.getTemplate());
            }
            return templateMap;
        }

        public void setTemplates(List<Template> templates) {
            this.templates = templates;
        }

        public void setTemplates(Map<String, String> templateMap) {
            this.templates = new ArrayList<Template>();
            for (String name : templateMap.keySet()) {
                this.templates.add(new Template(name, templateMap.get(name)));
            }
        }
    }

    public class LogExpression {
        private String unresolved = "Monitor $(eventType) on $(eventNodeId) reached threshold of $(eventThreshold) with a value of $(eventValue)";
        private String resolved = "Monitor $(eventType) on $(eventNodeId) is resolved";

        public String getUnresolved() {
            return this.unresolved;
        }

        public void setUnresolved(String unresolved) {
            this.unresolved = unresolved;
        }

        public String getResolved() {
            return this.resolved;
        }

        public void setResolved(String resolved) {
            this.resolved = resolved;
        }
    }
}

