/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.OutgoingBatch;

public class OutgoingBatches
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<OutgoingBatch> batches = new ArrayList<OutgoingBatch>();
    Set<NodeChannel> activeChannels = new HashSet<NodeChannel>();
    Set<String> activeChannelIds = new HashSet<String>();

    public OutgoingBatches(List<OutgoingBatch> batches) {
        this.batches = batches;
    }

    public OutgoingBatches() {
    }

    public boolean containsBatches() {
        return this.batches != null && this.batches.size() > 0;
    }

    public Set<NodeChannel> getActiveChannels() {
        return this.activeChannels;
    }

    public void addActiveChannel(NodeChannel nodeChannel) {
        this.activeChannels.add(nodeChannel);
        this.activeChannelIds.add(nodeChannel.getChannelId());
    }

    public void setActiveChannels(Set<NodeChannel> activeChannels) {
        this.activeChannels = activeChannels;
        this.activeChannelIds = new HashSet<String>();
        for (NodeChannel nodeChannel : activeChannels) {
            this.activeChannelIds.add(nodeChannel.getChannelId());
        }
    }

    public List<OutgoingBatch> getBatches() {
        return this.batches;
    }

    public void setBatches(List<OutgoingBatch> batches) {
        this.batches = batches;
    }

    public List<OutgoingBatch> filterBatchesForChannel(Channel channel) {
        List<OutgoingBatch> filtered = this.getBatchesForChannel(channel);
        this.batches.removeAll(filtered);
        return filtered;
    }

    public int countBatches(boolean includeOnlyErrors) {
        int count = 0;
        if (this.batches != null) {
            for (OutgoingBatch batch : this.batches) {
                if (includeOnlyErrors && batch.isErrorFlag()) {
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public List<OutgoingBatch> filterBatchesForChannel(String channelId) {
        List<OutgoingBatch> filtered = this.getBatchesForChannel(channelId);
        this.batches.removeAll(filtered);
        return filtered;
    }

    public List<OutgoingBatch> filterBatchesForChannels(Set<String> channels) {
        List<OutgoingBatch> filtered = this.getBatchesForChannels(channels);
        this.batches.removeAll(filtered);
        return filtered;
    }

    public void removeNonLoadBatches() {
        HashSet<String> channelsWithRequestedLoad = new HashSet<String>();
        Iterator<OutgoingBatch> iterator = this.batches.iterator();
        while (iterator.hasNext()) {
            OutgoingBatch b = iterator.next();
            if (!(b.isLoadFlag() || b.getChannelId().contentEquals("config") || b.getChannelId().contentEquals("heartbeat") || b.getChannelId().contentEquals("monitor"))) {
                iterator.remove();
                continue;
            }
            if (AbstractBatch.Status.RQ.equals((Object)b.getStatus())) {
                channelsWithRequestedLoad.add(b.getChannelId());
            }
            if (!channelsWithRequestedLoad.contains(b.getChannelId())) continue;
            iterator.remove();
        }
    }

    public void removeThreadChannelBatches(String channelId) {
        Iterator<OutgoingBatch> iterator = this.batches.iterator();
        while (iterator.hasNext()) {
            OutgoingBatch b = iterator.next();
            if (b.getChannelId().equals(channelId)) continue;
            iterator.remove();
        }
    }

    public boolean containsLoadBatches() {
        for (OutgoingBatch b : this.batches) {
            if (!b.isLoadFlag()) continue;
            return true;
        }
        return false;
    }

    public boolean containsBatchesInError() {
        for (OutgoingBatch b : this.batches) {
            if (!b.isErrorFlag()) continue;
            return true;
        }
        return false;
    }

    public List<OutgoingBatch> getBatchesForChannel(Channel channel) {
        List<OutgoingBatch> batchList = new ArrayList<OutgoingBatch>();
        if (channel != null) {
            batchList = this.getBatchesForChannel(channel.getChannelId());
        }
        return batchList;
    }

    public List<OutgoingBatch> getBatchesForChannel(String channelId) {
        ArrayList<OutgoingBatch> batchList = new ArrayList<OutgoingBatch>();
        if (channelId != null) {
            for (OutgoingBatch batch : this.batches) {
                if (!channelId.equals(batch.getChannelId())) continue;
                batchList.add(batch);
            }
        }
        return batchList;
    }

    public List<OutgoingBatch> getBatchesForChannels(Set<String> channelIds) {
        ArrayList<OutgoingBatch> batchList = new ArrayList<OutgoingBatch>();
        if (channelIds != null) {
            for (OutgoingBatch batch : this.batches) {
                if (!channelIds.contains(batch.getChannelId())) continue;
                batchList.add(batch);
            }
        }
        return batchList;
    }

    public List<OutgoingBatch> filterBatchesForInactiveChannels() {
        ArrayList<OutgoingBatch> filtered = new ArrayList<OutgoingBatch>();
        for (OutgoingBatch batch : this.batches) {
            if (this.activeChannelIds.contains(batch.getChannelId())) continue;
            filtered.add(batch);
        }
        this.batches.removeAll(filtered);
        return filtered;
    }

    public void sortChannels(List<NodeChannel> channels) {
        final HashMap<String, Date> errorChannels = new HashMap<String, Date>();
        for (OutgoingBatch batch : this.batches) {
            Date date;
            if (!batch.isErrorFlag() || (date = (Date)errorChannels.get(batch.getChannelId())) != null && batch.getLastUpdatedTime().compareTo(date) <= 0) continue;
            errorChannels.put(batch.getChannelId(), batch.getLastUpdatedTime());
        }
        Collections.sort(channels, new Comparator<NodeChannel>(){

            @Override
            public int compare(NodeChannel b1, NodeChannel b2) {
                boolean isError1 = errorChannels.containsKey(b1.getChannelId());
                boolean isError2 = errorChannels.containsKey(b2.getChannelId());
                if (!isError1 && !isError2) {
                    return b1.getProcessingOrder() < b2.getProcessingOrder() ? -1 : 1;
                }
                if (isError1 && isError2) {
                    return ((Date)errorChannels.get(b1.getChannelId())).compareTo((Date)errorChannels.get(b2.getChannelId()));
                }
                if (!isError1 && isError2) {
                    return -1;
                }
                return 1;
            }
        });
        for (NodeChannel nodeChannel : channels) {
            long extractPeriodMillis = nodeChannel.getExtractPeriodMillis();
            Date lastExtractedTime = nodeChannel.getLastExtractTime();
            if (extractPeriodMillis >= 1L && lastExtractedTime != null && Calendar.getInstance().getTimeInMillis() - lastExtractedTime.getTime() < extractPeriodMillis) continue;
            this.addActiveChannel(nodeChannel);
        }
        this.filterBatchesForInactiveChannels();
    }
}

