/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import java.lang.management.ThreadInfo;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.monitor.IMonitorType;
import org.jumpmind.util.AppUtils;

public abstract class AbstractMonitorType
implements IMonitorType,
ISymmetricEngineAware {
    protected final int TOP_THREADS = 3;
    protected final int MAX_STACK_DEPTH = 30;
    protected ISymmetricEngine engine;

    @Override
    public boolean requiresClusterLock() {
        return true;
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    protected void rankTopUsage(ThreadInfo[] infos, long[] usages, ThreadInfo info, long usage) {
        for (int i = 0; i < infos.length; ++i) {
            if (usage <= usages[i]) continue;
            for (int j = infos.length - 1; j > i; --j) {
                infos[j] = infos[j - 1];
                usages[j] = usages[j - 1];
            }
            infos[i] = info;
            usages[i] = usage;
            break;
        }
    }

    protected String logStackTrace(ThreadInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stack trace for thread ").append(info.getThreadId()).append(":\n");
        sb.append(AppUtils.formatStackTrace((StackTraceElement[])info.getStackTrace()));
        return sb.toString();
    }
}

