/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.monitor.BatchErrorWrapper;
import org.jumpmind.symmetric.monitor.IMonitorType;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeBatchError
implements IMonitorType,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IOutgoingBatchService outgoingBatchService;
    protected IIncomingBatchService incomingBatchService;
    public static final String NAME = "batchError";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        int outgoingErrorCount = 0;
        MonitorEvent event = new MonitorEvent();
        ArrayList<OutgoingBatch> outgoingErrors = new ArrayList<OutgoingBatch>();
        ArrayList<IncomingBatch> incomingErrors = new ArrayList<IncomingBatch>();
        OutgoingBatches outgoingBatches = this.outgoingBatchService.getOutgoingBatchErrors(1000);
        for (OutgoingBatch batch : outgoingBatches.getBatches()) {
            ++outgoingErrorCount;
            outgoingErrors.add(batch);
        }
        int incomingErrorCount = 0;
        List<IncomingBatch> incomingBatches = this.incomingBatchService.findIncomingBatchErrors(1000);
        for (IncomingBatch batch : incomingBatches) {
            ++incomingErrorCount;
            incomingErrors.add(batch);
        }
        event.setValue(outgoingErrorCount + incomingErrorCount);
        BatchErrorWrapper wrapper = new BatchErrorWrapper();
        if (outgoingErrors.size() > 0) {
            wrapper.setOutgoingErrors(outgoingErrors);
        }
        if (incomingErrors.size() > 0) {
            wrapper.setIncomingErrors(incomingErrors);
        }
        event.setDetails(this.serializeDetails(wrapper));
        return event;
    }

    @Override
    public boolean requiresClusterLock() {
        return true;
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.outgoingBatchService = engine.getOutgoingBatchService();
        this.incomingBatchService = engine.getIncomingBatchService();
    }

    protected String serializeDetails(BatchErrorWrapper details) {
        String result = null;
        try {
            result = new Gson().toJson((Object)details);
        }
        catch (Exception e) {
            this.log.warn("Unable to convert batch errors to JSON", (Throwable)e);
        }
        return result;
    }
}

