/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.AbstractMonitorType;
import org.jumpmind.symmetric.statistic.JobStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeJob
extends AbstractMonitorType
implements IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getName() {
        return "job";
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        List<JobStats> jobStatsList = this.engine.getStatisticService().getJobStatsForNode(this.engine.getNodeId());
        if (!jobStatsList.isEmpty()) {
            HashMap<String, HashSet<String>> errorMessagesByJobMap = new HashMap<String, HashSet<String>>();
            HashSet<String> jobsNotInErrorSet = new HashSet<String>();
            for (JobStats stats : jobStatsList) {
                String jobName = stats.getJobName();
                if (jobsNotInErrorSet.contains(jobName)) continue;
                if (stats.isErrorFlag()) {
                    HashSet<String> errorMessageSet = (HashSet<String>)errorMessagesByJobMap.get(jobName);
                    if (errorMessageSet == null) {
                        errorMessageSet = new HashSet<String>();
                    }
                    errorMessageSet.add(stats.getErrorMessage());
                    errorMessagesByJobMap.put(jobName, errorMessageSet);
                    continue;
                }
                jobsNotInErrorSet.add(jobName);
            }
            if (!errorMessagesByJobMap.isEmpty()) {
                event.setValue(errorMessagesByJobMap.size());
                String details = "";
                for (Map.Entry entry : errorMessagesByJobMap.entrySet()) {
                    Set errorMessages = (Set)entry.getValue();
                    if (errorMessages.size() == 1) {
                        details = details + "1 unique error message for the " + (String)entry.getKey() + " job: \"" + (String)errorMessages.iterator().next() + "\", ";
                        continue;
                    }
                    details = details + errorMessages.size() + " unique error messages for the " + (String)entry.getKey() + " job: ";
                    for (String errorMessage : errorMessages) {
                        details = details + "\"" + errorMessage + "\", ";
                    }
                }
                details = details.substring(0, details.length() - 2);
                event.setDetails(details);
            }
        }
        return event;
    }
}

