/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.IMonitorType;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.symmetric.util.SuperClassExclusion;
import org.jumpmind.util.LogSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeLog
implements IMonitorType,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    ISymmetricEngine engine;

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        ArrayList<LogSummary> all = new ArrayList<LogSummary>();
        MonitorEvent event = new MonitorEvent();
        if (monitor.getSeverityLevel() == 300) {
            all.addAll(LogSummaryAppenderUtils.getLogSummaryErrors(this.engine.getEngineName()));
        } else if (monitor.getSeverityLevel() == 200) {
            all.addAll(LogSummaryAppenderUtils.getLogSummaryWarnings(this.engine.getEngineName()));
        }
        Collections.sort(all);
        int count = 0;
        for (LogSummary logSummary : all) {
            count += logSummary.getCount();
        }
        event.setValue(all.size());
        event.setCount(count);
        String details = this.serializeDetails(all);
        if ("interbase".equals(this.engine.getDatabasePlatform().getName())) {
            while (details != null && details.length() > 4096 && all.size() > 1) {
                all.remove(all.size() - 1);
                details = this.serializeDetails(all);
            }
            if (details != null && details.length() > 4096) {
                details = details.substring(0, 4096);
            }
        }
        event.setDetails(details);
        return event;
    }

    protected String serializeDetails(List<LogSummary> logs) {
        String result = null;
        try {
            GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
            builder.addSerializationExclusionStrategy((ExclusionStrategy)new SuperClassExclusion());
            builder.addDeserializationExclusionStrategy((ExclusionStrategy)new SuperClassExclusion());
            result = builder.create().toJson(logs);
        }
        catch (Exception e) {
            this.log.warn("Unable to convert list of logs to JSON", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean requiresClusterLock() {
        return true;
    }

    @Override
    public String getName() {
        return "log";
    }
}

