/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.AbstractMonitorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeMemory
extends AbstractMonitorType
implements IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected MemoryPoolMXBean tenuredPool;
    public static final String NAME = "memory";

    @Override
    public String getName() {
        return NAME;
    }

    public MonitorTypeMemory() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            this.tenuredPool = pool;
            break;
        }
        if (this.tenuredPool == null) {
            this.log.warn("Unable to find tenured memory pool");
        }
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        long usage = 0L;
        if (this.tenuredPool != null) {
            usage = (long)((double)this.tenuredPool.getUsage().getUsed() / (double)this.tenuredPool.getUsage().getMax() * 100.0);
        }
        event.setValue(usage);
        event.setDetails(this.getMessage(0L, 0L, 0L));
        return event;
    }

    public String getMessage(long value, long threshold, long period) {
        long maxMemory = this.tenuredPool.getUsage().getMax();
        long usedMemory = this.tenuredPool.getUsage().getUsed();
        StringBuilder text = new StringBuilder("Memory threshold exceeded, " + usedMemory + " of " + maxMemory);
        text.append(System.lineSeparator()).append(System.lineSeparator());
        ThreadInfo[] infos = new ThreadInfo[3];
        long[] byteUsages = new long[3];
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (long threadId : threadBean.getAllThreadIds()) {
            ThreadInfo info = threadBean.getThreadInfo(threadId);
            if (info == null || info.getThreadState() == Thread.State.TERMINATED) continue;
            this.rankTopUsage(infos, byteUsages, info, this.getThreadAllocatedBytes(threadBean, threadId));
        }
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            text.append("Top #").append(i + 1).append(" memory thread ").append(infos[i].getThreadName()).append(" (ID ").append(infos[i].getThreadId()).append(")").append(" is using ").append(String.format("%.1f", (double)byteUsages[i] / 1048576.0)).append("MB").append(System.lineSeparator());
            text.append(this.logStackTrace(threadBean.getThreadInfo(infos[i].getThreadId(), 30))).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return text.toString();
    }

    protected long getThreadAllocatedBytes(ThreadMXBean threadBean, long threadId) {
        long size = 0L;
        try {
            Method method = threadBean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
            method.setAccessible(true);
            size = (Long)method.invoke((Object)threadBean, threadId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    @Override
    public boolean requiresClusterLock() {
        return false;
    }
}

