/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import com.google.gson.Gson;
import java.util.List;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.IMonitorType;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeOfflineNodes
implements IMonitorType,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected INodeService nodeService;
    protected IParameterService parameterService;
    public static final String NAME = "offlineNodes";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        int minutesBeforeNodeIsOffline = this.parameterService.getInt("console.report.as.offline.minutes", 1440);
        MonitorEvent event = new MonitorEvent();
        List<String> offlineNodes = this.nodeService.findOfflineNodeIds(minutesBeforeNodeIsOffline);
        event.setValue(offlineNodes.size());
        event.setDetails(this.serializeDetails(offlineNodes));
        return event;
    }

    @Override
    public boolean requiresClusterLock() {
        return true;
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.nodeService = engine.getNodeService();
        this.parameterService = engine.getParameterService();
    }

    protected String serializeDetails(List<String> offlineNodes) {
        String result = null;
        try {
            result = new Gson().toJson(offlineNodes);
        }
        catch (Exception e) {
            this.log.warn("Unable to convert list of offline nodes to JSON", (Throwable)e);
        }
        return result;
    }
}

