/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.notification;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.model.Notification;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.monitor.BatchErrorWrapper;
import org.jumpmind.symmetric.notification.INotificationType;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LogSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationTypeEmail
implements INotificationType,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;

    @Override
    public void notify(Notification notification, List<MonitorEvent> monitorEvents) {
        String recipients;
        Map<String, String> eventListReplacements = SymmetricUtils.getReplacementsForMonitorEventList(this.engine, monitorEvents);
        Notification.EmailExpression expression = notification.getEmailExpression();
        String subject = FormatUtils.replaceTokens((String)expression.getSubject(), eventListReplacements, (boolean)true);
        Map<String, String> templateMap = expression.getTemplateMap();
        StringBuilder text = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)expression.getBodyBefore())) {
            text.append(FormatUtils.replaceTokens((String)expression.getBodyBefore(), eventListReplacements, (boolean)true) + "\n");
        }
        for (MonitorEvent event : monitorEvents) {
            try {
                Map<String, String> eventReplacements = SymmetricUtils.getReplacementsForMonitorEvent(this.engine, event);
                if (event.getType().equals("log")) {
                    eventReplacements.put("eventDetails", NotificationTypeEmail.getLogDetails(event));
                } else if (event.getType().equals("batchError")) {
                    eventReplacements.put("eventDetails", NotificationTypeEmail.getBatchDetails(event));
                } else if (event.getType().equals("offlineNodes")) {
                    eventReplacements.put("eventDetails", NotificationTypeEmail.getOfflineDetails(event));
                }
                if (monitorEvents.indexOf(event) > 0) {
                    text.append("\n");
                }
                if (event.isResolved()) {
                    text.append(FormatUtils.replaceTokens((String)expression.getResolved(), eventReplacements, (boolean)true));
                    continue;
                }
                text.append(FormatUtils.replaceTokens((String)expression.getUnresolved(), eventReplacements, (boolean)true));
                String template = templateMap.get(event.getType());
                if (template == null) {
                    template = templateMap.get("default");
                }
                if (template == null) continue;
                text.append("\n" + FormatUtils.replaceTokens((String)template, eventReplacements, (boolean)true));
            }
            catch (Exception e) {
                this.log.debug("", (Throwable)e);
            }
        }
        if (!StringUtils.isBlank((CharSequence)expression.getBodyAfter())) {
            text.append("\n" + FormatUtils.replaceTokens((String)expression.getBodyAfter(), eventListReplacements, (boolean)true));
        }
        if ((recipients = String.join((CharSequence)",", expression.getEmails())) != null) {
            this.log.info("Sending email with subject '" + subject + "' to " + recipients);
            this.engine.getMailService().sendEmail(subject, text.toString(), recipients);
        } else {
            this.log.warn("Notification " + notification.getNotificationId() + " has no email recipients configured.");
        }
    }

    protected static String getOfflineDetails(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append("\n");
        for (String node : NotificationTypeEmail.deserializeOfflineNodes(event)) {
            stackTrace.append("Node ").append(node).append(" is offline.").append("\n");
        }
        return stackTrace.toString();
    }

    protected static String getBatchDetails(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        BatchErrorWrapper errors = NotificationTypeEmail.deserializeBatches(event);
        if (errors != null) {
            List<OutgoingBatch> outErrors = errors.getOutgoingErrors();
            for (OutgoingBatch b : outErrors) {
                stackTrace.append("The outgoing batch ").append(b.getNodeBatchId());
                stackTrace.append(" failed: ").append(b.getSqlMessage()).append("\n");
            }
            List<IncomingBatch> inErrors = errors.getIncomingErrors();
            for (IncomingBatch b : inErrors) {
                stackTrace.append("The incoming batch ").append(b.getNodeBatchId());
                stackTrace.append(" failed: ").append(b.getSqlMessage()).append("\n");
            }
        }
        return stackTrace.toString();
    }

    protected static String getLogDetails(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        int count = 0;
        for (LogSummary summary : NotificationTypeEmail.deserializeLogSummary(event)) {
            if (summary.getMessage() != null) {
                stackTrace.append(summary.getMessage());
                ++count;
            }
            if (summary.getStackTrace() == null) continue;
            stackTrace.append(summary.getStackTrace());
            ++count;
        }
        if (count > 0) {
            stackTrace.append("\n");
        }
        return stackTrace.toString();
    }

    protected static List<String> deserializeOfflineNodes(MonitorEvent event) throws IOException {
        List nodes = null;
        if (event.getDetails() != null) {
            nodes = (List)new Gson().fromJson(event.getDetails(), new TypeToken<List<String>>(){}.getType());
        }
        if (nodes == null) {
            nodes = Collections.emptyList();
        }
        return nodes;
    }

    protected static BatchErrorWrapper deserializeBatches(MonitorEvent event) {
        BatchErrorWrapper batches = null;
        if (event.getDetails() != null) {
            batches = (BatchErrorWrapper)new Gson().fromJson(event.getDetails(), BatchErrorWrapper.class);
        }
        return batches;
    }

    protected static List<LogSummary> deserializeLogSummary(MonitorEvent event) throws IOException {
        List summaries = null;
        if (event.getDetails() != null) {
            summaries = (List)new Gson().fromJson(event.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
        }
        if (summaries == null) {
            summaries = Collections.emptyList();
        }
        return summaries;
    }

    @Override
    public String getName() {
        return "email";
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

