/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.notification;

import java.util.List;
import java.util.Map;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.model.Notification;
import org.jumpmind.symmetric.notification.INotificationType;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationTypeLog
implements INotificationType,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;

    @Override
    public void notify(Notification notification, List<MonitorEvent> monitorEvents) {
        Notification.LogExpression expression = notification.getLogExpression();
        for (MonitorEvent monitorEvent : monitorEvents) {
            Map<String, String> replacements = SymmetricUtils.getReplacementsForMonitorEvent(this.engine, monitorEvent);
            String message = monitorEvent.isResolved() ? FormatUtils.replaceTokens((String)expression.getResolved(), replacements, (boolean)true) : FormatUtils.replaceTokens((String)expression.getUnresolved(), replacements, (boolean)true);
            if (monitorEvent.getSeverityLevel() >= 300) {
                this.log.error(message);
                continue;
            }
            if (monitorEvent.getSeverityLevel() >= 200) {
                this.log.warn(message);
                continue;
            }
            this.log.info(message);
        }
    }

    @Override
    public String getName() {
        return "log";
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

