/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRouterContext
extends Context {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected NodeChannel channel;
    protected boolean encountedTransactionBoundary = false;
    protected Map<String, Long> stats = new HashMap<String, Long>();
    protected String nodeId;
    protected boolean requestGapDetection = false;
    protected int batchSizeNotToExceed;
    protected Map<String, RouterTimer> routerTimers = new HashMap<String, RouterTimer>();

    public SimpleRouterContext() {
    }

    public SimpleRouterContext(String nodeId, NodeChannel channel) {
        this.nodeId = nodeId;
        this.channel = channel;
    }

    public RouterTimer addQueryTime(String routerId, long qt) {
        RouterTimer rt = this.routerTimers.get(routerId);
        if (rt == null) {
            rt = new RouterTimer();
            this.routerTimers.put(routerId, rt);
        }
        rt.addQueryTime(qt);
        return rt;
    }

    public BinaryEncoding getBinaryEncoding() {
        return null;
    }

    public long getBatchId() {
        return -1L;
    }

    public String getSourceNodeId() {
        return this.nodeId;
    }

    public NodeChannel getChannel() {
        return this.channel;
    }

    public Map<String, Object> getContextCache() {
        return this.context;
    }

    public void setEncountedTransactionBoundary(boolean encountedTransactionBoundary) {
        this.encountedTransactionBoundary = encountedTransactionBoundary;
    }

    public boolean isEncountedTransactionBoundary() {
        return this.encountedTransactionBoundary;
    }

    public int getBatchSizeNotToExceed() {
        return this.batchSizeNotToExceed;
    }

    public void setBatchSizeNotToExceed(int batchSizeNotToExceed) {
        this.batchSizeNotToExceed = batchSizeNotToExceed;
    }

    public synchronized void incrementStat(long amount, String name) {
        Long val = this.stats.get(name);
        if (val == null) {
            val = 0L;
        }
        val = val + amount;
        this.stats.put(name, val);
    }

    public synchronized long getStat(String name) {
        Long val = this.stats.get(name);
        if (val == null) {
            val = 0L;
        }
        return val;
    }

    public synchronized void logStats(Logger log, long totalTimeInMs) {
        boolean infoLevel;
        boolean bl = infoLevel = totalTimeInMs > 30000L;
        if (infoLevel && log.isInfoEnabled() || log.isDebugEnabled()) {
            TreeSet<String> keys = new TreeSet<String>(this.stats.keySet());
            StringBuilder statsPrintout = new StringBuilder(this.channel.getChannelId());
            for (String key : keys) {
                statsPrintout.append(", " + key + "=" + this.stats.get(key));
            }
            if (infoLevel) {
                log.info("Routed channel {}", (Object)statsPrintout);
            } else {
                log.debug("Routed channel {}", (Object)statsPrintout);
            }
        }
    }

    public synchronized void transferStats(SimpleRouterContext ctx) {
        HashSet<String> keys = new HashSet<String>(ctx.stats.keySet());
        for (String key : keys) {
            Long value = this.stats.get(key);
            if (value == null) {
                value = 0L;
            }
            this.incrementStat(value, key);
        }
    }

    public class RouterTimer {
        private long queryTime = 0L;
        private long totalQueryTime = 0L;

        public void resetQueryTime() {
            this.queryTime = 0L;
        }

        public long getQueryTime() {
            return this.queryTime;
        }

        public long getTotalQueryTime() {
            return this.totalQueryTime;
        }

        public void addQueryTime(long qt) {
            this.queryTime += qt;
            this.totalQueryTime += qt;
        }
    }
}

