/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.service.FilterCriterion;

public interface INodeService {
    public Node findNode(String var1);

    public Node findNode(String var1, boolean var2);

    public Node findNodeInCacheOnly(String var1);

    public String getExternalId(String var1);

    public List<NodeHost> findNodeHosts(String var1);

    public boolean isRegistrationServer();

    public Node findNodeByExternalId(String var1, String var2);

    public Set<Node> findNodesThatOriginatedFromNodeId(String var1);

    public Set<Node> findNodesThatOriginatedFromNodeId(String var1, boolean var2);

    public Collection<Node> findEnabledNodesFromNodeGroup(String var1);

    public Collection<Node> findNodesWithOpenRegistration();

    public Map<String, NodeSecurity> findAllNodeSecurity(boolean var1);

    public List<NodeSecurity> findNodeSecurityWithLoadEnabled();

    public List<String> findAllExternalIds();

    public NodeSecurity findNodeSecurity(String var1);

    public NodeSecurity findNodeSecurity(String var1, boolean var2);

    public NodeSecurity findOrCreateNodeSecurity(String var1);

    public void deleteNodeHost(String var1);

    public void deleteNodeSecurity(String var1);

    public void deleteNode(String var1, boolean var2);

    public void deleteNode(String var1, String var2, boolean var3);

    public String findSymmetricVersion();

    public String findIdentityNodeId();

    public void ignoreNodeChannelForExternalId(boolean var1, String var2, String var3, String var4);

    public boolean isNodeAuthorized(String var1, String var2);

    public void flushNodeCache();

    public void flushNodeAuthorizedCache();

    public void flushNodeGroupCache();

    public boolean isRegistrationEnabled(String var1);

    public Node findIdentity();

    public Node findIdentity(boolean var1);

    public Node findIdentity(boolean var1, boolean var2);

    public Node getCachedIdentity();

    public boolean deleteIdentity();

    public List<Node> findAllNodes();

    public List<Node> findAllNodes(boolean var1);

    public Map<String, Node> findAllNodesAsMap();

    public List<Node> findFilteredNodesWithLimit(int var1, int var2, List<FilterCriterion> var3, String var4, String var5);

    public int countFilteredNodes(List<FilterCriterion> var1);

    public List<Node> findNodesToPull();

    public List<Node> findNodesToPushTo();

    public List<Node> findNodesWhoPushToMe();

    public List<Node> findNodesWhoPullFromMe();

    public List<Node> findSourceNodesFor(NodeGroupLinkAction var1);

    public List<Node> findTargetNodesFor(NodeGroupLinkAction var1);

    public List<Node> getSourceNodesFromDatabase(NodeGroupLinkAction var1, Node var2);

    public List<Node> getTargetNodesFromDatabase(NodeGroupLinkAction var1, Node var2);

    public boolean isExternalIdRegistered(String var1, String var2);

    public void save(Node var1);

    public void updateNodeHost(NodeHost var1);

    public void updateNodeHostForCurrentNode();

    public void insertNodeIdentity(String var1);

    public void insertNodeGroup(String var1, String var2);

    public boolean updateNodeSecurity(NodeSecurity var1);

    public boolean updateNodeSecurity(ISqlTransaction var1, NodeSecurity var2);

    public boolean setInitialLoadEnabled(String var1, boolean var2, boolean var3, long var4, String var6);

    public boolean setInitialLoadEnabled(ISqlTransaction var1, String var2, boolean var3, boolean var4, long var5, String var7);

    public boolean setInitialLoadEnded(ISqlTransaction var1, String var2);

    public boolean setReverseInitialLoadEnabled(ISqlTransaction var1, String var2, boolean var3, boolean var4, long var5, String var7);

    public boolean setReverseInitialLoadEnabled(String var1, boolean var2, boolean var3, long var4, String var6);

    public boolean isDataLoadCompleted();

    public boolean isDataLoadCompleted(String var1);

    public boolean isDataLoadStarted();

    public boolean isDataLoadStarted(String var1);

    public NodeStatus getNodeStatus();

    public NodeStatus getNodeStatus(String var1);

    public void checkForOfflineNodes();

    public List<Node> findOfflineNodes();

    public List<Node> findOfflineNodes(long var1);

    public Map<String, Date> findLastHeartbeats();

    public List<String> findOfflineNodeIds(long var1);

    public NetworkedNode getRootNetworkedNode();

    public Node findRootNode();

    public AuthenticationStatus getAuthenticationStatus(String var1, String var2);

    public void resetNodeFailedLogins(String var1);

    public void incrementNodeFailedLogins(String var1);

    public static enum AuthenticationStatus {
        SYNC_DISABLED,
        REGISTRATION_REQUIRED,
        FORBIDDEN,
        ACCEPTED,
        LOCKED;

    }
}

