/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.exception.HttpException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IOfflineDetectorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.InitialLoadPendingException;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationPendingException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.NoReservationException;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.SyncDisabledException;

public abstract class AbstractOfflineDetectorService
extends AbstractService
implements IOfflineDetectorService {
    protected IExtensionService extensionService;
    private Map<String, Long> transportErrorTimeByNode = new HashMap<String, Long>();

    public AbstractOfflineDetectorService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IExtensionService extensionService) {
        super(parameterService, symmetricDialect);
        this.extensionService = extensionService;
    }

    protected void fireOnline(Node remoteNode, RemoteNodeStatus status) {
        this.transportErrorTimeByNode.remove(remoteNode.getNodeId());
        List<IOfflineClientListener> offlineListeners = this.extensionService.getExtensionPointList(IOfflineClientListener.class);
        if (offlineListeners != null) {
            for (IOfflineClientListener listener : offlineListeners) {
                listener.online(remoteNode);
            }
        }
    }

    protected void fireOffline(Exception exception, Node remoteNode, RemoteNodeStatus status) {
        String syncUrl = remoteNode.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : remoteNode.getSyncUrl();
        Throwable cause = this.getRootCause(exception);
        if (cause == null) {
            cause = exception;
        }
        if (this.isOffline(exception)) {
            if (this.shouldLogTransportError(remoteNode.getNodeId())) {
                this.log.warn(String.format("Could not communicate with %s at %s because: %s", remoteNode, syncUrl, exception), (Throwable)exception);
            } else {
                this.log.info("Could not communicate with {} at {} because: {}", new Object[]{remoteNode, syncUrl, exception});
            }
            status.setStatus(RemoteNodeStatus.Status.OFFLINE);
        } else if (this.isServiceUnavailable(exception)) {
            if (this.shouldLogTransportError(remoteNode.getNodeId())) {
                this.log.warn("Remote node {} at {} was unavailable.", new Object[]{remoteNode, syncUrl});
            } else {
                this.log.info("Remote node {} at {} was unavailable.  It may be starting up.", new Object[]{remoteNode, syncUrl});
            }
            status.setStatus(RemoteNodeStatus.Status.OFFLINE);
        } else if (this.isBusy(exception)) {
            if (this.shouldLogTransportError(remoteNode.getNodeId())) {
                this.log.warn("Remote node {} at {} was busy", new Object[]{remoteNode, syncUrl});
            } else {
                this.log.info("Remote node {} at {} was busy", new Object[]{remoteNode, syncUrl});
            }
            status.setStatus(RemoteNodeStatus.Status.BUSY);
        } else if (this.isNotAuthenticated(exception)) {
            if (this.isAuthenticationExpired(exception)) {
                this.log.debug("Authentication is required again to renew session");
            } else {
                this.log.warn("Authorization denied from {} at {}", new Object[]{remoteNode, syncUrl});
            }
            status.setStatus(RemoteNodeStatus.Status.NOT_AUTHORIZED);
        } else if (this.isSyncDisabled(exception)) {
            this.log.warn("Sync was not enabled for {} at {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.SYNC_DISABLED);
        } else if (this.isRegistrationNotOpen(exception)) {
            this.log.warn("Registration was not open at {} {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isRegistrationRequired(exception)) {
            this.log.warn("Registration is needed before communicating with {} at {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isRegistrationPending(exception)) {
            this.log.info("Registration is still pending");
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isInitialLoadPending(exception)) {
            this.log.info("Initial load is pending for node {}", new Object[]{remoteNode});
            status.setStatus(RemoteNodeStatus.Status.INITIAL_LOAD_PENDING);
        } else if (this.isNoReservation(exception)) {
            this.log.warn("Missing reservation during push with {}", new Object[]{remoteNode});
            status.setStatus(RemoteNodeStatus.Status.BUSY);
        } else if (this.getHttpException(exception) != null) {
            HttpException http = this.getHttpException(exception);
            if (this.shouldLogTransportError(remoteNode.getNodeId())) {
                this.log.warn(String.format("Could not communicate with %s at %s because it returned HTTP code %s", remoteNode, syncUrl, http.getCode()), (Throwable)exception);
            } else {
                this.log.info("Could not communicate with {} at {} because it returned HTTP code {}", new Object[]{remoteNode, syncUrl, http.getCode()});
            }
        } else {
            this.log.warn(String.format("Could not communicate with node '%s' at %s because of unexpected error", remoteNode, syncUrl), (Throwable)exception);
            status.setStatus(RemoteNodeStatus.Status.UNKNOWN_ERROR);
        }
        List<IOfflineClientListener> offlineListeners = this.extensionService.getExtensionPointList(IOfflineClientListener.class);
        if (offlineListeners != null) {
            for (IOfflineClientListener listener : offlineListeners) {
                if (this.isOffline(exception)) {
                    listener.offline(remoteNode);
                    continue;
                }
                if (this.isBusy(exception)) {
                    listener.busy(remoteNode);
                    continue;
                }
                if (this.isNotAuthenticated(exception)) {
                    listener.notAuthenticated(remoteNode);
                    continue;
                }
                if (this.isSyncDisabled(exception)) {
                    listener.syncDisabled(remoteNode);
                    continue;
                }
                if (this.isRegistrationRequired(exception)) {
                    listener.registrationRequired(remoteNode);
                    continue;
                }
                listener.unknownError(remoteNode, exception);
            }
        }
    }

    protected boolean shouldLogTransportError(String nodeId) {
        long maxErrorMillis = this.parameterService.getLong("transport.max.error.millis", 300000L);
        Long errorTime = this.transportErrorTimeByNode.get(nodeId);
        if (errorTime == null) {
            errorTime = System.currentTimeMillis();
            this.transportErrorTimeByNode.put(nodeId, errorTime);
        }
        return System.currentTimeMillis() - errorTime >= maxErrorMillis;
    }

    protected boolean isOffline(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            if (cause == null) {
                cause = ex;
            }
            offline = cause instanceof SocketException || cause instanceof ConnectException || cause instanceof SocketTimeoutException || cause instanceof UnknownHostException;
        }
        return offline;
    }

    protected boolean isNotAuthenticated(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            offline = ex instanceof AuthenticationException || cause instanceof AuthenticationException;
        }
        return offline;
    }

    protected boolean isAuthenticationExpired(Exception ex) {
        boolean expired = false;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            AuthenticationException authException = null;
            if (ex instanceof AuthenticationException) {
                authException = (AuthenticationException)((Object)ex);
            }
            if (cause instanceof AuthenticationException) {
                authException = (AuthenticationException)((Object)cause);
            }
            if (authException != null) {
                expired = authException.isExpiredSession();
            }
        }
        return expired;
    }

    protected boolean isBusy(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            offline = ex instanceof ConnectionRejectedException || cause instanceof ConnectionRejectedException;
        }
        return offline;
    }

    protected boolean isServiceUnavailable(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            offline = ex instanceof ServiceUnavailableException || cause instanceof ServiceUnavailableException;
        }
        return offline;
    }

    protected boolean isSyncDisabled(Exception ex) {
        Throwable cause;
        boolean syncDisabled = false;
        if (ex != null && !(syncDisabled = (cause = this.getRootCause(ex)) instanceof SyncDisabledException) && ex instanceof SyncDisabledException) {
            syncDisabled = true;
        }
        return syncDisabled;
    }

    protected boolean isRegistrationRequired(Exception ex) {
        Throwable cause;
        boolean registrationRequired = false;
        if (ex != null && !(registrationRequired = (cause = this.getRootCause(ex)) instanceof RegistrationRequiredException) && ex instanceof RegistrationRequiredException) {
            registrationRequired = true;
        }
        return registrationRequired;
    }

    protected boolean isRegistrationPending(Exception ex) {
        Throwable cause;
        boolean registrationPending = false;
        if (ex != null && !(registrationPending = (cause = this.getRootCause(ex)) instanceof RegistrationPendingException) && ex instanceof RegistrationPendingException) {
            registrationPending = true;
        }
        return registrationPending;
    }

    protected boolean isInitialLoadPending(Exception ex) {
        Throwable cause;
        boolean loadPending = false;
        if (ex != null && !(loadPending = (cause = this.getRootCause(ex)) instanceof RegistrationPendingException) && ex instanceof InitialLoadPendingException) {
            loadPending = true;
        }
        return loadPending;
    }

    protected boolean isRegistrationNotOpen(Exception ex) {
        Throwable cause;
        boolean registrationNotOpen = false;
        if (ex != null && !(registrationNotOpen = (cause = this.getRootCause(ex)) instanceof RegistrationNotOpenException) && ex instanceof RegistrationNotOpenException) {
            registrationNotOpen = true;
        }
        return registrationNotOpen;
    }

    protected boolean isNoReservation(Exception ex) {
        Throwable cause;
        boolean noReservation = false;
        if (ex != null && !(noReservation = (cause = this.getRootCause(ex)) instanceof NoReservationException) && ex instanceof NoReservationException) {
            noReservation = true;
        }
        return noReservation;
    }

    protected HttpException getHttpException(Exception ex) {
        HttpException exception = null;
        if (ex != null) {
            Throwable cause = this.getRootCause(ex);
            if (cause instanceof HttpException) {
                exception = (HttpException)cause;
            } else if (ex instanceof HttpException) {
                exception = (HttpException)ex;
            }
        }
        return exception;
    }

    protected Throwable getRootCause(Exception ex) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
        if (cause == null) {
            cause = ex;
        }
        return cause;
    }
}

