/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.HttpException;
import org.jumpmind.exception.InvalidRetryException;
import org.jumpmind.exception.IoException;
import org.jumpmind.extension.IProcessInfoListener;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.ext.INodeRegistrationListener;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.DataProcessor;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.io.data.reader.ProtocolDataReader;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.ConflictException;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.io.stage.SimpleStagingDataWriter;
import org.jumpmind.symmetric.io.stage.StagingLowFreeSpace;
import org.jumpmind.symmetric.load.ConfigurationChangedDatabaseWriterFilter;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.load.DynamicDatabaseWriterFilter;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.load.ILoadSyncLifecycleListener;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.IncomingError;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoDataWriter;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.DataLoaderServiceSqlMap;
import org.jumpmind.symmetric.service.impl.ManageIncomingBatchListener;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.internal.InternalIncomingTransport;
import org.jumpmind.util.CustomizableThreadFactory;
import org.slf4j.MDC;

public class DataLoaderService
extends AbstractService
implements IDataLoaderService {
    private IIncomingBatchService incomingBatchService;
    private IConfigurationService configurationService;
    private ITransportManager transportManager;
    private IStatisticManager statisticManager;
    private INodeService nodeService;
    private ITransformService transformService;
    private ILoadFilterService loadFilterService;
    private IStagingManager stagingManager;
    private IExtensionService extensionService;
    private INodeCommunicationService nodeCommunicationService;
    private ISymmetricEngine engine = null;
    private Date lastUpdateTime;
    private CustomizableThreadFactory threadFactory;
    private ICacheManager cacheManager;

    public DataLoaderService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.incomingBatchService = engine.getIncomingBatchService();
        this.configurationService = engine.getConfigurationService();
        this.transportManager = engine.getTransportManager();
        this.statisticManager = engine.getStatisticManager();
        this.nodeService = engine.getNodeService();
        this.transformService = engine.getTransformService();
        this.loadFilterService = engine.getLoadFilterService();
        this.stagingManager = engine.getStagingManager();
        this.setSqlMap(new DataLoaderServiceSqlMap(this.platform, this.createSqlReplacementTokens()));
        this.extensionService = engine.getExtensionService();
        this.extensionService.addExtensionPoint(new DefaultDataLoaderFactory(engine));
        this.extensionService.addExtensionPoint(new ConfigurationChangedDatabaseWriterFilter(engine));
        this.nodeCommunicationService = engine.getNodeCommunicationService();
        this.cacheManager = engine.getCacheManager();
        this.engine = engine;
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxLastUpdateTime"), Date.class, new Object[0]);
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer conflict settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAvailableDataLoaderFactories() {
        return new ArrayList<String>(this.getDataLoaderFactories().keySet());
    }

    protected Map<String, IDataLoaderFactory> getDataLoaderFactories() {
        HashMap<String, IDataLoaderFactory> dataLoaderFactories = new HashMap<String, IDataLoaderFactory>();
        for (IDataLoaderFactory factory : this.engine.getExtensionService().getExtensionPointList(IDataLoaderFactory.class)) {
            dataLoaderFactories.put(factory.getTypeName(), factory);
        }
        return dataLoaderFactories;
    }

    @Override
    public List<IncomingBatch> loadDataBatch(String batchData) {
        return this.loadDataBatch(batchData, null);
    }

    @Override
    public List<IncomingBatch> loadDataBatch(String batchData, IProcessInfoListener listener) {
        String nodeId = this.nodeService.findIdentityNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(nodeId, nodeId, ProcessType.MANUAL_LOAD));
            processInfo.setListener(listener);
            try {
                InternalIncomingTransport transport = new InternalIncomingTransport(new BufferedReader(new StringReader(batchData)));
                List<IncomingBatch> list = this.loadDataFromTransport(processInfo, this.nodeService.findIdentity(), transport, null);
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                return list;
            }
            catch (IOException ex) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw new IoException();
            }
            catch (RuntimeException ex) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw ex;
            }
        }
        return new ArrayList<IncomingBatch>(0);
    }

    @Override
    public RemoteNodeStatus loadDataFromPull(Node remote, String queue) throws IOException {
        RemoteNodeStatus status = new RemoteNodeStatus(remote != null ? remote.getNodeId() : null, queue, this.configurationService.getChannels(false));
        this.loadDataFromPull(remote, status);
        return status;
    }

    @Override
    public void loadDataFromPull(Node remote, RemoteNodeStatus status) throws IOException {
        Node local = this.nodeService.findIdentity();
        if (local == null) {
            local = new Node(this.parameterService, this.symmetricDialect, this.engine.getDatabasePlatform().getName());
            local.setDeploymentType(this.engine.getDeploymentType());
        }
        try {
            NodeSecurity localSecurity = this.nodeService.findNodeSecurity(local.getNodeId(), true);
            IIncomingTransport transport = null;
            boolean isRegisterTransport = false;
            if (remote != null && localSecurity != null) {
                HashMap<String, String> requestProperties = new HashMap<String, String>();
                ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists();
                requestProperties.put("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
                requestProperties.put("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
                requestProperties.put("threadChannel", status.getQueue());
                transport = this.transportManager.getPullTransport(remote, local, localSecurity.getNodePassword(), requestProperties, this.parameterService.getRegistrationUrl());
            } else {
                List<INodeRegistrationListener> registrationListeners = this.extensionService.getExtensionPointList(INodeRegistrationListener.class);
                HashMap<String, String> requestProps = new HashMap<String, String>();
                for (INodeRegistrationListener l : registrationListeners) {
                    Map<String, String> props = l.getRequestProperties();
                    if (props == null) continue;
                    requestProps.putAll(props);
                }
                transport = this.transportManager.getRegisterTransport(local, this.parameterService.getRegistrationUrl(), requestProps);
                this.log.info("Using registration URL of {}", (Object)transport.getUrl());
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationUrlUpdated(transport.getUrl());
                }
                remote = new Node();
                remote.setSyncUrl(this.parameterService.getRegistrationUrl());
                isRegisterTransport = true;
            }
            ProcessInfo transferInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(remote.getNodeId(), status.getQueue(), local.getNodeId(), ProcessType.PULL_JOB_TRANSFER));
            try {
                List<IncomingBatch> list = this.loadDataFromTransport(transferInfo, remote, transport, null);
                if (list.size() > 0) {
                    transferInfo.setStatus(ProcessInfo.ProcessStatus.ACKING);
                    status.updateIncomingStatus(list);
                    local = this.nodeService.findIdentity();
                    if (local != null) {
                        localSecurity = this.nodeService.findNodeSecurity(local.getNodeId(), !isRegisterTransport);
                        if (StringUtils.isNotBlank((CharSequence)transport.getRedirectionUrl())) {
                            String url = transport.getRedirectionUrl();
                            int index = url.indexOf("/registration?");
                            if (index >= 0) {
                                url = url.substring(0, index);
                            }
                            this.log.info("Setting the sync url for ack to: {}", (Object)url);
                            remote.setSyncUrl(url);
                        }
                        this.sendAck(remote, local, localSecurity, list, this.transportManager, status.getQueue());
                    }
                }
                if (this.containsError(list)) {
                    transferInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                } else {
                    transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                this.updateBatchToSendCount(remote, transport);
                this.purgeLoadBatchesFromStaging(list);
            }
            catch (RuntimeException e) {
                transferInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw e;
            }
            catch (IOException e) {
                transferInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw e;
            }
        }
        catch (RegistrationRequiredException e) {
            if (StringUtils.isBlank((CharSequence)remote.getSyncUrl()) || remote.getSyncUrl().equalsIgnoreCase(this.parameterService.getRegistrationUrl())) {
                this.log.warn("Node information missing on the server.  Attempting to re-register remote.getSyncUrl()={}", (Object)remote.getSyncUrl());
                this.loadDataFromPull(null, status);
                this.nodeService.findIdentity(false);
            } else {
                this.log.warn("Failed to pull data from node '{}'. It probably is missing a node security record for '{}'.", (Object)remote.getNodeId(), (Object)local.getNodeId());
            }
        }
        catch (MalformedURLException e) {
            if (remote != null) {
                this.log.error("Could not connect to the {} node's transport because of a bad URL: '{}' {}", new Object[]{remote.getNodeId(), remote.getSyncUrl(), e});
            } else {
                this.log.error("", (Throwable)e);
            }
            throw e;
        }
    }

    protected void updateBatchToSendCount(Node remote, IIncomingTransport transport) {
        Map<String, String> headers = transport.getHeaders();
        if (headers != null && headers.containsKey("Batch-To-Send-Count")) {
            Map<String, Integer> queuesToBatchCounts = this.nodeCommunicationService.parseQueueToBatchCounts(headers.get("Batch-To-Send-Count"));
            this.nodeCommunicationService.updateBatchToSendCounts(remote.getNodeId(), queuesToBatchCounts);
        }
    }

    private boolean containsError(List<IncomingBatch> list) {
        for (IncomingBatch incomingBatch : list) {
            if (incomingBatch.getStatus() != AbstractBatch.Status.ER) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadDataFromPush(Node sourceNode, InputStream in, OutputStream out) throws IOException {
        this.loadDataFromPush(sourceNode, null, in, out);
    }

    @Override
    public void loadDataFromPush(Node sourceNode, String queue, InputStream in, OutputStream out) throws IOException {
        Node local = this.nodeService.findIdentity();
        if (sourceNode != null && sourceNode.getNodeId() != null) {
            ProcessInfo transferInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(sourceNode.getNodeId(), queue, local != null ? local.getNodeId() : null, ProcessType.PUSH_HANDLER_TRANSFER));
            try {
                List<IncomingBatch> batchList = this.loadDataFromTransport(transferInfo, sourceNode, new InternalIncomingTransport(in), out);
                this.logDataReceivedFromPush(sourceNode, batchList, transferInfo);
                if (local == null) {
                    local = this.nodeService.findIdentity(false);
                }
                if (local == null || local.getNodeId() == null) {
                    this.log.info("Could not load data because the node is not registered");
                    throw new RegistrationRequiredException();
                }
                NodeSecurity security = this.nodeService.findNodeSecurity(local.getNodeId());
                transferInfo.setStatus(ProcessInfo.ProcessStatus.ACKING);
                this.transportManager.writeAcknowledgement(out, sourceNode, batchList, local, security != null ? security.getNodePassword() : null);
                transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                this.purgeLoadBatchesFromStaging(batchList);
            }
            catch (Exception e) {
                transferInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void logDataReceivedFromPush(Node sourceNode, List<IncomingBatch> batchList, ProcessInfo processInfo) {
        int okBatchesCount = 0;
        int errorBatchesCount = 0;
        int okDataCount = 0;
        for (IncomingBatch incomingBatch : batchList) {
            if (incomingBatch.getStatus() == AbstractBatch.Status.OK) {
                ++okBatchesCount;
                okDataCount = (int)((long)okDataCount + incomingBatch.getLoadRowCount());
                continue;
            }
            if (incomingBatch.getStatus() != AbstractBatch.Status.ER) continue;
            ++errorBatchesCount;
        }
        if (okBatchesCount > 0) {
            if (errorBatchesCount > 0) {
                this.log.info("{} data and {} batches loaded during push request from {}.  There were {} batches in error", new Object[]{okDataCount, okBatchesCount, sourceNode.toString(), errorBatchesCount});
            } else {
                this.log.info("{} data and {} batches loaded during push request from {}", new Object[]{okDataCount, okBatchesCount, sourceNode.toString()});
            }
            this.statisticManager.addJobStats(sourceNode.getNodeId(), 1, "Push Handler", processInfo.getStartTime().getTime(), processInfo.getLastStatusChangeTime().getTime(), okDataCount);
        }
    }

    protected void purgeLoadBatchesFromStaging(List<IncomingBatch> batchList) {
        long threshold = this.parameterService.getLong("initial.load.purge.stage.immediate.threshold.rows");
        if (threshold >= 0L && batchList != null) {
            for (IncomingBatch batch : batchList) {
                IStagedResource resource;
                if (!batch.isLoadFlag() || batch.isCommonFlag() || batch.getDataRowCount() < threshold || (resource = this.engine.getStagingManager().find(new Object[]{"incoming", batch.getStagedLocation(), batch.getBatchId()})) == null) continue;
                resource.delete();
            }
        }
    }

    @Override
    public List<IncomingBatch> loadDataFromOfflineTransport(Node remote, RemoteNodeStatus status, IIncomingTransport transport) throws IOException {
        Node local = this.nodeService.findIdentity();
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(remote.getNodeId(), local.getNodeId(), ProcessType.OFFLINE_PULL));
        List<IncomingBatch> list = null;
        try {
            list = this.loadDataFromTransport(processInfo, remote, transport, null);
            if (list.size() > 0) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ACKING);
                status.updateIncomingStatus(list);
            }
            if (this.containsError(list)) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            } else {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
        }
        catch (RuntimeException e) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw e;
        }
        catch (IOException e) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw e;
        }
        return list;
    }

    @Override
    public void loadDataFromConfig(Node remote, RemoteNodeStatus status, boolean force) throws IOException {
        if (this.engine.getParameterService().isRegistrationServer() || remote == null || Version.isOlderThanVersion(remote.getSymmetricVersion(), "3.8.22")) {
            return;
        }
        Node local = this.nodeService.findIdentity();
        try {
            NodeSecurity localSecurity = this.nodeService.findNodeSecurity(local.getNodeId(), true);
            String configVersion = force ? "" : local.getConfigVersion();
            IIncomingTransport transport = this.engine.getTransportManager().getConfigTransport(remote, local, localSecurity.getNodePassword(), Version.version(), configVersion, remote.getSyncUrl());
            ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(remote.getNodeId(), "config", local.getNodeId(), ProcessType.PULL_CONFIG_JOB));
            try {
                this.log.info("Requesting current configuration {symmetricVersion={}, configVersion={}}", (Object)Version.version(), (Object)local.getConfigVersion());
                List<IncomingBatch> list = this.loadDataFromTransport(processInfo, remote, transport, null);
                if (this.containsError(list)) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                } else {
                    if (list.size() > 0) {
                        status.updateIncomingStatus(list);
                        local.setConfigVersion(Version.version());
                        this.nodeService.save(local);
                    }
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
            }
            catch (RuntimeException e) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw e;
            }
            catch (IOException e) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw e;
            }
        }
        catch (RegistrationRequiredException e) {
            this.log.warn("Failed to pull configuration from node '{}'. It probably is missing a node security record for '{}'.", (Object)remote.getNodeId(), (Object)local.getNodeId());
        }
        catch (MalformedURLException e) {
            this.log.error("Could not connect to the {} node's transport because of a bad URL: '{}' {}", new Object[]{remote.getNodeId(), remote.getSyncUrl(), e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IncomingBatch> loadDataFromTransport(ProcessInfo transferInfo, final Node sourceNode, IIncomingTransport transport, OutputStream out) throws IOException {
        ManageIncomingBatchListener listener = new ManageIncomingBatchListener(transferInfo, this.engine);
        DataContext ctx = new DataContext();
        Throwable error = null;
        try {
            Node targetNode = this.nodeService.findIdentity();
            ctx.put("engine", (Object)this.engine);
            if (targetNode != null) {
                ctx.put("targetNode", (Object)targetNode);
                ctx.put("targetNodeId", (Object)targetNode.getNodeId());
                ctx.put("targetNodeGroupId", (Object)targetNode.getNodeGroupId());
                ctx.put("targetNodeExternalId", (Object)targetNode.getExternalId());
            }
            ctx.put("sourceNode", (Object)sourceNode);
            ctx.put("sourceNodeId", (Object)sourceNode.getNodeId());
            ctx.put("sourceNodeGroupId", (Object)sourceNode.getNodeGroupId());
            ctx.put("sourceNodeExternalId", (Object)sourceNode.getExternalId());
            for (ILoadSyncLifecycleListener l : this.extensionService.getExtensionPointList(ILoadSyncLifecycleListener.class)) {
                l.syncStarted(ctx);
            }
            long memoryThresholdInBytes = this.parameterService.getLong("stream.to.file.threshold.bytes");
            String targetNodeId = this.nodeService.findIdentityNodeId();
            boolean streamToFile = this.parameterService.is("stream.to.file.enabled");
            if (streamToFile) {
                transferInfo.setStatus(ProcessInfo.ProcessStatus.TRANSFERRING);
                if (this.threadFactory == null) {
                    this.threadFactory = new CustomizableThreadFactory(this.parameterService.getEngineName().toLowerCase() + "-dataloader");
                }
                ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)this.threadFactory);
                LoadIntoDatabaseOnArrivalListener loadListener = new LoadIntoDatabaseOnArrivalListener(transferInfo, sourceNode.getNodeId(), listener, executor);
                SimpleStagingDataWriter stageWriter = null;
                try {
                    stageWriter = new SimpleStagingDataWriter(transferInfo, transport.openReader(), this.stagingManager, "incoming", memoryThresholdInBytes, Batch.BatchType.LOAD, targetNodeId, ctx, loadListener);
                    stageWriter.process();
                }
                finally {
                    executor.shutdown();
                }
                OutputStreamWriter outWriter = null;
                if (out != null) {
                    try {
                        outWriter = new OutputStreamWriter(out, StandardCharsets.UTF_8);
                        long keepAliveMillis = this.parameterService.getLong("send.ack.keepalive.ms");
                        while (!executor.awaitTermination(keepAliveMillis, TimeUnit.MILLISECONDS)) {
                            outWriter.write("1=1&");
                            outWriter.flush();
                        }
                    }
                    catch (Exception ex) {
                        this.log.info("Could not send keep alives to " + sourceNode + " " + ex);
                        this.awaitTermination(executor);
                    }
                } else {
                    transport.close();
                    this.awaitTermination(executor);
                }
                loadListener.isDone();
                if (stageWriter.getException() != null) {
                    throw stageWriter.getException();
                }
            } else {
                transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                final ProcessInfo loadInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(sourceNode.getNodeId(), transferInfo.getQueue(), this.nodeService.findIdentityNodeId(), ProcessType.PULL_JOB_LOAD));
                try {
                    DataProcessor processor = new DataProcessor((IDataReader)new ProtocolDataReader(Batch.BatchType.LOAD, targetNodeId, (Reader)transport.openReader(), streamToFile), null, listener, "data load"){

                        protected IDataWriter chooseDataWriter(Batch batch) {
                            return DataLoaderService.this.buildDataWriter(loadInfo, sourceNode.getNodeId(), batch.getChannelId(), batch.getBatchId(), ((ManageIncomingBatchListener)this.listener).getCurrentBatch().isRetry());
                        }
                    };
                    processor.process(ctx);
                    loadInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                catch (Throwable e) {
                    loadInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    throw e;
                }
            }
            transport.close();
        }
        catch (Throwable ex) {
            try {
                error = ex;
                if (this.parameterService.is("auto.resolve.foreign.key.violation.reverse.reload") && listener.getCurrentBatch() != null && listener.isNewErrorForCurrentBatch() && listener.getCurrentBatch().isLoadFlag() && listener.getCurrentBatch().getSqlCode() == -900 && !Version.isOlderThanVersion(sourceNode.getSymmetricVersion(), "3.12.6")) {
                    this.engine.getDataService().reloadMissingForeignKeyRowsForLoad(sourceNode.getNodeId(), ctx.getBatch().getBatchId(), listener.getCurrentBatch().getFailedLineNumber(), ctx.getTable(), ctx.getData(), "config");
                }
                if (this.parameterService.is("auto.resolve.foreign.key.violation.reverse") && listener.getCurrentBatch() != null && listener.isNewErrorForCurrentBatch() && !listener.getCurrentBatch().isLoadFlag() && listener.getCurrentBatch().getSqlCode() == -900) {
                    this.engine.getDataService().reloadMissingForeignKeyRowsReverse(sourceNode.getNodeId(), ctx.getTable(), ctx.getData(), null, this.parameterService.is("auto.resolve.foreign.key.violation.reverse.peers"));
                }
                this.logOrRethrow(ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                transport.close();
                for (ILoadSyncLifecycleListener l : this.extensionService.getExtensionPointList(ILoadSyncLifecycleListener.class)) {
                    l.syncEnded(ctx, listener.getBatchesProcessed(), error);
                }
            }
        }
        for (ILoadSyncLifecycleListener l : this.extensionService.getExtensionPointList(ILoadSyncLifecycleListener.class)) {
            l.syncEnded(ctx, listener.getBatchesProcessed(), error);
        }
        List<IncomingBatch> batchesProcessed = listener.getBatchesProcessed();
        if (error != null && error instanceof ProtocolException) {
            batchesProcessed.add(new IncomingBatch());
        }
        return batchesProcessed;
    }

    private void awaitTermination(ExecutorService executor) throws InterruptedException {
        long hours = 1L;
        while (!executor.awaitTermination(1L, TimeUnit.HOURS)) {
            this.log.info("Executor has been awaiting loader termination for {} hour(s).", (Object)hours);
            ++hours;
        }
    }

    protected void logOrRethrow(Throwable ex) throws IOException {
        if (ex instanceof RegistrationRequiredException) {
            throw (RegistrationRequiredException)ex;
        }
        if (ex instanceof ConnectException) {
            throw (ConnectException)ex;
        }
        if (ex instanceof UnknownHostException) {
            throw (UnknownHostException)ex;
        }
        if (ex instanceof RegistrationNotOpenException) {
            throw (RegistrationNotOpenException)ex;
        }
        if (ex instanceof ConnectionRejectedException) {
            throw (ConnectionRejectedException)((Object)ex);
        }
        if (ex instanceof ServiceUnavailableException) {
            throw (ServiceUnavailableException)((Object)ex);
        }
        if (ex instanceof AuthenticationException) {
            throw (AuthenticationException)((Object)ex);
        }
        if (ex instanceof SyncDisabledException) {
            throw (SyncDisabledException)((Object)ex);
        }
        if (ex instanceof HttpException) {
            throw (HttpException)ex;
        }
        if (ex instanceof InvalidRetryException) {
            throw (InvalidRetryException)ex;
        }
        if (ex instanceof ProtocolException) {
            this.log.error("Failed to process batch: {}: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        } else if (ex instanceof StagingLowFreeSpace) {
            this.log.error("Loading is disabled because disk is almost full: {}", (Object)ex.getMessage());
        } else if (!(ex instanceof ConflictException || ex instanceof SqlException || ex instanceof CancellationException)) {
            this.log.error("Failed to process batch", ex);
        } else {
            this.log.debug("Failed to process batch", ex);
        }
    }

    protected IDataWriter buildDataWriter(ProcessInfo processInfo, String sourceNodeId, String channelId, long batchId, boolean isRetry) {
        List<TransformService.TransformTableNodeGroupLink> transformsList;
        List<IDatabaseWriterErrorHandler> errorHandlers;
        List<IDatabaseWriterFilter> filters;
        TransformTable[] transforms = null;
        NodeGroupLink link = null;
        ArrayList<ResolvedData> resolvedDatas = new ArrayList<ResolvedData>();
        List<IDatabaseWriterFilter> dynamicFilters = filters = this.extensionService.getExtensionPointList(IDatabaseWriterFilter.class);
        List<IDatabaseWriterErrorHandler> dynamicErrorHandlers = errorHandlers = this.extensionService.getExtensionPointList(IDatabaseWriterErrorHandler.class);
        if (sourceNodeId != null) {
            Node sourceNode = this.nodeService.findNode(sourceNodeId, true);
            if (sourceNode != null) {
                link = new NodeGroupLink(sourceNode.getNodeGroupId(), this.parameterService.getNodeGroupId());
            }
            Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>> loadFilters = this.loadFilterService.findLoadFiltersFor(link, true);
            List<DynamicDatabaseWriterFilter> databaseWriterFilters = DynamicDatabaseWriterFilter.getDatabaseWriterFilters(this.engine, loadFilters);
            if (loadFilters != null && loadFilters.size() > 0) {
                dynamicFilters = new ArrayList<IDatabaseWriterFilter>(filters.size() + 1);
                dynamicFilters.addAll(filters);
                dynamicFilters.addAll(databaseWriterFilters);
                dynamicErrorHandlers = new ArrayList<IDatabaseWriterErrorHandler>(errorHandlers.size() + 1);
                dynamicErrorHandlers.addAll(errorHandlers);
                dynamicErrorHandlers.addAll(databaseWriterFilters);
            }
            if (isRetry) {
                List<IncomingError> incomingErrors = this.getIncomingErrors(batchId, sourceNodeId);
                for (IncomingError incomingError : incomingErrors) {
                    if (!incomingError.isResolveIgnore() && !StringUtils.isNotBlank((CharSequence)incomingError.getResolveData())) continue;
                    resolvedDatas.add(new ResolvedData(incomingError.getFailedRowNumber(), incomingError.getResolveData(), incomingError.isResolveIgnore()));
                }
            }
        }
        transforms = (transformsList = this.transformService.findTransformsFor(link, TransformPoint.LOAD)) != null ? transformsList.toArray(new TransformTable[transformsList.size()]) : null;
        TransformWriter transformWriter = new TransformWriter(this.engine.getSymmetricDialect().getTargetPlatform(), TransformPoint.LOAD, null, this.transformService.getColumnTransforms(), transforms);
        IDataWriter targetWriter = this.getFactory(channelId).getDataWriter(sourceNodeId, this.engine.getSymmetricDialect(), transformWriter, dynamicFilters, dynamicErrorHandlers, this.getConflictSettingsNodeGroupLinks(link, false), resolvedDatas);
        transformWriter.setNestedWriter((IDataWriter)new ProcessInfoDataWriter(targetWriter, processInfo));
        return transformWriter;
    }

    protected IDataLoaderFactory getFactory(String channelId) {
        Map<String, IDataLoaderFactory> dataLoaderFactories;
        Channel channel = this.configurationService.getChannel(channelId);
        String dataLoaderType = "default";
        IDataLoaderFactory factory = null;
        if (channel != null) {
            dataLoaderType = DataLoaderService.filterDataLoaderType(channel.getDataLoaderType());
        }
        if ((factory = (dataLoaderFactories = this.getDataLoaderFactories()).get(dataLoaderType)) == null) {
            this.log.warn("Could not find a data loader factory of type '{}'.  Using the 'default' data loader.", (Object)dataLoaderType);
            factory = dataLoaderFactories.get("default");
        }
        if (!factory.isPlatformSupported(this.symmetricDialect.getTargetPlatform())) {
            this.log.warn("The current platform does not support a data loader type of '{}'.  Using the 'default' data loader.", (Object)dataLoaderType);
            factory = dataLoaderFactories.get("default");
        }
        return factory;
    }

    @Override
    public List<ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks() {
        ArrayList<ConflictNodeGroupLink> list = new ArrayList();
        list = this.sqlTemplate.query(this.getSql("selectConflictSettingsSql"), (ISqlRowMapper)new ConflictSettingsNodeGroupLinkMapper(), new Object[0]);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        DataLoaderService dataLoaderService = this;
        synchronized (dataLoaderService) {
            this.cacheManager.flushConflictSettingsNodeGroupLinks();
        }
    }

    @Override
    public List<ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks(NodeGroupLink link, boolean refreshCache) {
        if (link != null) {
            return this.cacheManager.getConflictSettingsNodeGroupLinks(link, refreshCache);
        }
        return new ArrayList<ConflictNodeGroupLink>(0);
    }

    @Override
    public List<ConflictNodeGroupLink> getConflictSettinsNodeGroupLinksFromDb(NodeGroupLink link) {
        return this.sqlTemplate.query(this.getSql("selectConflictSettingsSql", " where source_node_group_id=? and target_node_group_id=?"), (ISqlRowMapper)new ConflictSettingsNodeGroupLinkMapper(), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId()});
    }

    @Override
    public void delete(ConflictNodeGroupLink settings) {
        this.delete(settings.getConflictId());
    }

    private void delete(String id) {
        this.sqlTemplate.update(this.getSql("deleteConflictSettingsSql"), new Object[]{id});
    }

    @Override
    public void deleteAllConflicts() {
        this.sqlTemplate.update(this.getSql("deleteAllConflictSettingsSql"), new Object[0]);
    }

    @Override
    public void save(ConflictNodeGroupLink setting) {
        this.cacheManager.flushConflictSettingsNodeGroupLinks();
        if (this.sqlTemplate.update(this.getSql("updateConflictSettingsSql"), new Object[]{setting.getNodeGroupLink().getSourceNodeGroupId(), setting.getNodeGroupLink().getTargetNodeGroupId(), setting.getTargetChannelId(), setting.getTargetCatalogName(), setting.getTargetSchemaName(), setting.getTargetTableName(), setting.getDetectType().name(), setting.getResolveType().name(), setting.getPingBack().name(), setting.isResolveChangesOnly() ? 1 : 0, setting.isResolveRowOnly() ? 1 : 0, setting.getDetectExpression(), setting.getLastUpdateBy(), new Date(), setting.getConflictId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 12, 12, 93, 12}) <= 0) {
            this.sqlTemplate.update(this.getSql("insertConflictSettingsSql"), new Object[]{setting.getNodeGroupLink().getSourceNodeGroupId(), setting.getNodeGroupLink().getTargetNodeGroupId(), setting.getTargetChannelId(), setting.getTargetCatalogName(), setting.getTargetSchemaName(), setting.getTargetTableName(), setting.getDetectType().name(), setting.getResolveType().name(), setting.getPingBack().name(), setting.isResolveChangesOnly() ? 1 : 0, setting.isResolveRowOnly() ? 1 : 0, setting.getDetectExpression(), new Date(), setting.getLastUpdateBy(), new Date(), setting.getConflictId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 12, 93, 12, 93, 12});
        }
    }

    @Override
    public void saveAsCopy(ConflictNodeGroupLink settings) {
        String newId = settings.getConflictId();
        List conflicts = this.sqlTemplate.query(this.getSql("selectConflictSettingsSql", "whereConflictIdLike"), (ISqlRowMapper)new ConflictSettingsNodeGroupLinkMapper(), new Object[]{newId + "%"});
        List ids = conflicts.stream().map(Conflict::getConflictId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        settings.setConflictId(newId + suffix);
        this.save(settings);
    }

    @Override
    public void rename(String oldId, ConflictNodeGroupLink setting) {
        this.delete(oldId);
        this.save(setting);
    }

    @Override
    public List<IncomingError> getIncomingErrors(long batchId, String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectIncomingErrorSql"), (ISqlRowMapper)new IncomingErrorMapper(), new Object[]{batchId, nodeId});
    }

    @Override
    public IncomingError getIncomingError(long batchId, String nodeId, long rowNumber) {
        return (IncomingError)this.sqlTemplate.queryForObject(this.getSql("selectIncomingErrorSql") + " and failed_row_number = ?", (ISqlRowMapper)new IncomingErrorMapper(), new Object[]{batchId, nodeId, rowNumber});
    }

    @Override
    public IncomingError getCurrentIncomingError(long batchId, String nodeId) {
        return (IncomingError)this.sqlTemplate.queryForObject(this.getSql("selectCurrentIncomingErrorSql"), (ISqlRowMapper)new IncomingErrorMapper(), new Object[]{batchId, nodeId});
    }

    @Override
    public void insertIncomingError(IncomingError incomingError) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.insertIncomingError(transaction, incomingError);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public void insertIncomingError(ISqlTransaction transaction, IncomingError incomingError) {
        if (StringUtils.isNotBlank((CharSequence)incomingError.getNodeId()) && incomingError.getBatchId() >= 0L) {
            boolean alreadyExists = false;
            if (this.symmetricDialect.getDriverName() != null && this.symmetricDialect.getDriverName().equalsIgnoreCase("openedge") && this.getIncomingError(incomingError.getBatchId(), incomingError.getNodeId(), incomingError.getFailedRowNumber()) != null) {
                alreadyExists = true;
            }
            if (!alreadyExists) {
                transaction.prepareAndExecute(this.getSql("insertIncomingErrorSql"), new Object[]{incomingError.getBatchId(), incomingError.getNodeId(), incomingError.getFailedRowNumber(), incomingError.getFailedLineNumber(), incomingError.getTargetCatalogName(), incomingError.getTargetSchemaName(), incomingError.getTargetTableName(), incomingError.getEventType().getCode(), incomingError.getBinaryEncoding().name(), incomingError.getColumnNames(), incomingError.getPrimaryKeyColumnNames(), incomingError.getRowData(), incomingError.getOldData(), incomingError.getCurData(), incomingError.getResolveData(), incomingError.isResolveIgnore() ? 1 : 0, incomingError.getConflictId(), incomingError.getCreateTime(), incomingError.getLastUpdateBy(), incomingError.getLastUpdateTime()}, new int[]{-5, 12, -5, -5, 12, 12, 12, 1, 12, 12, 12, 12, 12, 12, 12, 5, 12, 93, 12, 93});
            }
        }
    }

    @Override
    public void updateIncomingError(IncomingError incomingError) {
        this.sqlTemplate.update(this.getSql("updateIncomingErrorSql"), new Object[]{incomingError.getResolveData(), incomingError.isResolveIgnore() ? 1 : 0, incomingError.getBatchId(), incomingError.getNodeId(), incomingError.getFailedRowNumber()});
    }

    protected void setTransportManager(ITransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public static String filterDataLoaderType(String dataLoaderType) {
        if (dataLoaderType == null) {
            return dataLoaderType;
        }
        if (dataLoaderType.equals("mysql_bulk") || dataLoaderType.equals("mssql_bulk") || dataLoaderType.equals("oracle_bulk") || dataLoaderType.equals("postgres_bulk") || dataLoaderType.equals("redshift_bulk")) {
            dataLoaderType = "bulk";
        }
        return dataLoaderType;
    }

    public static class ConflictNodeGroupLink
    extends Conflict
    implements IModelObject {
        private static final long serialVersionUID = 1L;
        protected NodeGroupLink nodeGroupLink;

        public void setNodeGroupLink(NodeGroupLink nodeGroupLink) {
            this.nodeGroupLink = nodeGroupLink;
        }

        public NodeGroupLink getNodeGroupLink() {
            return this.nodeGroupLink;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getConflictId() == null ? 0 : this.getConflictId().hashCode());
            result = 31 * result + (this.nodeGroupLink == null ? 0 : this.nodeGroupLink.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConflictNodeGroupLink other = (ConflictNodeGroupLink)obj;
            if (this.getConflictId() == null ? other.getConflictId() != null : !this.getConflictId().equals(other.getConflictId())) {
                return false;
            }
            return !(this.nodeGroupLink == null ? other.nodeGroupLink != null : !this.nodeGroupLink.equals(other.nodeGroupLink));
        }
    }

    class LoadIntoDatabaseOnArrivalListener
    implements IProtocolDataWriterListener {
        private ManageIncomingBatchListener listener;
        private long batchStartsToArriveTimeInMs;
        private String sourceNodeId;
        private ProcessInfo transferInfo;
        private ProcessInfo loadInfo;
        private ExecutorService executor;
        private List<Future<IncomingBatch>> futures = new ArrayList<Future<IncomingBatch>>();
        private boolean isError;

        public LoadIntoDatabaseOnArrivalListener(ProcessInfo transferInfo, String sourceNodeId, ManageIncomingBatchListener listener, ExecutorService executor) {
            this.sourceNodeId = sourceNodeId;
            this.listener = listener;
            this.executor = executor;
            this.transferInfo = transferInfo;
        }

        public void start(DataContext ctx, Batch batch) {
            this.batchStartsToArriveTimeInMs = System.currentTimeMillis();
        }

        protected ProtocolDataReader buildDataReader(final Batch batchInStaging, IStagedResource resource) {
            return new ProtocolDataReader(Batch.BatchType.LOAD, batchInStaging.getTargetNodeId(), resource){

                public Table nextTable() {
                    Table table = super.nextTable();
                    if (table != null && ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch != null) {
                        ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch.incrementTableCount(table.getNameLowerCase());
                    }
                    return table;
                }

                public Batch nextBatch() {
                    Batch nextBatch = super.nextBatch();
                    if (nextBatch != null) {
                        nextBatch.setStatistics(batchInStaging.getStatistics());
                    }
                    return nextBatch;
                }
            };
        }

        public void end(final DataContext ctx, final Batch batchInStaging, final IStagedResource resource) {
            final long networkMillis = System.currentTimeMillis() - this.batchStartsToArriveTimeInMs;
            Callable<IncomingBatch> loadBatchFromStage = new Callable<IncomingBatch>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public IncomingBatch call() throws Exception {
                    IncomingBatch incomingBatch = null;
                    DataProcessor processor = null;
                    MDC.put((String)"engineName", (String)DataLoaderService.this.engine.getParameterService().getEngineName());
                    if (!LoadIntoDatabaseOnArrivalListener.this.isError && resource != null && resource.exists()) {
                        try {
                            LoadIntoDatabaseOnArrivalListener.this.loadInfo = DataLoaderService.this.statisticManager.newProcessInfo(new ProcessInfoKey(LoadIntoDatabaseOnArrivalListener.this.transferInfo.getSourceNodeId(), LoadIntoDatabaseOnArrivalListener.this.transferInfo.getQueue(), LoadIntoDatabaseOnArrivalListener.this.transferInfo.getTargetNodeId(), LoadIntoDatabaseOnArrivalListener.this.transferInfo.getProcessType() == ProcessType.PULL_JOB_TRANSFER ? ProcessType.PULL_JOB_LOAD : ProcessType.PUSH_HANDLER_LOAD));
                            LoadIntoDatabaseOnArrivalListener.this.loadInfo.setCurrentLoadId(LoadIntoDatabaseOnArrivalListener.this.transferInfo.getCurrentLoadId());
                            if (batchInStaging.getStatistics() != null) {
                                LoadIntoDatabaseOnArrivalListener.this.loadInfo.setTotalDataCount(batchInStaging.getStatistics().get("DATA_ROW_COUNT"));
                                LoadIntoDatabaseOnArrivalListener.this.loadInfo.setCurrentLoadId(batchInStaging.getStatistics().get("LOAD_ID"));
                            }
                            LoadIntoDatabaseOnArrivalListener.this.loadInfo.setStatus(ProcessInfo.ProcessStatus.LOADING);
                            ProtocolDataReader reader = LoadIntoDatabaseOnArrivalListener.this.buildDataReader(batchInStaging, resource);
                            processor = new DataProcessor((IDataReader)reader, null, LoadIntoDatabaseOnArrivalListener.this.listener, "data load from stage"){

                                protected IDataWriter chooseDataWriter(Batch batch) {
                                    boolean isRetry = ((ManageIncomingBatchListener)this.listener).getCurrentBatch().isRetry();
                                    return DataLoaderService.this.buildDataWriter(LoadIntoDatabaseOnArrivalListener.this.loadInfo, LoadIntoDatabaseOnArrivalListener.this.sourceNodeId, batch.getChannelId(), batch.getBatchId(), isRetry);
                                }
                            };
                            processor.process(ctx);
                            if (LoadIntoDatabaseOnArrivalListener.this.loadInfo.getCurrentBatchCount() != 0L) return incomingBatch;
                            LoadIntoDatabaseOnArrivalListener.this.loadInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                            return incomingBatch;
                        }
                        catch (Exception e) {
                            if (ctx.get("bulkWriterToUse") != null && ctx.get("bulkWriterToUse").equals("bulk")) {
                                DataLoaderService.this.log.debug("Bulk loader failed : ", (Throwable)e);
                                DataLoaderService.this.log.info("Bulk loader failed in class {} with message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                                ctx.put("bulkWriterToUse", (Object)"default");
                                ctx.setLastError(null);
                                ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch.setStatus(AbstractBatch.Status.OK);
                                processor.setDataReader((IDataReader)LoadIntoDatabaseOnArrivalListener.this.buildDataReader(batchInStaging, resource));
                                try {
                                    LoadIntoDatabaseOnArrivalListener.this.listener.getBatchesProcessed().remove(((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch);
                                    processor.process(ctx);
                                    return incomingBatch;
                                }
                                catch (Exception retryException) {
                                    LoadIntoDatabaseOnArrivalListener.this.isError = true;
                                    incomingBatch = ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch;
                                    incomingBatch.setStatus(AbstractBatch.Status.ER);
                                    incomingBatch.setErrorFlag(true);
                                    DataLoaderService.this.incomingBatchService.updateIncomingBatch(incomingBatch);
                                    throw e;
                                }
                            }
                            LoadIntoDatabaseOnArrivalListener.this.isError = true;
                            if (((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch == null || ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch.getSqlCode() != -888) throw e;
                            DataLoaderService.this.log.info("The batch {} may be corrupt in staging, so removing it.", (Object)batchInStaging.getNodeBatchId());
                            resource.delete();
                            incomingBatch = ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch;
                            return incomingBatch;
                        }
                        finally {
                            incomingBatch = ((LoadIntoDatabaseOnArrivalListener)LoadIntoDatabaseOnArrivalListener.this).listener.currentBatch;
                            if (incomingBatch != null) {
                                incomingBatch.setNetworkMillis(networkMillis);
                                if (batchInStaging.isIgnored()) {
                                    incomingBatch.incrementIgnoreCount();
                                }
                            }
                            resource.setState(IStagedResource.State.DONE);
                            if (!resource.isFileResource()) {
                                resource.delete();
                            }
                        }
                    } else {
                        if (resource != null && resource.exists()) return incomingBatch;
                        DataLoaderService.this.log.info("The batch {} was missing in staging.  Setting status to resend.", (Object)batchInStaging.getNodeBatchId());
                        incomingBatch = new IncomingBatch(batchInStaging);
                        incomingBatch.setStatus(AbstractBatch.Status.RS);
                        DataLoaderService.this.incomingBatchService.updateIncomingBatch(incomingBatch);
                    }
                    return incomingBatch;
                }
            };
            if (resource == null) {
                IncomingBatch incomingBatch = new IncomingBatch(batchInStaging);
                this.listener.getBatchesProcessed().add(incomingBatch);
                if (DataLoaderService.this.incomingBatchService.acquireIncomingBatch(incomingBatch)) {
                    DataLoaderService.this.log.info("Unable to retry batch {} because it's not in staging.  Setting status to resend.", (Object)batchInStaging.getNodeBatchId());
                    incomingBatch.setStatus(AbstractBatch.Status.RS);
                    DataLoaderService.this.incomingBatchService.updateIncomingBatch(incomingBatch);
                }
                this.isError = true;
            } else {
                this.futures.add(this.executor.submit(loadBatchFromStage));
            }
        }

        public boolean isDone() throws Throwable {
            boolean isDone = true;
            for (Future<IncomingBatch> future : this.futures) {
                if (future.isDone()) {
                    try {
                        future.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        throw e.getCause() != null ? e.getCause() : e;
                    }
                }
                isDone = false;
            }
            return isDone;
        }
    }

    static class IncomingErrorMapper
    implements ISqlRowMapper<IncomingError> {
        IncomingErrorMapper() {
        }

        public IncomingError mapRow(Row rs) {
            IncomingError incomingError = new IncomingError();
            incomingError.setBatchId(rs.getLong("batch_id"));
            incomingError.setNodeId(rs.getString("node_id"));
            incomingError.setFailedRowNumber(rs.getLong("failed_row_number"));
            incomingError.setFailedLineNumber(rs.getLong("failed_line_number"));
            incomingError.setTargetCatalogName(rs.getString("target_catalog_name"));
            incomingError.setTargetSchemaName(rs.getString("target_schema_name"));
            incomingError.setTargetTableName(rs.getString("target_table_name"));
            incomingError.setEventType(DataEventType.getEventType((String)rs.getString("event_type")));
            incomingError.setBinaryEncoding(BinaryEncoding.valueOf((String)rs.getString("binary_encoding")));
            incomingError.setColumnNames(rs.getString("column_names"));
            incomingError.setPrimaryKeyColumnNames(rs.getString("pk_column_names"));
            incomingError.setRowData(rs.getString("row_data"));
            incomingError.setOldData(rs.getString("old_data"));
            incomingError.setCurData(rs.getString("cur_data"));
            incomingError.setResolveData(rs.getString("resolve_data"));
            incomingError.setResolveIgnore(rs.getBoolean("resolve_ignore"));
            incomingError.setConflictId(rs.getString("conflict_id"));
            incomingError.setCreateTime(rs.getDateTime("create_time"));
            incomingError.setLastUpdateBy(rs.getString("last_update_by"));
            incomingError.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return incomingError;
        }
    }

    class ConflictSettingsNodeGroupLinkMapper
    implements ISqlRowMapper<ConflictNodeGroupLink> {
        ConflictSettingsNodeGroupLinkMapper() {
        }

        public ConflictNodeGroupLink mapRow(Row rs) {
            ConflictNodeGroupLink setting = new ConflictNodeGroupLink();
            setting.setNodeGroupLink(DataLoaderService.this.configurationService.getNodeGroupLinkFor(rs.getString("source_node_group_id"), rs.getString("target_node_group_id"), false));
            setting.setTargetChannelId(StringUtils.trimToNull((String)rs.getString("target_channel_id")));
            setting.setTargetCatalogName(StringUtils.trimToNull((String)rs.getString("target_catalog_name")));
            setting.setTargetSchemaName(StringUtils.trimToNull((String)rs.getString("target_schema_name")));
            setting.setTargetTableName(StringUtils.trimToNull((String)rs.getString("target_table_name")));
            setting.setDetectType(Conflict.DetectConflict.valueOf((String)rs.getString("detect_type").toUpperCase()));
            setting.setResolveType(Conflict.ResolveConflict.valueOf((String)rs.getString("resolve_type").toUpperCase()));
            setting.setPingBack(Conflict.PingBack.valueOf((String)rs.getString("ping_back")));
            setting.setResolveChangesOnly(rs.getBoolean("resolve_changes_only"));
            setting.setResolveRowOnly(rs.getBoolean("resolve_row_only"));
            setting.setDetectExpression(StringUtils.trimToNull((String)rs.getString("detect_expression")));
            setting.setLastUpdateBy(rs.getString("last_update_by"));
            setting.setConflictId(rs.getString("conflict_id"));
            setting.setCreateTime(rs.getDateTime("create_time"));
            setting.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return setting;
        }
    }
}

