/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.ext.ExtensionPointMetaData;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.transform.IColumnTransform;
import org.jumpmind.symmetric.model.Extension;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ExtensionServiceSqlMap;
import org.jumpmind.util.SimpleClassCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionService
extends AbstractService
implements IExtensionService {
    private static final Logger log = LoggerFactory.getLogger(ExtensionService.class);
    protected ISymmetricEngine engine;
    protected SimpleClassCompiler simpleClassCompiler;
    protected Map<Class, Map<String, IExtensionPoint>> staticExtensionsByClassByName = new HashMap<Class, Map<String, IExtensionPoint>>();
    protected Map<Class, Map<String, IExtensionPoint>> extensionsByClassByName;
    protected List<ExtensionPointMetaData> extensionMetaData;

    public ExtensionService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.simpleClassCompiler = new SimpleClassCompiler();
        this.setSqlMap(new ExtensionServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public synchronized void refresh() {
        this.extensionsByClassByName = new HashMap<Class, Map<String, IExtensionPoint>>();
        this.extensionMetaData = new ArrayList<ExtensionPointMetaData>();
        for (Class extensionClass : this.staticExtensionsByClassByName.keySet()) {
            Map<String, IExtensionPoint> byNameMap = this.staticExtensionsByClassByName.get(extensionClass);
            for (String name : byNameMap.keySet()) {
                IExtensionPoint ext = byNameMap.get(name);
                this.getExtensionsByNameMap(extensionClass).put(name, ext);
                this.addExtensionPointMetaData(ext, name, extensionClass, true);
            }
        }
        String prefix = this.parameterService.getString("sync.table.prefix");
        if (this.platform.getTableFromCache(TableConstants.getTableName(prefix, "extension"), false) != null) {
            List extensionList = this.sqlTemplate.query(this.getSql("selectEnabled"), (ISqlRowMapper)new ExtensionRowMapper(), new Object[]{this.parameterService.getNodeGroupId()});
            log.info("Found {} extension points from the database that will be registered", (Object)extensionList.size());
            for (Extension extension : extensionList) {
                this.registerExtension(extension);
            }
        }
    }

    protected void registerExtension(Extension extension) {
        if (extension.getExtensionText() != null) {
            if (extension.getExtensionType().equalsIgnoreCase(Extension.EXTENSION_TYPE_JAVA)) {
                try {
                    Object ext = this.simpleClassCompiler.getCompiledClass(extension.getExtensionText());
                    this.registerExtension(extension.getExtensionId(), (IExtensionPoint)ext);
                }
                catch (Exception e) {
                    log.error("Error while compiling Java extension " + extension.getExtensionId(), (Throwable)e);
                }
            } else if (extension.getExtensionType().equalsIgnoreCase(Extension.EXTENSION_TYPE_BSH)) {
                try {
                    Interpreter interpreter = new Interpreter();
                    interpreter.set("engine", (Object)this.engine);
                    interpreter.set("sqlTemplate", (Object)this.engine.getDatabasePlatform().getSqlTemplate());
                    interpreter.set("log", (Object)log);
                    String globalScript = this.parameterService.getString("bsh.extension.global.script");
                    if (StringUtils.isNotBlank((CharSequence)globalScript)) {
                        interpreter.eval(globalScript);
                    }
                    interpreter.eval(extension.getExtensionText());
                    Object ext = interpreter.getInterface(Class.forName(extension.getInterfaceName()));
                    this.registerExtension(extension.getExtensionId(), (IExtensionPoint)ext);
                }
                catch (EvalError e) {
                    log.error("Error while parsing BSH extension " + extension.getExtensionId(), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error("Interface class not found for BSH extension " + extension.getExtensionId(), (Throwable)e);
                }
                catch (Error e) {
                    log.error("Failed to register BSH extension " + extension.getExtensionId(), (Throwable)e);
                }
            } else {
                log.error("Skipping extension " + extension.getExtensionId() + ", unknown extension type " + extension.getExtensionType());
            }
        }
    }

    protected boolean registerExtension(String name, IExtensionPoint ext) {
        if (!(ext instanceof IExtensionPoint)) {
            log.error("Missing IExtensionPoint interface for extension " + name);
        }
        return this.registerExtension(name, ext, true);
    }

    protected boolean registerExtension(String name, IExtensionPoint ext, boolean shouldLog) {
        boolean installed = false;
        if (this.initializeExtension(ext)) {
            for (Class extensionClass : this.getExtensionClassList(ext)) {
                if (ext instanceof IBuiltInExtensionPoint) {
                    log.debug("Registering built-in extension named '{}' of type '{}'", (Object)name, (Object)extensionClass.getSimpleName());
                } else if (shouldLog) {
                    log.info("Registering extension named '{}' of type '{}'", (Object)name, (Object)extensionClass.getSimpleName());
                }
                installed = true;
                this.addExtensionPointMetaData(ext, name, extensionClass, true);
                this.getExtensionsByNameMap(extensionClass).put(name, ext);
            }
            if (!installed) {
                this.addExtensionPointMetaData(ext, name, null, false);
            }
        }
        return installed;
    }

    protected void unRegisterExtension(String name, IExtensionPoint ext) {
        for (Class extensionClass : this.getExtensionClassList(ext)) {
            this.getExtensionsByNameMap(extensionClass).remove(name);
        }
        Iterator<ExtensionPointMetaData> iterator = this.extensionMetaData.iterator();
        while (iterator.hasNext()) {
            ExtensionPointMetaData metaData = iterator.next();
            if (metaData.getExtensionPoint() != ext || !metaData.getName().equals(name)) continue;
            iterator.remove();
        }
    }

    protected boolean initializeExtension(IExtensionPoint ext) {
        boolean shouldInstall = false;
        if (ext instanceof ISymmetricEngineAware) {
            ((ISymmetricEngineAware)ext).setSymmetricEngine(this.engine);
        }
        if (ext instanceof INodeGroupExtensionPoint) {
            String nodeGroupId = this.parameterService.getNodeGroupId();
            INodeGroupExtensionPoint nodeExt = (INodeGroupExtensionPoint)ext;
            String[] ids = nodeExt.getNodeGroupIdsToApplyTo();
            if (ids != null) {
                for (String targetNodeGroupId : ids) {
                    if (!nodeGroupId.equals(targetNodeGroupId)) continue;
                    shouldInstall = true;
                }
            } else {
                shouldInstall = true;
            }
        } else {
            shouldInstall = true;
        }
        return shouldInstall;
    }

    protected List<Class> getExtensionClassList(IExtensionPoint ext) {
        ArrayList<Class> classList = new ArrayList<Class>();
        List interfaces = ClassUtils.getAllInterfaces(ext.getClass());
        for (Class clazz : interfaces) {
            if (!IExtensionPoint.class.isAssignableFrom(clazz) || clazz.equals(IExtensionPoint.class)) continue;
            classList.add(clazz);
        }
        return classList;
    }

    @Override
    public synchronized List<ExtensionPointMetaData> getExtensionPointMetaData() {
        return new ArrayList<ExtensionPointMetaData>(this.extensionMetaData);
    }

    protected void addExtensionPointMetaData(IExtensionPoint extensionPoint, String name, Class<? extends IExtensionPoint> extensionClass, boolean installed) {
        if (!installed || !extensionClass.equals(IBuiltInExtensionPoint.class) && !extensionClass.equals(IColumnTransform.class)) {
            this.extensionMetaData.add(new ExtensionPointMetaData(extensionPoint, name, extensionClass, installed));
        }
    }

    @Override
    public synchronized <T extends IExtensionPoint> T getExtensionPoint(Class<T> extensionClass) {
        List<T> availableExtensions = this.getExtensionPointList(extensionClass);
        for (IExtensionPoint extension : availableExtensions) {
            if (extension instanceof IBuiltInExtensionPoint) continue;
            return (T)extension;
        }
        Iterator<T> iterator = availableExtensions.iterator();
        if (iterator.hasNext()) {
            IExtensionPoint extension;
            extension = (IExtensionPoint)iterator.next();
            return (T)extension;
        }
        return null;
    }

    @Override
    public synchronized <T extends IExtensionPoint> List<T> getExtensionPointList(Class<T> extensionClass) {
        return new ArrayList<T>(this.getExtensionPointMap(extensionClass).values());
    }

    @Override
    public synchronized <T extends IExtensionPoint> Map<String, T> getExtensionPointMap(Class<T> extensionClass) {
        return this.getExtensionsByNameMap(extensionClass);
    }

    @Override
    public synchronized void addExtensionPoint(IExtensionPoint extension) {
        for (Class extensionClass : this.getExtensionClassList(extension)) {
            this.getStaticExtensionsByNameMap(extensionClass).put(extension.getClass().getCanonicalName(), extension);
        }
        this.registerExtension(extension.getClass().getCanonicalName(), extension, false);
    }

    @Override
    public synchronized void addExtensionPoint(String name, IExtensionPoint extension) {
        for (Class extensionClass : this.getExtensionClassList(extension)) {
            this.getStaticExtensionsByNameMap(extensionClass).put(name, extension);
        }
        this.registerExtension(name, extension, false);
    }

    @Override
    public synchronized void removeExtensionPoint(IExtensionPoint extension) {
        for (Class extensionClass : this.getExtensionClassList(extension)) {
            this.getStaticExtensionsByNameMap(extensionClass).remove(extension.getClass().getCanonicalName());
        }
        this.unRegisterExtension(extension.getClass().getCanonicalName(), extension);
    }

    protected Map<String, IExtensionPoint> getStaticExtensionsByNameMap(Class extensionClass) {
        return this.getExtensionsByNameMap(this.staticExtensionsByClassByName, extensionClass);
    }

    protected Map<String, IExtensionPoint> getExtensionsByNameMap(Class extensionClass) {
        return this.getExtensionsByNameMap(this.extensionsByClassByName, extensionClass);
    }

    protected Map<String, IExtensionPoint> getExtensionsByNameMap(Map<Class, Map<String, IExtensionPoint>> byClassByNameMap, Class extensionClass) {
        Map<String, IExtensionPoint> byNameMap = byClassByNameMap.get(extensionClass);
        if (byNameMap == null) {
            byNameMap = new HashMap<String, IExtensionPoint>();
            byClassByNameMap.put(extensionClass, byNameMap);
        }
        return byNameMap;
    }

    @Override
    public List<Extension> getExtensions() {
        return this.sqlTemplate.query(this.getSql("selectAll"), (ISqlRowMapper)new ExtensionRowMapper(), new Object[0]);
    }

    @Override
    public void saveExtension(Extension extension) {
        if (this.sqlTemplate.update(this.getSql("updateExtensionSql"), new Object[]{extension.getExtensionType(), extension.getInterfaceName(), extension.getNodeGroupId(), extension.isEnabled() ? 1 : 0, extension.getExtensionOrder(), extension.getExtensionText(), extension.getLastUpdateBy(), new Date(), extension.getExtensionId()}) <= 0) {
            this.sqlTemplate.update(this.getSql("insertExtensionSql"), new Object[]{extension.getExtensionType(), extension.getInterfaceName(), extension.getNodeGroupId(), extension.isEnabled() ? 1 : 0, extension.getExtensionOrder(), extension.getExtensionText(), new Date(), extension.getLastUpdateBy(), new Date(), extension.getExtensionId()});
            if (extension.isEnabled()) {
                this.registerExtension(extension);
            }
        } else {
            this.refresh();
        }
    }

    @Override
    public void saveExtensionAsCopy(Extension extension) {
        String newId = extension.getExtensionId();
        List extensions = this.sqlTemplate.query(this.getSql("selectAll", "whereExtensionIdLike"), (ISqlRowMapper)new ExtensionRowMapper(), new Object[]{newId + "%"});
        List ids = extensions.stream().map(Extension::getExtensionId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        extension.setExtensionId(newId + suffix);
        this.saveExtension(extension);
    }

    @Override
    public void renameExtension(String oldId, Extension extension) {
        this.deleteExtension(oldId);
        this.saveExtension(extension);
    }

    @Override
    public void deleteExtension(String extensionId) {
        this.sqlTemplate.update(this.getSql("deleteExtensionSql"), new Object[]{extensionId});
        this.refresh();
    }

    @Override
    public void deleteAllExtensions() {
        this.sqlTemplate.update(this.getSql("deleteAllExtensionsSql"), new Object[0]);
        this.refresh();
    }

    @Override
    public Object getCompiledClass(String javaCode) throws Exception {
        return this.simpleClassCompiler.getCompiledClass(javaCode);
    }

    static class ExtensionRowMapper
    implements ISqlRowMapper<Extension> {
        ExtensionRowMapper() {
        }

        public Extension mapRow(Row row) {
            Extension extension = new Extension();
            extension.setExtensionId(row.getString("extension_id"));
            extension.setExtensionType(row.getString("extension_type"));
            extension.setInterfaceName(row.getString("interface_name"));
            extension.setNodeGroupId(row.getString("node_group_id"));
            extension.setEnabled(row.getBoolean("enabled"));
            extension.setExtensionOrder(row.getInt("extension_order"));
            extension.setExtensionText(row.getString("extension_text"));
            extension.setCreateTime(row.getDateTime("create_time"));
            extension.setLastUpdateBy(row.getString("last_update_by"));
            extension.setLastUpdateTime(row.getDateTime("last_update_time"));
            return extension;
        }
    }
}

