/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Map;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.service.impl.AbstractSqlMap;

public class FileSyncServiceSqlMap
extends AbstractSqlMap {
    public FileSyncServiceSqlMap(IDatabasePlatform platform, Map<String, String> replacementTokens) {
        super(platform, replacementTokens);
        this.putSql("selectFileTriggersSql", " select trigger_id, base_dir, recurse,                                               includes_files, excludes_files,                                              sync_on_create, sync_on_modified, sync_on_delete,                            sync_on_ctl_file, delete_after_sync,                                         before_copy_script,                                                          after_copy_script,                                                           create_time, last_update_by,                                                 last_update_time, channel_id, reload_channel_id                       from $(file_trigger)                                                        ");
        this.putSql("triggerIdWhere", "where trigger_id=?");
        this.putSql("triggerIdWhereLike", "where trigger_id like ?");
        this.putSql("updateFileTriggerSql", " update $(file_trigger) set base_dir=?, recurse=?, includes_files=?,           excludes_files=?, sync_on_create=?, sync_on_modified=?, sync_on_delete=?,    sync_on_ctl_file=?, delete_after_sync=?,                                     before_copy_script=?, after_copy_script=?,                                   last_update_by=?, last_update_time=?, channel_id=?, reload_channel_id=?    where trigger_id=?                                                           ");
        this.putSql("insertFileTriggerSql", " insert into $(file_trigger) (base_dir, recurse, includes_files,               excludes_files, sync_on_create, sync_on_modified, sync_on_delete,            sync_on_ctl_file, delete_after_sync,                                         before_copy_script, after_copy_script,                                       last_update_by, last_update_time, trigger_id, create_time,                 channel_id, reload_channel_id)                                                values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)                                   ");
        this.putSql("selectFileSnapshotSql", " select trigger_id, router_id, channel_id, reload_channel_id, relative_dir, file_name,  last_event_type, crc32_checksum,   file_size, file_modified_time, create_time, last_update_time, last_update_by         from $(file_snapshot) where trigger_id=? and router_id=?                             ");
        this.putSql("relativeDirWhere", "and relative_dir=?");
        this.putSql("updateFileSnapshotSql", " update $(file_snapshot) set     last_event_type=?, crc32_checksum=?,                                   file_size=?, file_modified_time=?, last_update_time=?,                 last_update_by=?, channel_id=?, reload_channel_id=?                   where                                                                   trigger_id=? and router_id=? and relative_dir=? and file_name=?         ");
        this.putSql("updateFileIncoming", " update $(file_incoming) set                                                     node_id=?,                                                             file_modified_time=?,                                                  last_event_type=?                                                     where                                                                   relative_dir=? and file_name=?                                          ");
        this.putSql("insertFileIncoming", " insert into $(file_incoming) (node_id, file_modified_time, last_event_type, relative_dir, file_name)    values(?,?,?,?,?)                                                                             ");
        this.putSql("deleteFileIncoming", " delete from $(file_incoming)");
        this.putSql("findNodeIdFromFileIncoming", " select node_id from $(file_incoming) where relative_dir=? and file_name=? and file_modified_time=?");
        this.putSql("deleteFileSnapshotSql", " delete from $(file_snapshot)                                                   where                                                                   trigger_id=? and router_id=? and relative_dir=? and file_name=?         ");
        this.putSql("insertFileSnapshotSql", " insert into $(file_snapshot) (                                                  last_event_type, crc32_checksum,                                               file_size, file_modified_time, create_time, last_update_time,                  last_update_by, channel_id, reload_channel_id, trigger_id, router_id, relative_dir, file_name    ) values(?,?,?,?,?,?,?,?,?,?,?,?,?)                                                 ");
        this.putSql("selectFileTriggerRoutersSql", " select                                                                          tr.trigger_id as trigger_id, tr.router_id as router_id, enabled,               initial_load_enabled, target_base_dir,                                         conflict_strategy, tr.create_time as create_time,                              tr.last_update_by as last_update_by, tr.last_update_time as last_update_time  from $(file_trigger_router) tr                                                ");
        this.putSql("whereTriggerRouterId", "where trigger_id=? and router_id=?");
        this.putSql("whereTriggerId", "where trigger_id=?");
        this.putSql("fileTriggerRoutersForCurrentNodeWhere", "  inner join $(router) r on   tr.router_id=r.router_id  where r.source_node_group_id=?");
        this.putSql("updateFileTriggerRouterSql", " update $(file_trigger_router) set                                               enabled=?, initial_load_enabled=?, target_base_dir=?,                  conflict_strategy=?, last_update_by=?, last_update_time=?             where trigger_id=? and router_id=?                                            ");
        this.putSql("insertFileTriggerRouterSql", " insert into $(file_trigger_router) (                                            enabled, initial_load_enabled, target_base_dir,                        conflict_strategy, create_time, last_update_by,                        last_update_time, trigger_id, router_id                               ) values(?,?,?,?,?,?,?,?,?)                                                   ");
        this.putSql("deleteFileTriggerRouterSql", "delete from $(file_trigger_router) where trigger_id=? and router_id=? ");
        this.putSql("deleteAllFileTriggerRoutersSql", "delete from $(file_trigger_router)");
        this.putSql("deleteFileTriggerSql", "delete from $(file_trigger) where trigger_id=?   ");
        this.putSql("deleteAllFileTriggersSql", "delete from $(file_trigger)");
        this.putSql("selectMaxFileTriggerLastUpdateTime", "select max(last_update_time) from $(file_trigger) where last_update_time is not null");
        this.putSql("selectMaxRouterLastUpdateTime", "select max(last_update_time) from $(router) where last_update_time is not null");
        this.putSql("selectMaxFileTriggerRouterLastUpdateTime", "select max(last_update_time) from $(file_trigger_router) where last_update_time is not null");
        this.putSql("updateFileTriggerIdSql", "update $(file_trigger_router) set trigger_id=? where trigger_id=?");
    }
}

