/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.service.IMailService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;

public class MailService
extends AbstractService
implements IMailService {
    protected ISecurityService securityService;
    protected static final String JAVAMAIL_HOST_NAME = "mail.host";
    protected static final String JAVAMAIL_TRANSPORT = "mail.transport";
    protected static final String JAVAMAIL_PORT_NUMBER = "mail.smtp.port";
    protected static final String JAVAMAIL_PORT_NUMBER_SSL = "mail.smtps.port";
    protected static final String JAVAMAIL_FROM = "mail.from";
    protected static final String JAVAMAIL_USE_STARTTLS = "mail.smtp.starttls.enable";
    protected static final String JAVAMAIL_USE_AUTH = "mail.smtp.auth";
    protected static final String JAVAMAIL_TRUST_HOST = "mail.smtp.ssl.trust";
    protected static final String JAVAMAIL_TRUST_HOST_SSL = "mail.smtps.ssl.trust";
    protected static final String JAVAMAIL_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    protected static final String JAVAMAIL_SSL_PROTOCOLS = "mail.smtp.ssl.protocols";

    public MailService(IParameterService parameterService, ISecurityService securityService, ISymmetricDialect symmetricDialect) {
        super(parameterService, symmetricDialect);
        this.securityService = securityService;
    }

    @Override
    public String sendEmail(String subject, String text, String toRecipients) {
        return this.sendEmail(subject, text, toRecipients, null, null);
    }

    public String sendEmail(String subject, String text, String toRecipients, String ccRecipients, String bccRecipients) {
        String password = this.decryptPassword(this.parameterService.getString("smtp.password"));
        return this.sendEmail(subject, text, toRecipients, ccRecipients, bccRecipients, this.getJavaMailProperties(), this.parameterService.getString("smtp.transport", "smtp"), this.parameterService.is("smtp.auth", false), this.parameterService.getString("smtp.user"), password);
    }

    @Override
    public String sendEmail(String subject, String text, String toRecipients, TypedProperties prop) {
        return this.sendEmail(subject, text, toRecipients, null, null, prop);
    }

    public String sendEmail(String subject, String text, String toRecipients, String ccRecipients, String bccRecipients, TypedProperties prop) {
        return this.sendEmail(subject, text, toRecipients, ccRecipients, bccRecipients, this.getJavaMailProperties(prop), prop.get("smtp.transport", "smtp"), prop.is("smtp.auth", false), prop.get("smtp.user"), this.decryptPassword(prop.get("smtp.password")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendEmail(String subject, String text, String toRecipients, String ccRecipients, String bccRecipients, Properties prop, String transportType, boolean useAuth, String user, String password) {
        Transport transport;
        Session session = Session.getInstance((Properties)prop);
        ByteArrayOutputStream ba = null;
        if (this.log.isDebugEnabled()) {
            session.setDebug(true);
            ba = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(ba);
            session.setDebugOut(ps);
        }
        try {
            transport = session.getTransport(transportType);
        }
        catch (NoSuchProviderException e) {
            this.log.error("Failure while obtaining transport", (Throwable)e);
            return this.getNestedErrorMessage((Exception)((Object)e));
        }
        try {
            if (useAuth) {
                transport.connect(user, this.decryptPassword(password));
            } else {
                transport.connect();
            }
        }
        catch (MessagingException e) {
            this.log.error("Failure while connecting to transport", (Throwable)e);
            return this.getNestedErrorMessage((Exception)((Object)e));
        }
        try {
            MimeMessage message = new MimeMessage(session);
            message.setSentDate(new Date());
            if (StringUtils.isNotEmpty((CharSequence)toRecipients)) {
                message.setRecipients(Message.RecipientType.TO, toRecipients);
            }
            if (StringUtils.isNotEmpty((CharSequence)ccRecipients)) {
                message.setRecipients(Message.RecipientType.CC, ccRecipients);
            }
            if (StringUtils.isNotEmpty((CharSequence)bccRecipients)) {
                message.setRecipients(Message.RecipientType.BCC, bccRecipients);
            }
            message.setSubject(subject);
            message.setText(text);
            message.setFrom((Address)new InternetAddress(prop.getProperty(JAVAMAIL_FROM)));
            try {
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            catch (MessagingException e) {
                this.log.error("Failure while sending notification", (Throwable)e);
                String string = this.getNestedErrorMessage((Exception)((Object)e));
                try {
                    transport.close();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                return string;
            }
        }
        catch (MessagingException e) {
            this.log.error("Failure while preparing notification", (Throwable)e);
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                transport.close();
            }
            catch (MessagingException messagingException) {}
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(ba.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testTransport(TypedProperties prop) {
        String error = null;
        Transport transport = null;
        try {
            this.log.debug("SMTP parameters: {}", (Object)prop);
            Properties javaMailProps = this.getJavaMailProperties(prop);
            this.log.debug("JavaMail properties: {}", (Object)javaMailProps);
            Session session = Session.getInstance((Properties)javaMailProps);
            transport = session.getTransport(prop.get("smtp.transport", "smtp"));
            if (prop.is("smtp.auth", false)) {
                transport.connect(prop.get("smtp.user"), this.decryptPassword(prop.get("smtp.password")));
            } else {
                transport.connect();
            }
        }
        catch (NoSuchProviderException e) {
            error = this.getNestedErrorMessage((Exception)((Object)e));
            this.log.warn("Test of mail service failed:", (Throwable)e);
        }
        catch (MessagingException e) {
            error = this.getNestedErrorMessage((Exception)((Object)e));
            this.log.warn("Test of mail service failed:", (Throwable)e);
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (MessagingException e) {}
        }
        return error;
    }

    protected String getNestedErrorMessage(Exception e) {
        String error = e.getMessage();
        Throwable e2 = e.getCause();
        if (e2 != null) {
            error = error + "\n" + e2.getMessage();
            Throwable e3 = e2.getCause();
            if (e3 != null) {
                error = error + "\n" + e3.getMessage();
            }
        }
        return error;
    }

    protected Properties getJavaMailProperties() {
        Properties prop = new Properties();
        prop.setProperty(JAVAMAIL_HOST_NAME, this.parameterService.getString("smtp.host", "localhost"));
        prop.setProperty(JAVAMAIL_PORT_NUMBER, this.parameterService.getString("smtp.port", "25"));
        prop.setProperty(JAVAMAIL_PORT_NUMBER_SSL, this.parameterService.getString("smtp.port", "25"));
        prop.setProperty(JAVAMAIL_FROM, this.parameterService.getString("smtp.from", "root@localhost"));
        prop.setProperty(JAVAMAIL_USE_STARTTLS, this.parameterService.getString("smtp.starttls", "false"));
        prop.setProperty(JAVAMAIL_USE_AUTH, this.parameterService.getString("smtp.auth", "false"));
        prop.setProperty(JAVAMAIL_TRUST_HOST, this.parameterService.is("smtp.allow.untrusted.cert", false) ? "*" : "");
        prop.setProperty(JAVAMAIL_TRUST_HOST_SSL, this.parameterService.is("smtp.allow.untrusted.cert", false) ? "*" : "");
        prop.setProperty(JAVAMAIL_USE_AUTH, this.parameterService.getString("smtp.auth", "false"));
        if (StringUtils.isNotBlank((CharSequence)this.parameterService.getString("smtp.socket.factory.class"))) {
            prop.setProperty(JAVAMAIL_SOCKET_FACTORY_CLASS, this.parameterService.getString("smtp.socket.factory.class"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.parameterService.getString("smtp.ssl.protocols"))) {
            prop.setProperty(JAVAMAIL_SSL_PROTOCOLS, this.parameterService.getString("smtp.ssl.protocols"));
        }
        return prop;
    }

    protected Properties getJavaMailProperties(TypedProperties typedProp) {
        Properties prop = new Properties();
        prop.setProperty(JAVAMAIL_HOST_NAME, typedProp.get("smtp.host", "localhost"));
        prop.setProperty(JAVAMAIL_PORT_NUMBER, typedProp.get("smtp.port", "25"));
        prop.setProperty(JAVAMAIL_PORT_NUMBER_SSL, typedProp.get("smtp.port", "25"));
        prop.setProperty(JAVAMAIL_FROM, typedProp.get("smtp.from", "root@localhost"));
        prop.setProperty(JAVAMAIL_USE_STARTTLS, String.valueOf(typedProp.is("smtp.starttls", false)));
        prop.setProperty(JAVAMAIL_USE_AUTH, String.valueOf(typedProp.is("smtp.auth", false)));
        prop.setProperty(JAVAMAIL_TRUST_HOST, typedProp.is("smtp.allow.untrusted.cert", false) ? "*" : "");
        prop.setProperty(JAVAMAIL_TRUST_HOST_SSL, typedProp.is("smtp.allow.untrusted.cert", false) ? "*" : "");
        if (StringUtils.isNotBlank((CharSequence)typedProp.get("smtp.socket.factory.class"))) {
            prop.setProperty(JAVAMAIL_SOCKET_FACTORY_CLASS, typedProp.get("smtp.socket.factory.class"));
        }
        if (StringUtils.isNotBlank((CharSequence)typedProp.get("smtp.ssl.protocols"))) {
            prop.setProperty(JAVAMAIL_SSL_PROTOCOLS, typedProp.get("smtp.socket.factory.class"));
        }
        return prop;
    }

    protected String decryptPassword(String password) {
        if (password != null && password.startsWith("enc:")) {
            try {
                return this.securityService.decrypt(password.substring("enc:".length()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decrypt the mail server password.  Please re-enter the password on the Configure -> Mail Server screen", e);
            }
        }
        return password;
    }
}

