/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Notification;
import org.jumpmind.symmetric.monitor.IMonitorType;
import org.jumpmind.symmetric.monitor.MonitorTypeBatchError;
import org.jumpmind.symmetric.monitor.MonitorTypeBatchUnsent;
import org.jumpmind.symmetric.monitor.MonitorTypeBlock;
import org.jumpmind.symmetric.monitor.MonitorTypeCpu;
import org.jumpmind.symmetric.monitor.MonitorTypeDataGap;
import org.jumpmind.symmetric.monitor.MonitorTypeDisk;
import org.jumpmind.symmetric.monitor.MonitorTypeFileHandles;
import org.jumpmind.symmetric.monitor.MonitorTypeJob;
import org.jumpmind.symmetric.monitor.MonitorTypeLoadAverage;
import org.jumpmind.symmetric.monitor.MonitorTypeLog;
import org.jumpmind.symmetric.monitor.MonitorTypeMemory;
import org.jumpmind.symmetric.monitor.MonitorTypeOfflineNodes;
import org.jumpmind.symmetric.monitor.MonitorTypeUnrouted;
import org.jumpmind.symmetric.notification.INotificationType;
import org.jumpmind.symmetric.notification.NotificationTypeEmail;
import org.jumpmind.symmetric.notification.NotificationTypeLog;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IMonitorService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.MonitorServiceSqlMap;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.LogSummary;

public class MonitorService
extends AbstractService
implements IMonitorService {
    protected String hostName;
    protected INodeService nodeService;
    protected IExtensionService extensionService;
    protected IClusterService clusterService;
    protected IContextService contextService;
    protected Map<String, Long> checkTimesByType = new HashMap<String, Long>();
    protected Map<String, List<Long>> averagesByType = new HashMap<String, List<Long>>();
    protected String typeColumnName;
    private ICacheManager cacheManager;

    public MonitorService(ISymmetricEngine engine, ISymmetricDialect symmetricDialect) {
        super(engine.getParameterService(), symmetricDialect);
        INotificationType[] notificationExtensions;
        IMonitorType[] monitorExtensions;
        MonitorServiceSqlMap sqlMap = new MonitorServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens());
        this.typeColumnName = sqlMap.getTypeColumnName();
        this.setSqlMap(sqlMap);
        this.nodeService = engine.getNodeService();
        this.extensionService = engine.getExtensionService();
        this.clusterService = engine.getClusterService();
        this.contextService = engine.getContextService();
        this.cacheManager = engine.getCacheManager();
        this.hostName = StringUtils.left((String)AppUtils.getHostName(), (int)60);
        for (IMonitorType ext : monitorExtensions = new IMonitorType[]{new MonitorTypeBatchError(), new MonitorTypeBatchUnsent(), new MonitorTypeCpu(), new MonitorTypeDataGap(), new MonitorTypeDisk(), new MonitorTypeMemory(), new MonitorTypeUnrouted(), new MonitorTypeLog(), new MonitorTypeOfflineNodes(), new MonitorTypeBlock(), new MonitorTypeLoadAverage(), new MonitorTypeFileHandles(), new MonitorTypeJob()}) {
            this.extensionService.addExtensionPoint(ext.getName(), ext);
        }
        for (INotificationType ext : notificationExtensions = new INotificationType[]{new NotificationTypeLog(), new NotificationTypeEmail()}) {
            this.extensionService.addExtensionPoint(ext.getName(), ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update() {
        Map<String, IMonitorType> monitorTypes = this.extensionService.getExtensionPointMap(IMonitorType.class);
        Node identity = this.nodeService.findIdentity();
        if (identity != null) {
            List<Monitor> activeMonitors = this.getActiveMonitorsForNode(identity.getNodeGroupId(), identity.getExternalId());
            Map<String, MonitorEvent> unresolved = this.getMonitorEventsNotResolvedForNode(identity.getNodeId());
            for (Monitor monitor : activeMonitors) {
                IMonitorType monitorType = monitorTypes.get(monitor.getType());
                if (monitorType != null) {
                    long lastCheckTime;
                    if (monitorType.requiresClusterLock()) continue;
                    Long lastCheckTimeLong = this.checkTimesByType.get(monitor.getMonitorId());
                    long l = lastCheckTime = lastCheckTimeLong != null ? lastCheckTimeLong : 0L;
                    if (lastCheckTime != 0L && (System.currentTimeMillis() - lastCheckTime) / 1000L < (long)monitor.getRunPeriod()) continue;
                    this.checkTimesByType.put(monitor.getMonitorId(), System.currentTimeMillis());
                    this.updateMonitor(monitor, monitorType, identity, unresolved);
                    continue;
                }
                this.log.warn("Could not find monitor of type '" + monitor.getType() + "'");
            }
            if (this.clusterService.lock("Monitor")) {
                try {
                    Gson gson = new Gson();
                    Type mapType = new TypeToken<Map<String, Long>>(){}.getType();
                    String json = this.contextService.getString("monitor.last.check.times");
                    Map<String, Long> clusteredCheckTimesByType = new HashMap();
                    if (json != null && json.length() > 0) {
                        clusteredCheckTimesByType = (Map)gson.fromJson(json, mapType);
                    }
                    for (Monitor monitor : activeMonitors) {
                        long lastCheckTime;
                        IMonitorType monitorType = monitorTypes.get(monitor.getType());
                        if (monitorType == null || !monitorType.requiresClusterLock()) continue;
                        Long lastCheckTimeLong = (Long)clusteredCheckTimesByType.get(monitor.getMonitorId());
                        long l = lastCheckTime = lastCheckTimeLong != null ? lastCheckTimeLong : 0L;
                        if (lastCheckTime != 0L && (System.currentTimeMillis() - lastCheckTime) / 1000L < (long)monitor.getRunPeriod()) continue;
                        clusteredCheckTimesByType.put(monitor.getMonitorId(), System.currentTimeMillis());
                        this.updateMonitor(monitor, monitorType, identity, unresolved);
                    }
                    json = gson.toJson(clusteredCheckTimesByType, mapType);
                    this.contextService.save("monitor.last.check.times", json);
                    int minSeverityLevel = Integer.MAX_VALUE;
                    List<Notification> notifications = this.getActiveNotificationsForNode(identity.getNodeGroupId(), identity.getExternalId());
                    if (notifications.size() > 0) {
                        for (Notification notification : notifications) {
                            if (notification.getSeverityLevel() >= minSeverityLevel) continue;
                            minSeverityLevel = notification.getSeverityLevel();
                        }
                        Map<String, INotificationType> notificationTypes = this.extensionService.getExtensionPointMap(INotificationType.class);
                        List<MonitorEvent> allMonitorEvents = this.getMonitorEventsForNotification(minSeverityLevel);
                        for (Notification notification : notifications) {
                            ArrayList<MonitorEvent> monitorEvents = new ArrayList<MonitorEvent>();
                            for (MonitorEvent monitorEvent : allMonitorEvents) {
                                if (monitorEvent.getSeverityLevel() < notification.getSeverityLevel()) continue;
                                monitorEvents.add(monitorEvent);
                            }
                            if (monitorEvents.size() <= 0) continue;
                            INotificationType notificationType = notificationTypes.get(notification.getType());
                            if (notificationType != null) {
                                notificationType.notify(notification, monitorEvents);
                                this.updateMonitorEventAsNotified(monitorEvents);
                                continue;
                            }
                            this.log.warn("Could not find notification of type '" + notification.getType() + "'");
                        }
                    }
                }
                finally {
                    this.clusterService.unlock("Monitor");
                }
            }
        }
    }

    protected void updateMonitor(Monitor monitor, IMonitorType monitorType, Node identity, Map<String, MonitorEvent> unresolved) {
        MonitorEvent eventValue = monitorType.check(monitor);
        boolean readyToCompare = true;
        if (!monitorType.requiresClusterLock() && monitor.getRunCount() > 0) {
            List<Long> averages = this.averagesByType.get(monitor.getType());
            if (averages == null) {
                averages = new ArrayList<Long>();
                this.averagesByType.put(monitor.getType(), averages);
            }
            averages.add(eventValue.getValue());
            while (averages.size() > monitor.getRunCount()) {
                averages.remove(0);
            }
            if (averages.size() == monitor.getRunCount()) {
                long accumValue = 0L;
                for (Long oneValue : averages) {
                    accumValue += oneValue.longValue();
                }
                eventValue.setValue(accumValue / (long)monitor.getRunCount());
            } else {
                readyToCompare = false;
            }
        }
        if (readyToCompare) {
            MonitorEvent event = unresolved.get(monitor.getMonitorId());
            Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
            if (event != null && eventValue.getValue() < monitor.getThreshold()) {
                event.setLastUpdateTime(now);
                this.updateMonitorEventAsResolved(event);
            } else if (eventValue.getValue() >= monitor.getThreshold()) {
                if (event == null) {
                    if (monitor.getType().equals("log") && this.isLogMonitorEventResolved(monitor, eventValue, identity.getNodeId())) {
                        return;
                    }
                    event = new MonitorEvent();
                    event.setMonitorId(monitor.getMonitorId());
                    event.setNodeId(identity.getNodeId());
                    event.setEventTime(now);
                    event.setHostName(this.hostName);
                    event.setType(monitor.getType());
                    event.setValue(eventValue.getValue());
                    if (eventValue.getCount() == 0) {
                        event.setCount(1);
                    } else {
                        event.setCount(eventValue.getCount());
                    }
                    event.setThreshold(monitor.getThreshold());
                    event.setSeverityLevel(monitor.getSeverityLevel());
                    event.setLastUpdateTime(now);
                    event.setDetails(eventValue.getDetails());
                } else {
                    event.setHostName(this.hostName);
                    event.setType(monitor.getType());
                    if (monitor.getType().equals("batchError") && monitor.getExpression() != null && monitor.getExpression().equals("notifyOnIncrease=true") && eventValue.getValue() > event.getValue()) {
                        event.setNotified(false);
                    }
                    event.setValue(eventValue.getValue());
                    if (eventValue.getCount() == 0) {
                        event.setCount(event.getCount() + 1);
                    } else {
                        event.setCount(eventValue.getCount());
                    }
                    event.setThreshold(monitor.getThreshold());
                    event.setSeverityLevel(monitor.getSeverityLevel());
                    event.setLastUpdateTime(now);
                    event.setDetails(eventValue.getDetails());
                }
                this.saveMonitorEvent(event);
            }
        }
    }

    private boolean isLogMonitorEventResolved(Monitor monitor, MonitorEvent eventValue, String nodeId) {
        List eventLogSummaries = (List)new Gson().fromJson(eventValue.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
        if (eventLogSummaries == null) {
            return false;
        }
        List<MonitorEvent> resolvedEvents = this.getMonitorEventsResolvedForNode(monitor.getMonitorId(), nodeId);
        for (LogSummary eventLogSummary : eventLogSummaries) {
            boolean logMessageResolved = false;
            for (MonitorEvent resolvedEvent : resolvedEvents) {
                if (resolvedEvent.getLastUpdateTime() == null || eventLogSummary.getMostRecentTime() > resolvedEvent.getLastUpdateTime().getTime()) continue;
                List resolvedLogSummaries = (List)new Gson().fromJson(resolvedEvent.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
                for (LogSummary resolvedLogSummary : resolvedLogSummaries) {
                    if (eventLogSummary.getMessage() == null || !eventLogSummary.getMessage().equals(resolvedLogSummary.getMessage())) continue;
                    logMessageResolved = true;
                    break;
                }
                if (!logMessageResolved) continue;
                break;
            }
            if (logMessageResolved) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Monitor> getMonitors() {
        return this.sqlTemplate.query(this.getSql("selectMonitorSql"), (ISqlRowMapper)new MonitorRowMapper(), new Object[0]);
    }

    @Override
    public List<Monitor> getActiveMonitorsForNode(String nodeGroupId, String externalId) {
        return this.cacheManager.getActiveMonitorsForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Monitor> getActiveMonitorsForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql("selectMonitorSql", "whereMonitorByNodeSql"), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public List<Monitor> getActiveMonitorsUnresolvedForNode(String nodeGroupId, String externalId) {
        return this.cacheManager.getActiveMonitorsUnresolvedForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Monitor> getActiveMonitorsUnresolvedForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql("selectMonitorWhereNotResolved"), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public void deleteMonitor(String monitorId) {
        this.sqlTemplate.update(this.getSql("deleteMonitorSql"), new Object[]{monitorId});
    }

    @Override
    public void saveMonitor(Monitor monitor) {
        int count = this.sqlTemplate.update(this.getSql("updateMonitorSql"), new Object[]{monitor.getExternalId(), monitor.getNodeGroupId(), monitor.getType(), monitor.getExpression(), monitor.isEnabled() ? 1 : 0, monitor.getThreshold(), monitor.getRunPeriod(), monitor.getRunCount(), monitor.getSeverityLevel(), monitor.getLastUpdateBy(), monitor.getLastUpdateTime(), monitor.getMonitorId()});
        if (count == 0) {
            this.sqlTemplate.update(this.getSql("insertMonitorSql"), new Object[]{monitor.getMonitorId(), monitor.getExternalId(), monitor.getNodeGroupId(), monitor.getType(), monitor.getExpression(), monitor.isEnabled() ? 1 : 0, monitor.getThreshold(), monitor.getRunPeriod(), monitor.getRunCount(), monitor.getSeverityLevel(), monitor.getCreateTime(), monitor.getLastUpdateBy(), monitor.getLastUpdateTime()});
        }
    }

    @Override
    public void saveMonitorAsCopy(Monitor monitor) {
        String newId = monitor.getMonitorId();
        List monitors = this.sqlTemplate.query(this.getSql("selectMonitorSql", "whereMonitorIdLikeSql"), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{newId + "%"});
        List ids = monitors.stream().map(Monitor::getMonitorId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        monitor.setMonitorId(newId + suffix);
        this.saveMonitor(monitor);
    }

    @Override
    public void renameMonitor(String oldId, Monitor monitor) {
        this.deleteMonitor(oldId);
        this.saveMonitor(monitor);
    }

    @Override
    public List<MonitorEvent> getMonitorEvents() {
        return this.sqlTemplateDirty.query(this.getSql("selectMonitorEventSql"), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[0]);
    }

    protected List<MonitorEvent> getMonitorEventsResolvedForNode(String monitorId, String nodeId) {
        return this.sqlTemplateDirty.query(this.getSql("selectMonitorEventSql", "whereMonitorEventResolvedSql"), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{monitorId, nodeId});
    }

    protected Map<String, MonitorEvent> getMonitorEventsNotResolvedForNode(String nodeId) {
        List list = this.sqlTemplateDirty.query(this.getSql("selectMonitorEventSql", "whereMonitorEventNotResolvedSql"), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{nodeId});
        HashMap<String, MonitorEvent> map = new HashMap<String, MonitorEvent>();
        for (MonitorEvent monitorEvent : list) {
            map.put(monitorEvent.getMonitorId(), monitorEvent);
        }
        return map;
    }

    @Override
    public List<MonitorEvent> getMonitorEventsFiltered(int limit, String type, int severityLevel, String nodeId, Boolean isResolved) {
        String sql = this.getSql("selectMonitorEventSql", "whereMonitorEventFilteredSql");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(severityLevel);
        if (isResolved != null) {
            sql = sql + " and is_resolved = ?";
            args.add(isResolved != false ? 1 : 0);
        }
        if (type != null) {
            sql = sql + " and " + this.typeColumnName + " = ?";
            args.add(type);
        }
        if (nodeId != null) {
            sql = sql + " and node_id = ?";
            args.add(nodeId);
        }
        sql = sql + " order by event_time desc";
        return this.sqlTemplateDirty.query(sql, limit, (ISqlRowMapper)new MonitorEventRowMapper(), args.toArray());
    }

    @Override
    public List<MonitorEvent> getMonitorEventsByMonitorId(String monitorId) {
        String sql = this.getSql("selectMonitorEventSql", "whereMonitorEventIdSql");
        ArrayList args = new ArrayList();
        sql = sql + " order by event_time desc";
        return this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{monitorId});
    }

    protected List<MonitorEvent> getMonitorEventsForNotification(int severityLevel) {
        return this.sqlTemplateDirty.query(this.getSql("selectMonitorEventSql", "whereMonitorEventForNotificationBySeveritySql"), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{severityLevel});
    }

    @Override
    public void saveMonitorEvent(MonitorEvent event) {
        if (!this.updateMonitorEvent(event)) {
            this.insertMonitorEvent(event);
        }
    }

    protected void insertMonitorEvent(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql("insertMonitorEventSql"), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime(), event.getHostName(), event.getType(), event.getValue(), event.getCount(), event.getThreshold(), event.getSeverityLevel(), event.isResolved() ? 1 : 0, event.isNotified() ? 1 : 0, event.getDetails(), event.getLastUpdateTime()});
    }

    protected boolean updateMonitorEvent(MonitorEvent event) {
        int count = this.sqlTemplate.update(this.getSql("updateMonitorEventSql"), new Object[]{event.getHostName(), event.getType(), event.getValue(), event.getCount(), event.getThreshold(), event.getSeverityLevel(), event.isNotified() ? 1 : 0, event.getLastUpdateTime(), event.getDetails(), event.getMonitorId(), event.getNodeId(), event.getEventTime()});
        return count != 0;
    }

    @Override
    public void deleteMonitorEvent(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql("deleteMonitorEventSql"), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    protected void updateMonitorEventAsNotified(List<MonitorEvent> events) {
        for (MonitorEvent event : events) {
            this.updateMonitorEventAsNotified(event);
        }
    }

    protected void updateMonitorEventAsNotified(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql("updateMonitorEventNotifiedSql"), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    @Override
    public void updateMonitorEventAsResolved(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql("updateMonitorEventResolvedSql"), new Object[]{event.getLastUpdateTime(), event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    @Override
    public List<Notification> getNotifications() {
        return this.sqlTemplate.query(this.getSql("selectNotificationSql"), (ISqlRowMapper)new NotificationRowMapper(), new Object[0]);
    }

    @Override
    public List<Notification> getActiveNotificationsForNode(String nodeGroupId, String externalId) {
        return this.cacheManager.getActiveNotificationsForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Notification> getActiveNotificationsForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql("selectNotificationSql", "whereNotificationByNodeSql"), (ISqlRowMapper)new NotificationRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public void saveNotification(Notification notification) {
        int count = this.sqlTemplate.update(this.getSql("updateNotificationSql"), new Object[]{notification.getNodeGroupId(), notification.getExternalId(), notification.getSeverityLevel(), notification.getType(), notification.getExpression(), notification.isEnabled() ? 1 : 0, notification.getCreateTime(), notification.getLastUpdateBy(), notification.getLastUpdateTime(), notification.getNotificationId()});
        if (count == 0) {
            this.sqlTemplate.update(this.getSql("insertNotificationSql"), new Object[]{notification.getNotificationId(), notification.getNodeGroupId(), notification.getExternalId(), notification.getSeverityLevel(), notification.getType(), notification.getExpression(), notification.isEnabled() ? 1 : 0, notification.getCreateTime(), notification.getLastUpdateBy(), notification.getLastUpdateTime()});
        }
    }

    @Override
    public void saveNotificationAsCopy(Notification notification) {
        String newId = notification.getNotificationId();
        List notifications = this.sqlTemplate.query(this.getSql("selectNotificationSql", "whereNotificationIdLikeSql"), (ISqlRowMapper)new NotificationRowMapper(), new Object[]{newId + "%"});
        List ids = notifications.stream().map(Notification::getNotificationId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        notification.setNotificationId(newId + suffix);
        this.saveNotification(notification);
    }

    @Override
    public void renameNotification(String oldId, Notification notification) {
        this.deleteNotification(oldId);
        this.saveNotification(notification);
    }

    @Override
    public void deleteNotification(String notificationId) {
        this.sqlTemplate.update(this.getSql("deleteNotificationSql"), new Object[]{notificationId});
    }

    @Override
    public void flushMonitorCache() {
        this.cacheManager.flushMonitorCache();
    }

    @Override
    public void flushNotificationCache() {
        this.cacheManager.flushNotificationCache();
    }

    static class NotificationRowMapper
    implements ISqlRowMapper<Notification> {
        NotificationRowMapper() {
        }

        public Notification mapRow(Row row) {
            Notification n = new Notification();
            n.setNotificationId(row.getString("notification_id"));
            n.setNodeGroupId(row.getString("node_group_id"));
            n.setExternalId(row.getString("external_id"));
            n.setSeverityLevel(row.getInt("severity_level"));
            n.setType(row.getString("type"));
            n.setExpression(row.getString("expression"));
            n.setEnabled(row.getBoolean("enabled"));
            n.setCreateTime(row.getDateTime("create_time"));
            n.setLastUpdateBy(row.getString("last_update_by"));
            n.setLastUpdateTime(row.getDateTime("last_update_time"));
            return n;
        }
    }

    public static class MonitorEventRowMapper
    implements ISqlRowMapper<MonitorEvent> {
        public MonitorEvent mapRow(Row row) {
            MonitorEvent m = new MonitorEvent();
            m.setMonitorId(row.getString("monitor_id"));
            m.setNodeId(row.getString("node_id"));
            m.setEventTime(row.getDateTime("event_time"));
            m.setHostName(row.getString("host_name"));
            m.setType(row.getString("type"));
            m.setThreshold(row.getLong("threshold"));
            m.setValue(row.getLong("event_value"));
            m.setCount(row.getInt("event_count"));
            m.setSeverityLevel(row.getInt("severity_level"));
            m.setResolved(row.getBoolean("is_resolved"));
            m.setNotified(row.getBoolean("is_notified"));
            m.setLastUpdateTime(row.getDateTime("last_update_time"));
            m.setDetails(row.getString("details"));
            return m;
        }
    }

    static class MonitorRowMapper
    implements ISqlRowMapper<Monitor> {
        MonitorRowMapper() {
        }

        public Monitor mapRow(Row row) {
            Monitor m = new Monitor();
            m.setMonitorId(row.getString("monitor_id"));
            m.setExternalId(row.getString("external_id"));
            m.setNodeGroupId(row.getString("node_group_id"));
            m.setType(row.getString("type"));
            m.setExpression(row.getString("expression"));
            m.setEnabled(row.getBoolean("enabled"));
            m.setThreshold(row.getLong("threshold"));
            m.setRunPeriod(row.getInt("run_period"));
            m.setRunCount(row.getInt("run_count"));
            m.setSeverityLevel(row.getInt("severity_level"));
            m.setCreateTime(row.getDateTime("create_time"));
            m.setLastUpdateBy(row.getString("last_update_by"));
            m.setLastUpdateTime(row.getDateTime("last_update_time"));
            return m;
        }
    }
}

