/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.LongMapper;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.IPurgeListener;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.RegistrationRequest;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.PurgeServiceSqlMap;
import org.jumpmind.symmetric.statistic.IStatisticManager;

public class PurgeService
extends AbstractService
implements IPurgeService {
    private IClusterService clusterService;
    private IStatisticManager statisticManager;
    private IExtensionService extensionService;
    private IContextService contextService;

    public PurgeService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IClusterService clusterService, IStatisticManager statisticManager, IExtensionService extensionService, IContextService contextService) {
        super(parameterService, symmetricDialect);
        this.clusterService = clusterService;
        this.statisticManager = statisticManager;
        this.extensionService = extensionService;
        this.contextService = contextService;
        this.setSqlMap(new PurgeServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeOutgoing(boolean force) {
        long rowsPurged = 0L;
        long startTime = System.currentTimeMillis();
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
        try {
            if ((rowsPurged += this.purgeOutgoing(retentionCutoff, force)) != -1L) {
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged);
            }
        }
        catch (Exception ex) {
            try {
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged, ex);
                this.log.info("Failed to execute purge, but will try again,", (Throwable)ex);
                if ((rowsPurged += this.purgeOutgoing(retentionCutoff, force)) != -1L) {
                    this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged);
                }
            }
            catch (Exception e) {
                this.log.error("Failed to execute purge, so aborting,", (Throwable)e);
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged, e);
            }
        }
        finally {
            this.log.info("The outgoing purge process has completed");
        }
        return rowsPurged;
    }

    @Override
    public long purgeIncoming(boolean force) {
        long rowsPurged = 0L;
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
        return rowsPurged += this.purgeIncoming(retentionCutoff, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeOutgoing(Calendar retentionCutoff, boolean force) {
        long rowsPurged = 0L;
        if (force || this.clusterService.lock("Purge Outgoing")) {
            try {
                this.log.info("The outgoing purge process is about to run for data older than {}", (Object)SimpleDateFormat.getDateTimeInstance().format(retentionCutoff.getTime()));
                if (this.getSymmetricDialect().getName().equalsIgnoreCase("voltdb")) {
                    rowsPurged += this.purgeOutgoingByRetentionCutoff(retentionCutoff);
                } else {
                    rowsPurged += this.purgeStrandedBatches();
                    rowsPurged += this.purgeDataRows(retentionCutoff);
                    rowsPurged += this.purgeOutgoingBatch(retentionCutoff);
                    rowsPurged += this.purgeLingeringBatches(retentionCutoff);
                    rowsPurged += this.purgeStranded(retentionCutoff);
                    rowsPurged += this.purgeExtractRequests();
                    rowsPurged += this.purgeStrandedChannels();
                }
                List<IPurgeListener> purgeListeners = this.extensionService.getExtensionPointList(IPurgeListener.class);
                for (IPurgeListener purgeListener : purgeListeners) {
                    rowsPurged += purgeListener.purgeOutgoing(force);
                }
            }
            finally {
                if (!force) {
                    this.clusterService.unlock("Purge Outgoing");
                }
            }
        } else {
            this.log.debug("Could not get a lock to run an outgoing purge");
            rowsPurged = -1L;
        }
        return rowsPurged;
    }

    protected long purgeOutgoingByRetentionCutoff(Calendar retentionCutoff) {
        int totalCount = 0;
        totalCount += this.executePurgeDelete(this.getSql("deleteOutgoingBatchByCreateTimeSql"), retentionCutoff.getTime());
        totalCount += this.executePurgeDelete(this.getSql("deleteDataEventByCreateTimeSql"), retentionCutoff.getTime());
        totalCount += this.executePurgeDelete(this.getSql("deleteDataByCreateTimeSql"), retentionCutoff.getTime());
        this.log.info("Done purging {} rows", (Object)(totalCount += this.executePurgeDelete(this.getSql("deleteExtractRequestByCreateTimeSql"), retentionCutoff.getTime())));
        return totalCount;
    }

    protected int executePurgeDelete(String deleteSql, Object argument) {
        this.log.debug("Running the following statement: {} with the following arguments: {}", (Object)deleteSql, argument);
        int count = this.sqlTemplate.update(deleteSql, new Object[]{argument});
        this.log.debug("Deleted {} rows", (Object)count);
        return count;
    }

    private long purgeOutgoingBatch(Calendar time) {
        this.log.info("Getting range for outgoing batch");
        long minGapStartId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataGapStartId"), new Object[0]);
        long startBatchId = this.contextService.getLong("purge.last.batch.id");
        long startEventBatchId = this.contextService.getLong("purge.last.event.batch.id");
        if (startBatchId == 0L || startEventBatchId == 0L) {
            long minBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("minOutgoingBatchId"), new Object[0]);
            startBatchId = Math.max(startBatchId, minBatchId);
            startEventBatchId = Math.max(startEventBatchId, minBatchId);
        }
        long endBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("maxOutgoingBatchId"), new Object[]{startBatchId, new Timestamp(time.getTime().getTime())});
        long[] batchMinMax = new long[]{startBatchId, endBatchId};
        long[] eventMinMax = new long[]{startEventBatchId, endBatchId};
        int maxNumOfBatchIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
        int maxNumOfDataEventsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.event.batches.to.delete.in.tx");
        int dataEventsPurgedCount = 0;
        int outgoingbatchPurgedCount = 0;
        if (this.parameterService.is("job.purge.first.pass")) {
            this.log.info("Getting first batch_id for outstanding batches");
            long notOkBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("minOutgoingBatchNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
            long[] batchRangeMinMax = this.getRangeMinMax(batchMinMax, notOkBatchId);
            long[] eventRangeMinMax = this.getRangeMinMax(eventMinMax, notOkBatchId);
            batchMinMax = this.getMinMax(batchMinMax, notOkBatchId, batchRangeMinMax);
            eventMinMax = this.getMinMax(eventMinMax, notOkBatchId, eventRangeMinMax);
            dataEventsPurgedCount = this.purgeByMinMax(eventRangeMinMax, minGapStartId, MinMaxDeleteSql.DATA_EVENT_RANGE, time.getTime(), maxNumOfDataEventsToPurgeInTx);
            outgoingbatchPurgedCount = this.purgeByMinMax(batchRangeMinMax, minGapStartId, MinMaxDeleteSql.OUTGOING_BATCH_RANGE, time.getTime(), maxNumOfBatchIdsToPurgeInTx);
        }
        this.statisticManager.incrementPurgedDataEventRows(dataEventsPurgedCount += this.purgeByMinMax(eventMinMax, minGapStartId, MinMaxDeleteSql.DATA_EVENT, time.getTime(), maxNumOfDataEventsToPurgeInTx));
        this.statisticManager.incrementPurgedBatchOutgoingRows(outgoingbatchPurgedCount += this.purgeByMinMax(batchMinMax, minGapStartId, MinMaxDeleteSql.OUTGOING_BATCH, time.getTime(), maxNumOfBatchIdsToPurgeInTx));
        return dataEventsPurgedCount + outgoingbatchPurgedCount;
    }

    private long[] getRangeMinMax(long[] minMax, long notOkBatchId) {
        return new long[]{minMax[0], Math.min(notOkBatchId > 0L ? notOkBatchId - 1L : minMax[1], minMax[1])};
    }

    private long[] getMinMax(long[] minMax, long notOkBatchId, long[] rangeMinMax) {
        if (rangeMinMax[1] == minMax[1]) {
            minMax[1] = -1L;
        } else {
            minMax[0] = notOkBatchId + 1L;
        }
        return minMax;
    }

    private long purgeLingeringBatches(Calendar time) {
        long totalRowsPurged = 0L;
        long totalBatchesPurged = 0L;
        long ts = System.currentTimeMillis();
        long lastBatchId = this.contextService.getLong("purge.last.batch.id");
        long maxRows = this.parameterService.getLong("job.purge.max.lingering.batches.read");
        int idType = this.symmetricDialect.getSqlTypeForIds();
        List<Long> batchIds = this.getLingeringBatchIds(lastBatchId, maxRows);
        while (batchIds.size() > 0) {
            for (Long batchId : batchIds) {
                long dataDeleteCount = 0L;
                long eventDeleteCount = 0L;
                long batchDeleteCount = 0L;
                long countNotOkay = this.sqlTemplateDirty.queryForLong(this.getSql("countCommonBatchNotStatusForBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()});
                if (countNotOkay == 0L) {
                    this.statisticManager.incrementPurgedDataRows(dataDeleteCount += (long)this.sqlTemplate.update(this.getSql("deleteDataByBatchId"), new Object[]{batchId}, new int[]{idType}));
                    this.statisticManager.incrementPurgedDataEventRows(eventDeleteCount += (long)this.sqlTemplate.update(this.getSql("deleteDataEventByBatchId"), new Object[]{batchId}, new int[]{idType}));
                    this.statisticManager.incrementPurgedBatchOutgoingRows(batchDeleteCount += (long)this.sqlTemplate.update(this.getSql("deleteOutgoingBatchByBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()}, new int[]{idType, 1}));
                    totalRowsPurged += dataDeleteCount + eventDeleteCount + batchDeleteCount;
                } else {
                    batchDeleteCount = this.sqlTemplate.update(this.getSql("deleteOutgoingBatchByBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()}, new int[]{idType, 1});
                    this.statisticManager.incrementPurgedBatchOutgoingRows(batchDeleteCount);
                }
                totalRowsPurged += dataDeleteCount + eventDeleteCount + batchDeleteCount;
                ++totalBatchesPurged;
                if (System.currentTimeMillis() - ts <= 300000L) continue;
                this.log.info("Purged {} of {} batches and {} rows so far", new Object[]{totalBatchesPurged, batchIds.size(), totalRowsPurged});
                ts = System.currentTimeMillis();
                this.clusterService.refreshLock("Purge Outgoing");
            }
            if ((long)batchIds.size() != maxRows) break;
            batchIds = this.getLingeringBatchIds(lastBatchId, maxRows);
            totalRowsPurged = 0L;
            totalBatchesPurged = 0L;
        }
        this.log.info("Done purging {} lingering batches and {} rows", (Object)totalBatchesPurged, (Object)totalRowsPurged);
        return totalRowsPurged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getLingeringBatchIds(long lastBatchId, long maxRows) {
        ArrayList<Long> batchIds = new ArrayList<Long>();
        if (lastBatchId > 0L) {
            this.log.info("Looking for lingering batches before batch ID {}", (Object)lastBatchId);
            try (ISqlReadCursor cursor = null;){
                cursor = this.sqlTemplateDirty.queryForCursor(this.getSql("selectLingeringBatches"), (ISqlRowMapper)new LongMapper(), new Object[]{lastBatchId, AbstractBatch.Status.OK.name()}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 1});
                Long batchId = null;
                long count = 0L;
                while (count++ < maxRows && (batchId = (Long)cursor.next()) != null) {
                    batchIds.add(batchId);
                }
            }
            this.log.info("Found {} lingering batches to purge", (Object)batchIds.size());
        }
        return batchIds;
    }

    private long purgeStrandedBatches() {
        int totalRowsPurged = 0;
        this.log.info("Looking for old nodes in batches");
        List nodes = this.sqlTemplateDirty.query(this.getSql("selectNodesWithStrandedBatches"), (ISqlRowMapper)new StringMapper(), new Object[]{1, AbstractBatch.Status.OK.name()});
        if (nodes.size() > 0) {
            this.log.info("Found {} old nodes in batches", (Object)nodes.size());
            for (String nodeId : nodes) {
                int rowsPurged = this.sqlTemplate.update(this.getSql("updateStrandedBatches"), new Object[]{AbstractBatch.Status.OK.name(), nodeId, AbstractBatch.Status.OK.name()});
                this.log.info("Set the status to {} for {} batches associated with node ID {}", new Object[]{AbstractBatch.Status.OK.name(), rowsPurged, nodeId});
                totalRowsPurged += rowsPurged;
                this.statisticManager.incrementPurgedBatchOutgoingRows(rowsPurged);
            }
        }
        this.log.info("Looking for old channels in batches");
        List channels = this.sqlTemplateDirty.query(this.getSql("selectChannelsWithStrandedBatches"), (ISqlRowMapper)new StringMapper(), new Object[]{AbstractBatch.Status.OK.name()});
        if (channels.size() > 0) {
            this.log.info("Found {} old channels in batches", (Object)channels.size());
            for (String channelId : channels) {
                int rowsPurged = this.sqlTemplate.update(this.getSql("updateStrandedBatchesByChannel"), new Object[]{AbstractBatch.Status.OK.name(), channelId, AbstractBatch.Status.OK.name()});
                this.log.info("Set the status to {} for {} batches associated with channel ID {}", new Object[]{AbstractBatch.Status.OK.name(), rowsPurged, channelId});
                totalRowsPurged += rowsPurged;
                this.statisticManager.incrementPurgedBatchOutgoingRows(rowsPurged);
            }
        }
        return totalRowsPurged;
    }

    private long purgeStrandedChannels() {
        int rowsPurged = 0;
        this.log.info("Looking for old channels in data");
        List channels = this.sqlTemplateDirty.query(this.getSql("selectOldChannelsForData"), (ISqlRowMapper)new StringMapper(), new Object[0]);
        if (channels.size() > 0) {
            this.log.info("Found {} old channels", (Object)channels.size());
            for (String channelId : channels) {
                this.log.info("Purging data for channel {}", (Object)channelId);
                rowsPurged += this.sqlTemplate.update(this.getSql("deleteDataByChannel"), new Object[]{channelId});
            }
            this.statisticManager.incrementPurgedDataRows(rowsPurged);
            this.log.info("Done purging {} rows", (Object)rowsPurged);
        }
        return rowsPurged;
    }

    private long purgeDataRows(Calendar time) {
        this.log.info("Getting range for data");
        long startDataId = this.contextService.getLong("purge.last.data.id");
        if (startDataId == 0L) {
            startDataId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataId"), new Object[0]);
        }
        long[] minMax = new long[]{startDataId, this.getMaxDataIdEligibleToPurge(time)};
        this.log.info("Found range for data of {} through {}", (Object)minMax[0], (Object)minMax[1]);
        long minGapStartId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataGapStartId"), new Object[0]);
        int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.to.delete.in.tx");
        long dataDeletedCount = 0L;
        if (this.parameterService.is("job.purge.first.pass")) {
            this.log.info("Getting count of outstanding batches");
            long outstandingCount = this.sqlTemplateDirty.queryForLong(this.getSql("countOutgoingBatchNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
            long maxOutstandingCount = this.parameterService.getLong("job.purge.first.pass.outstanding.batches.threshold");
            this.log.info("Found " + outstandingCount + " outstanding batches, threshold is " + maxOutstandingCount);
            if (outstandingCount <= maxOutstandingCount) {
                long[] rangeMinMax;
                long minDataId = 0L;
                if (outstandingCount > 0L) {
                    this.log.info("Getting first data_id for outstanding batches");
                    minDataId = this.sqlTemplateDirty.queryForLong(this.getSql("selectDataEventMinNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
                }
                if ((rangeMinMax = new long[]{minMax[0], Math.min(Math.min(minDataId > 0L ? minDataId - 1L : minMax[1], minMax[1]), minGapStartId - 1L)})[1] == minMax[1]) {
                    minMax[1] = -1L;
                } else if (rangeMinMax[1] == minDataId - 1L) {
                    minMax[0] = minDataId + 1L;
                } else if (rangeMinMax[1] == minGapStartId - 1L) {
                    minMax[0] = minGapStartId + 1L;
                }
                dataDeletedCount = this.purgeByMinMax(rangeMinMax, minGapStartId, MinMaxDeleteSql.DATA_RANGE, time.getTime(), maxNumOfDataIdsToPurgeInTx);
            }
        }
        this.statisticManager.incrementPurgedDataRows(dataDeletedCount += (long)this.purgeByMinMax(minMax, minGapStartId, MinMaxDeleteSql.DATA, time.getTime(), maxNumOfDataIdsToPurgeInTx));
        return dataDeletedCount;
    }

    private long getMaxDataIdEligibleToPurge(Calendar time) {
        long lastBatchId = this.contextService.getLong("purge.last.batch.id");
        long maxDataId = 0L;
        List batchIds = this.sqlTemplateDirty.query(this.getSql("maxBatchIdByChannel"), (ISqlRowMapper)new LongMapper(), new Object[]{lastBatchId, new Timestamp(time.getTime().getTime())}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 93});
        if (batchIds != null && batchIds.size() > 0) {
            String sql = this.getSql("maxDataIdForBatches").replace("?", StringUtils.repeat((String)"?", (String)",", (int)batchIds.size()));
            int[] types = new int[batchIds.size()];
            for (int i = 0; i < batchIds.size(); ++i) {
                types[i] = this.symmetricDialect.getSqlTypeForIds();
            }
            List ids = this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new LongMapper(), batchIds.toArray(), types);
            if (ids != null && ids.size() > 0) {
                maxDataId = (Long)ids.get(0);
            }
        }
        return maxDataId;
    }

    private long purgeStranded(Calendar time) {
        this.log.info("Getting range for stranded data events");
        int maxNumOfDataEventsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.event.batches.to.delete.in.tx");
        long minGapStartId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataGapStartId"), new Object[0]);
        long[] minMaxEvent = this.queryForMinMax(this.getSql("selectStrandedDataEventRangeSql"), new Object[0]);
        int strandedEventDeletedCount = this.purgeByMinMax(minMaxEvent, minGapStartId, MinMaxDeleteSql.STRANDED_DATA_EVENT, time.getTime(), maxNumOfDataEventsToPurgeInTx);
        this.statisticManager.incrementPurgedDataEventRows(strandedEventDeletedCount);
        this.log.info("Getting range for stranded data");
        int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.to.delete.in.tx");
        long minDataId = this.sqlTemplateDirty.queryForLong(this.getSql("selectDataMinSql"), new Object[0]);
        long minDataEventId = this.sqlTemplateDirty.queryForLong(this.getSql("selectDataEventMinSql"), new Object[0]);
        long[] minMax = new long[]{minDataId, Math.min(minDataEventId, minGapStartId) - 1L};
        int strandedDeletedCount = this.purgeByMinMax(minMax, minGapStartId, MinMaxDeleteSql.STRANDED_DATA, time.getTime(), maxNumOfDataIdsToPurgeInTx);
        this.statisticManager.incrementPurgedDataRows(strandedDeletedCount);
        return strandedEventDeletedCount + strandedDeletedCount;
    }

    private long[] queryForMinMax(String sql, Object ... params) {
        long[] minMax = (long[])this.sqlTemplateDirty.queryForObject(sql, (ISqlRowMapper)new ISqlRowMapper<long[]>(){

            public long[] mapRow(Row rs) {
                return new long[]{rs.getLong("min_id"), rs.getLong("max_id") - 1L};
            }
        }, params);
        return minMax;
    }

    private long purgeExtractRequests() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.extract.request.retention.minutes"));
        this.log.info("Purging table reload statuses that are older than {}", (Object)retentionCutoff.getTime());
        long count = this.sqlTemplate.update(this.getSql("deleteTableReloadStatusSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} table reload statuses", (Object)count);
        }
        this.log.info("Purging table reload requests that are older than {}", (Object)retentionCutoff.getTime());
        count = this.sqlTemplate.update(this.getSql("deleteTableReloadRequestSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} table reload requests", (Object)count);
        }
        this.log.info("Purging extract requests that are older than {}", (Object)retentionCutoff.getTime());
        count = this.sqlTemplate.update(this.getSql("deleteExtractRequestSql"), new Object[]{ExtractRequest.ExtractStatus.OK.name(), retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} extract requests", (Object)count);
        }
        return count;
    }

    private long purgeRegistrationRequests() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.registration.request.retention.minutes"));
        this.log.info("Purging registration requests that are older than {}", (Object)retentionCutoff.getTime());
        long count = this.sqlTemplate.update(this.getSql("deleteRegistrationRequestSql"), new Object[]{RegistrationRequest.RegistrationStatus.OK.name(), RegistrationRequest.RegistrationStatus.IG.name(), RegistrationRequest.RegistrationStatus.RR.name(), retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} registration requests", (Object)count);
        }
        return count;
    }

    private long purgeMonitorEvents() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
        this.log.info("Purging monitor events that are older than {}", (Object)retentionCutoff.getTime());
        long count = this.sqlTemplate.update(this.getSql("deleteMonitorEventSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} monitor events", (Object)count);
        }
        return count;
    }

    private long purgeTriggerHist() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.trigger.hist.retention.minutes"));
        this.log.info("Purging trigger histories that are inactive and older than {}", (Object)retentionCutoff.getTime());
        long count = this.sqlTemplate.update(this.getSql("deleteInactiveTriggerHistSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} trigger histories", (Object)count);
        }
        return count;
    }

    private int purgeByMinMax(long[] minMax, long minGapStartId, MinMaxDeleteSql identifier, Date retentionTime, int maxNumtoPurgeinTx) {
        long minId = minMax[0];
        long maxId = 0L;
        long purgeUpToId = minMax[1];
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        int idSqlType = this.symmetricDialect.getSqlTypeForIds();
        Timestamp cutoffTime = new Timestamp(retentionTime.getTime());
        this.log.info("About to purge {} using range {} through {}", new Object[]{identifier.toString().toLowerCase(), minMax[0], minMax[1]});
        while (minId <= purgeUpToId) {
            ++totalDeleteStmts;
            maxId = minId + (long)maxNumtoPurgeinTx;
            if (maxId > purgeUpToId) {
                maxId = purgeUpToId;
            }
            String deleteSql = null;
            Object[] args = null;
            int[] argTypes = null;
            switch (identifier) {
                case DATA: {
                    deleteSql = this.getSql("deleteDataSql");
                    args = new Object[]{minId, maxId, cutoffTime, minId, maxId, minId, maxId, AbstractBatch.Status.OK.name()};
                    argTypes = new int[]{idSqlType, idSqlType, 93, idSqlType, idSqlType, idSqlType, idSqlType, 12};
                    break;
                }
                case DATA_RANGE: 
                case STRANDED_DATA: {
                    deleteSql = this.getSql("deleteDataByRangeSql");
                    args = new Object[]{minId, maxId, cutoffTime};
                    argTypes = new int[]{idSqlType, idSqlType, 93};
                    break;
                }
                case DATA_EVENT: {
                    deleteSql = this.getSql("deleteDataEventSql");
                    args = new Object[]{minId, maxId, AbstractBatch.Status.OK.name(), minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType, 12, idSqlType, idSqlType};
                    break;
                }
                case DATA_EVENT_RANGE: {
                    deleteSql = this.getSql("deleteDataEventByRangeSql");
                    args = new Object[]{minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType};
                    break;
                }
                case OUTGOING_BATCH: {
                    deleteSql = this.getSql("deleteOutgoingBatchSql");
                    args = new Object[]{AbstractBatch.Status.OK.name(), minId, maxId, minId, maxId};
                    argTypes = new int[]{12, idSqlType, idSqlType, idSqlType, idSqlType};
                    break;
                }
                case OUTGOING_BATCH_RANGE: {
                    deleteSql = this.getSql("deleteOutgoingBatchByRangeSql");
                    args = new Object[]{minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType};
                    break;
                }
                case STRANDED_DATA_EVENT: {
                    deleteSql = this.getSql("deleteStrandedDataEvent");
                    args = new Object[]{minId, maxId, cutoffTime};
                    argTypes = new int[]{idSqlType, idSqlType, 93};
                }
            }
            this.log.debug("Running the following statement: {} with the following arguments: {}", deleteSql, (Object)Arrays.toString(args));
            int count = this.sqlTemplate.update(deleteSql, args, argTypes);
            this.log.debug("Deleted {} rows", (Object)count);
            totalCount += count;
            if (count == 0 && (identifier == MinMaxDeleteSql.STRANDED_DATA || identifier == MinMaxDeleteSql.STRANDED_DATA_EVENT)) break;
            if (System.currentTimeMillis() - ts > 300000L) {
                this.log.info("Purged {} of {} rows so far using {} statements", new Object[]{totalCount, identifier.toString().toLowerCase(), totalDeleteStmts});
                ts = System.currentTimeMillis();
                this.clusterService.refreshLock("Purge Outgoing");
                this.saveContextLastId(identifier, maxId);
            }
            minId = maxId + 1L;
        }
        this.saveContextLastId(identifier, maxId);
        this.log.info("Done purging {} of {} rows", (Object)totalCount, (Object)identifier.toString().toLowerCase());
        return totalCount;
    }

    protected void saveContextLastId(MinMaxDeleteSql identifier, long lastId) {
        if (lastId > 0L) {
            if (identifier == MinMaxDeleteSql.DATA || identifier == MinMaxDeleteSql.DATA_RANGE) {
                this.contextService.save("purge.last.data.id", String.valueOf(lastId));
            } else if (identifier == MinMaxDeleteSql.DATA_EVENT || identifier == MinMaxDeleteSql.DATA_EVENT_RANGE) {
                this.contextService.save("purge.last.event.batch.id", String.valueOf(lastId));
            } else if (identifier == MinMaxDeleteSql.OUTGOING_BATCH || identifier == MinMaxDeleteSql.OUTGOING_BATCH_RANGE) {
                this.contextService.save("purge.last.batch.id", String.valueOf(lastId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeIncoming(Calendar retentionCutoff, boolean force) {
        long purgedRowCount;
        block8: {
            purgedRowCount = 0L;
            long startTime = System.currentTimeMillis();
            try {
                if (force || this.clusterService.lock("Purge Incoming")) {
                    try {
                        this.log.info("The incoming purge process is about to run");
                        purgedRowCount = this.purgeIncomingBatch(retentionCutoff);
                        purgedRowCount += this.purgeIncomingError();
                        purgedRowCount += this.purgeRegistrationRequests();
                        purgedRowCount += this.purgeMonitorEvents();
                        purgedRowCount += this.purgeTriggerHist();
                        List<IPurgeListener> purgeListeners = this.extensionService.getExtensionPointList(IPurgeListener.class);
                        for (IPurgeListener purgeListener : purgeListeners) {
                            purgedRowCount += purgeListener.purgeIncoming(force);
                        }
                        this.statisticManager.addJobStats("Purge Incoming", startTime, System.currentTimeMillis(), purgedRowCount);
                        break block8;
                    }
                    finally {
                        if (!force) {
                            this.clusterService.unlock("Purge Incoming");
                        }
                        this.log.info("The incoming purge process has completed");
                    }
                }
                this.log.debug("Could not get a lock to run an incoming purge");
            }
            catch (Exception ex) {
                this.log.error("", (Throwable)ex);
                this.statisticManager.addJobStats("Purge Incoming", startTime, System.currentTimeMillis(), purgedRowCount, ex);
            }
        }
        return purgedRowCount;
    }

    private long purgeIncomingError() {
        this.log.info("Purging incoming error rows");
        long rowCount = 0L;
        rowCount = this.getSymmetricDialect().supportsSubselectsInDelete() ? (long)this.sqlTemplate.update(this.getSql("deleteIncomingErrorsSql"), new Object[0]) : (long)this.selectIdsAndDelete(this.getSql("selectIncomingErrorsBatchIdsSql"), "batch_id", this.getSql("deleteIncomingErrorsBatchIdsSql"));
        this.log.info("Purged {} incoming error rows", (Object)rowCount);
        return rowCount;
    }

    private long purgeIncomingBatch(Calendar time) {
        this.log.info("Getting range for incoming batch");
        List nodeBatchRangeList = this.sqlTemplateDirty.query(this.getSql("selectIncomingBatchRangeSql"), (ISqlRowMapper)new ISqlRowMapper<NodeBatchRange>(){

            public NodeBatchRange mapRow(Row rs) {
                return new NodeBatchRange(rs.getString("node_id"), rs.getLong("min_id"), rs.getLong("max_id"));
            }
        }, new Object[]{time.getTime(), AbstractBatch.Status.OK.name()});
        int incomingBatchesPurgedCount = this.purgeByNodeBatchRangeList(nodeBatchRangeList);
        this.statisticManager.incrementPurgedBatchIncomingRows(incomingBatchesPurgedCount);
        return incomingBatchesPurgedCount;
    }

    private int purgeByNodeBatchRangeList(List<NodeBatchRange> nodeBatchRangeList) {
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        this.log.info("About to purge incoming batch");
        for (NodeBatchRange nodeBatchRange : nodeBatchRangeList) {
            int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
            long minBatchId = nodeBatchRange.getMinBatchId();
            long purgeUpToBatchId = nodeBatchRange.getMaxBatchId();
            while (minBatchId <= purgeUpToBatchId) {
                ++totalDeleteStmts;
                long maxBatchId = minBatchId + (long)maxNumOfDataIdsToPurgeInTx;
                if (maxBatchId > purgeUpToBatchId) {
                    maxBatchId = purgeUpToBatchId;
                }
                totalCount += this.sqlTemplate.update(this.getSql("deleteIncomingBatchSql"), new Object[]{minBatchId, maxBatchId, nodeBatchRange.getNodeId(), AbstractBatch.Status.OK.name()});
                minBatchId = maxBatchId + 1L;
            }
            if (totalCount <= 0 || System.currentTimeMillis() - ts <= 300000L) continue;
            this.log.info("Purged {} incoming batch rows so far using {} statements", new Object[]{totalCount, totalDeleteStmts});
            ts = System.currentTimeMillis();
        }
        this.log.info("Done purging {} incoming batch rows", (Object)totalCount);
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeStats(boolean force) {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.stats.retention.minutes"));
        if (force || this.clusterService.lock("Purge Statistics")) {
            try {
                int purgedCount = this.sqlTemplate.update(this.getSql("purgeNodeHostChannelStatsSql"), new Object[]{retentionCutoff.getTime()});
                purgedCount += this.sqlTemplate.update(this.getSql("purgeNodeHostStatsSql"), new Object[]{retentionCutoff.getTime()});
                if ((purgedCount += this.sqlTemplate.update(this.getSql("purgeNodeHostJobStatsSql"), new Object[]{retentionCutoff.getTime()})) > 0) {
                    this.log.debug("{} stats rows were purged", (Object)purgedCount);
                }
            }
            finally {
                if (!force) {
                    this.clusterService.unlock("Purge Statistics");
                }
            }
        }
    }

    @Override
    public void purgeAllIncomingEventsForNode(String nodeId) {
        int count = this.sqlTemplate.update(this.getSql("deleteIncomingBatchByNodeSql"), new Object[]{nodeId});
        this.log.info("Purged all {} incoming batch for node {}", (Object)count, (Object)nodeId);
    }

    protected int selectIdsAndDelete(String selectSql, String fieldName, String deleteSql) {
        List results = this.sqlTemplate.query(selectSql);
        int rowCount = 0;
        if (!results.isEmpty()) {
            ArrayList<Integer> ids = new ArrayList<Integer>(results.size());
            for (Row row : results) {
                ids.add(row.getInt(fieldName));
            }
            results = null;
            StringBuilder placeHolders = new StringBuilder(ids.size() * 2);
            for (int i = 0; i < ids.size(); ++i) {
                placeHolders.append("?,");
            }
            placeHolders.setLength(placeHolders.length() - 1);
            String deleteStatement = deleteSql.replace("?", placeHolders);
            rowCount = this.sqlTemplate.update(deleteStatement, ids.toArray());
        }
        return rowCount;
    }

    static class NodeBatchRange {
        private String nodeId;
        private long minBatchId;
        private long maxBatchId;

        public NodeBatchRange(String nodeId, long minBatchId, long maxBatchId) {
            this.nodeId = nodeId;
            this.minBatchId = minBatchId;
            this.maxBatchId = maxBatchId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getMaxBatchId() {
            return this.maxBatchId;
        }

        public long getMinBatchId() {
            return this.minBatchId;
        }
    }

    static enum MinMaxDeleteSql {
        DATA,
        DATA_RANGE,
        DATA_EVENT,
        DATA_EVENT_RANGE,
        OUTGOING_BATCH,
        OUTGOING_BATCH_RANGE,
        STRANDED_DATA,
        STRANDED_DATA_EVENT;

    }
}

