/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.ISqlTransactionListener;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlTransactionListenerAdapter;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Sequence;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.SequenceServiceSqlMap;

public class SequenceService
extends AbstractService
implements ISequenceService {
    private Map<String, Sequence> sequenceDefinitionCache = new HashMap<String, Sequence>();
    private Map<String, CachedRange> sequenceCache = new HashMap<String, CachedRange>();

    public SequenceService(IParameterService parameterService, ISymmetricDialect symmetricDialect) {
        super(parameterService, symmetricDialect);
        this.setSqlMap(new SequenceServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public void init() {
        Map<String, Sequence> sequences = this.getAll();
        if (sequences.get("outgoing_batch_load_id") == null) {
            this.initSequence("outgoing_batch_load_id", 1L, 0);
        }
        if (sequences.get("outgoing_batch") == null) {
            long maxBatchId = this.sqlTemplate.queryForLong(this.getSql("maxOutgoingBatchSql"), new Object[0]);
            this.initSequence("outgoing_batch", maxBatchId, 10);
        }
        if (sequences.get("trigger_hist") == null) {
            long maxTriggerHistId = this.sqlTemplate.queryForLong(this.getSql("maxTriggerHistSql"), new Object[0]);
            this.initSequence("trigger_hist", maxTriggerHistId, 0);
        }
        if (sequences.get("extract_request") == null) {
            long maxRequestId = this.sqlTemplate.queryForLong(this.getSql("maxExtractRequestSql"), new Object[0]);
            this.initSequence("extract_request", maxRequestId, 0);
        }
    }

    private void initSequence(String name, long initialValue, int cacheSize) {
        try {
            if (initialValue < 1L) {
                initialValue = 1L;
            }
            this.create(new Sequence(name, initialValue, 1, 1L, 9999999999L, "system", false, cacheSize));
        }
        catch (UniqueKeyException ex) {
            this.log.debug("Failed to create sequence {}.  Must be initialized already.", (Object)name);
        }
    }

    @Override
    public synchronized long nextVal(String name) {
        if (!this.parameterService.is("cluster.lock.enabled") && this.getSequenceDefinition(name).getCacheSize() > 0) {
            return this.nextValFromCache(null, name);
        }
        return this.nextValFromDatabase(name, 1L);
    }

    @Override
    public synchronized long nextVal(ISqlTransaction transaction, final String name) {
        if (transaction != null) {
            transaction.addSqlTransactionListener((ISqlTransactionListener)new SqlTransactionListenerAdapter(){

                public void transactionRolledBack() {
                    SequenceService.this.sequenceCache.remove(name);
                }
            });
        }
        if (!this.parameterService.is("cluster.lock.enabled") && this.getSequenceDefinition(transaction, name).getCacheSize() > 0) {
            return this.nextValFromCache(transaction, name);
        }
        return this.nextValFromDatabase(transaction, name, 1L);
    }

    protected long nextValFromCache(ISqlTransaction transaction, String name) {
        CachedRange range = this.sequenceCache.get(name);
        if (range != null) {
            long currentValue = range.getCurrentValue();
            if (currentValue < range.getEndValue()) {
                range.setCurrentValue(currentValue += (long)range.getIncrementBy());
                return currentValue;
            }
            this.sequenceCache.remove(name);
        }
        return this.nextValFromDatabase(transaction, name, 1L);
    }

    protected long nextValFromDatabase(final String name, final long size) {
        return (Long)new DoTransaction<Long>(){

            @Override
            public Long execute(ISqlTransaction transaction) {
                return SequenceService.this.nextValFromDatabase(transaction, name, size);
            }
        }.execute();
    }

    protected long nextValFromDatabase(ISqlTransaction transaction, String name, long size) {
        if (transaction == null) {
            return this.nextValFromDatabase(name, size);
        }
        long sequenceTimeoutInMs = this.parameterService.getLong("sequence.timeout.ms", 5000L);
        long ts = System.currentTimeMillis();
        do {
            long nextVal;
            if ((nextVal = this.tryToGetNextVal(transaction, name, size)) <= 0L) continue;
            return nextVal;
        } while (System.currentTimeMillis() - sequenceTimeoutInMs < ts);
        throw new IllegalStateException(String.format("Timed out after %d ms trying to get the next val for %s", System.currentTimeMillis() - ts, name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long tryToGetNextVal(ISqlTransaction transaction, String name, long size) {
        int updateCount;
        Sequence sequence;
        long currVal = this.currVal(transaction, name);
        long nextVal = currVal + (long)(sequence = this.getSequenceDefinition(transaction, name)).getIncrementBy() * size;
        if (nextVal > sequence.getMaxValue()) {
            if (!sequence.isCycle()) throw new IllegalStateException(String.format("The sequence named %s has reached it's max value.  No more numbers can be handed out.", name));
            nextVal = sequence.getMinValue() + ((long)sequence.getIncrementBy() * size - (long)sequence.getIncrementBy());
        } else if (nextVal < sequence.getMinValue()) {
            if (!sequence.isCycle()) throw new IllegalStateException(String.format("The sequence named %s has reached it's min value.  No more numbers can be handed out.", name));
            nextVal = sequence.getMaxValue() + ((long)sequence.getIncrementBy() * size - (long)sequence.getIncrementBy());
        }
        CachedRange range = null;
        if (!this.parameterService.is("cluster.lock.enabled") && sequence.getCacheSize() > 0) {
            long endVal = nextVal + (long)(sequence.getIncrementBy() * (sequence.getCacheSize() - 1));
            range = new CachedRange(nextVal, endVal, sequence.getIncrementBy());
            nextVal = endVal;
        }
        if ((updateCount = transaction.prepareAndExecute(this.getSql("updateCurrentValueSql"), new Object[]{nextVal, new Date(), name, currVal})) != 1) {
            return -1L;
        }
        if (range == null) return nextVal;
        this.sequenceCache.put(name, range);
        return range.getCurrentValue();
    }

    @Override
    public synchronized long nextRange(ISqlTransaction transaction, String name, long size) {
        CachedRange range;
        Sequence sequence = this.getSequenceDefinition(name);
        if (size <= 0L) {
            throw new IllegalStateException("Size of range must be a positive integer");
        }
        if (sequence.getIncrementBy() <= 0) {
            throw new IllegalStateException("Increment-by must be a positive integer");
        }
        long startingValue = 0L;
        long rangeNeeded = size * (long)sequence.getIncrementBy();
        if (!this.parameterService.is("cluster.lock.enabled") && sequence.getCacheSize() > 0 && (range = this.sequenceCache.get(name)) != null) {
            long currentValue = range.getCurrentValue();
            long endValue = range.getEndValue();
            long rangeAvailable = endValue - currentValue;
            long rangeEndValue = currentValue + rangeNeeded;
            if (currentValue < endValue && rangeEndValue <= sequence.getMaxValue()) {
                startingValue = currentValue + (long)sequence.getIncrementBy();
                if (rangeNeeded <= rangeAvailable) {
                    range.setCurrentValue(currentValue + rangeNeeded);
                    rangeNeeded = 0L;
                } else {
                    size = (rangeNeeded -= rangeAvailable) / (long)sequence.getIncrementBy();
                    this.sequenceCache.remove(name);
                }
            } else {
                this.sequenceCache.remove(name);
            }
        }
        if (rangeNeeded > 0L) {
            long databaseStartingValue = 0L;
            databaseStartingValue = transaction == null ? this.nextValFromDatabase(name, size) - (rangeNeeded - (long)sequence.getIncrementBy()) : this.nextValFromDatabase(transaction, name, size) - (rangeNeeded - (long)sequence.getIncrementBy());
            if (startingValue == 0L) {
                startingValue = databaseStartingValue;
            }
        }
        return startingValue;
    }

    @Override
    public synchronized long nextRange(String name, long size) {
        return this.nextRange(null, name, size);
    }

    protected Sequence getSequenceDefinition(final String name) {
        Sequence sequence = this.sequenceDefinitionCache.get(name);
        if (sequence != null) {
            return sequence;
        }
        return (Sequence)new DoTransaction<Sequence>(){

            @Override
            public Sequence execute(ISqlTransaction transaction) {
                return SequenceService.this.getSequenceDefinition(transaction, name);
            }
        }.execute();
    }

    protected Sequence getSequenceDefinition(ISqlTransaction transaction, String name) {
        Sequence sequence = this.sequenceDefinitionCache.get(name);
        if (sequence == null) {
            sequence = this.get(transaction, name);
            if (sequence != null) {
                this.sequenceDefinitionCache.put(name, sequence);
            } else {
                throw new IllegalStateException(String.format("The sequence named %s is not configured in %s", name, TableConstants.getTableName(this.getTablePrefix(), "sequence")));
            }
        }
        return sequence;
    }

    @Override
    public synchronized long currVal(ISqlTransaction transaction, String name) {
        CachedRange range;
        if (!this.parameterService.is("cluster.lock.enabled") && (range = this.sequenceCache.get(name)) != null) {
            return range.getCurrentValue();
        }
        return transaction.queryForLong(this.getSql("getCurrentValueSql"), new Object[]{name});
    }

    @Override
    public synchronized long currVal(final String name) {
        CachedRange range;
        if (!this.parameterService.is("cluster.lock.enabled") && (range = this.sequenceCache.get(name)) != null) {
            return range.getCurrentValue();
        }
        return (Long)new DoTransaction<Long>(){

            @Override
            public Long execute(ISqlTransaction transaction) {
                return SequenceService.this.currVal(transaction, name);
            }
        }.execute();
    }

    @Override
    public void create(Sequence sequence) {
        this.sqlTemplate.update(this.getSql("insertSequenceSql"), new Object[]{sequence.getSequenceName(), sequence.getCurrentValue(), sequence.getIncrementBy(), sequence.getMinValue(), sequence.getMaxValue(), sequence.isCycle() ? 1 : 0, sequence.getCacheSize(), new Date(), sequence.getLastUpdateBy(), new Date()});
    }

    protected Sequence get(ISqlTransaction transaction, String name) {
        List values = transaction.query(this.getSql("getSequenceSql"), (ISqlRowMapper)new SequenceRowMapper(), new Object[]{name}, new int[]{12});
        if (values.size() > 0) {
            return (Sequence)values.get(0);
        }
        return null;
    }

    protected Map<String, Sequence> getAll() {
        HashMap<String, Sequence> map = new HashMap<String, Sequence>();
        List sequences = this.sqlTemplate.query(this.getSql("getAllSequenceSql"), (ISqlRowMapper)new SequenceRowMapper(), new Object[0]);
        for (Sequence sequence : sequences) {
            map.put(sequence.getSequenceName(), sequence);
        }
        return map;
    }

    static class SequenceRowMapper
    implements ISqlRowMapper<Sequence> {
        SequenceRowMapper() {
        }

        public Sequence mapRow(Row rs) {
            Sequence sequence = new Sequence();
            sequence.setCreateTime(rs.getDateTime("create_time"));
            sequence.setCurrentValue(rs.getLong("current_value"));
            sequence.setIncrementBy(rs.getInt("increment_by"));
            sequence.setLastUpdateBy(rs.getString("last_update_by"));
            sequence.setLastUpdateTime(rs.getDateTime("last_update_time"));
            sequence.setMaxValue(rs.getLong("max_value"));
            sequence.setMinValue(rs.getLong("min_value"));
            sequence.setSequenceName(rs.getString("sequence_name"));
            sequence.setCycle(rs.getBoolean("cycle_flag"));
            sequence.setCacheSize(rs.getInt("cache_size"));
            return sequence;
        }
    }

    abstract class DoTransaction<T> {
        DoTransaction() {
        }

        public T execute() {
            ISqlTransaction transaction = null;
            try {
                transaction = SequenceService.this.sqlTemplate.startSqlTransaction();
                T result = this.execute(transaction);
                transaction.commit();
                T t = result;
                return t;
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                SequenceService.this.close(transaction);
            }
        }

        public abstract T execute(ISqlTransaction var1);
    }

    static class CachedRange {
        long currentValue;
        long endValue;
        int incrementBy;

        public CachedRange(long currentValue, long endValue, int incrementBy) {
            this.currentValue = currentValue;
            this.endValue = endValue;
            this.incrementBy = incrementBy;
        }

        public long getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(long currentValue) {
            this.currentValue = currentValue;
        }

        public long getEndValue() {
            return this.endValue;
        }

        public int getIncrementBy() {
            return this.incrementBy;
        }
    }
}

