/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.StatisticServiceSqlMap;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.ChannelStatsByPeriodMap;
import org.jumpmind.symmetric.statistic.HostStats;
import org.jumpmind.symmetric.statistic.HostStatsByPeriodMap;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.statistic.NodeStatsByPeriodMap;

public class StatisticService
extends AbstractService
implements IStatisticService {
    public StatisticService(IParameterService parameterService, ISymmetricDialect dialect) {
        super(parameterService, dialect);
        this.setSqlMap(new StatisticServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public void save(ChannelStats stats) {
        this.sqlTemplate.update(this.getSql("insertChannelStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getChannelId(), stats.getStartTime(), stats.getEndTime(), stats.getDataRouted(), stats.getDataUnRouted(), stats.getDataEventInserted(), stats.getDataExtracted(), stats.getDataBytesExtracted(), stats.getDataExtractedErrors(), stats.getDataSent(), stats.getDataBytesSent(), stats.getDataSentErrors(), stats.getDataLoaded(), stats.getDataBytesLoaded(), stats.getDataLoadedErrors(), stats.getDataLoadedOutgoing(), stats.getDataBytesLoadedOutgoing(), stats.getDataLoadedOutgoingErrors()}, new int[]{12, 12, 12, 93, 93, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5});
    }

    @Override
    public void save(JobStats stats) {
        this.sqlTemplate.update(this.getSql("insertJobStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getJobName(), stats.getStartTime(), stats.getEndTime(), stats.getProcessedCount(), stats.getTargetNodeId(), stats.getTargetNodeCount(), stats.isErrorFlag() ? 1 : 0, stats.getErrorMessage()}, new int[]{12, 12, 12, 93, 93, -5, 12, 4, 4, 12});
    }

    @Override
    public List<JobStats> getJobStatsForPeriod(Date start, Date end, String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectJobStatsForPeriodSql"), (ISqlRowMapper)new JobStatsMapper(), new Object[]{start, end, nodeId});
    }

    @Override
    public List<JobStats> getJobStatsForNode(String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectJobStatsForNodeSql"), (ISqlRowMapper)new JobStatsMapper(), new Object[]{nodeId});
    }

    @Override
    public TreeMap<Date, Map<String, ChannelStats>> getChannelStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        List list = this.sqlTemplateDirty.query(this.getSql("selectChannelStatsSql"), (ISqlRowMapper)new ChannelStatsMapper(), new Object[]{start, end, nodeId});
        return new ChannelStatsByPeriodMap(start, end, list, periodSizeInMinutes);
    }

    @Override
    public void deleteChannelStatsForPeriod(Date start, Date end, String nodeId) {
        this.sqlTemplate.update(this.getSql("deleteChannelStatsSql"), new Object[]{start, end, nodeId});
    }

    @Override
    public TreeMap<Date, Map<String, ChannelStats>> getNodeStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        List list = this.sqlTemplateDirty.query(this.getSql("selectNodeStatsSql"), (ISqlRowMapper)new ChannelStatsMapper(), new Object[]{start, end, nodeId});
        return new NodeStatsByPeriodMap(start, end, list, periodSizeInMinutes);
    }

    @Override
    public Date getMinNodeStats(String nodeId) {
        return (Date)this.sqlTemplateDirty.queryForObject(this.getSql("minNodeStatsTimeSql"), Date.class, new Object[]{nodeId});
    }

    @Override
    public void save(HostStats stats) {
        this.sqlTemplate.update(this.getSql("insertHostStatsSql"), new Object[]{stats.getNodeId(), stats.getHostName(), stats.getStartTime(), stats.getEndTime(), stats.getRestarted(), stats.getNodesPulled(), stats.getNodesPushed(), stats.getNodesRejected(), stats.getNodesRegistered(), stats.getNodesLoaded(), stats.getNodesDisabled(), stats.getPurgedDataRows(), stats.getPurgedDataEventRows(), stats.getPurgedBatchOutgoingRows(), stats.getPurgedBatchIncomingRows(), stats.getTriggersCreatedCount(), stats.getTriggersRebuiltCount(), stats.getTriggersRemovedCount(), stats.getTotalNodesPullTime(), stats.getTotalNodesPushTime()}, new int[]{12, 12, 93, 93, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5});
    }

    @Override
    public TreeMap<Date, HostStats> getHostStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        List list = this.sqlTemplate.query(this.getSql("selectHostStatsSql"), (ISqlRowMapper)new HostStatsMapper(), new Object[]{start, end, nodeId});
        return new HostStatsByPeriodMap(start, end, list, periodSizeInMinutes);
    }

    public Date truncateToMinutes(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    class HostStatsMapper
    implements ISqlRowMapper<HostStats> {
        HostStatsMapper() {
        }

        public HostStats mapRow(Row rs) {
            HostStats stats = new HostStats();
            stats.setNodeId(rs.getString("node_id"));
            stats.setHostName(rs.getString("host_name"));
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getDateTime("start_time")));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getDateTime("end_time")));
            stats.setRestarted(rs.getLong("restarted"));
            stats.setNodesPulled(rs.getLong("nodes_pulled"));
            stats.setNodesPushed(rs.getLong("nodes_pushed"));
            stats.setNodesRejected(rs.getLong("nodes_rejected"));
            stats.setNodesRegistered(rs.getLong("nodes_registered"));
            stats.setNodesLoaded(rs.getLong("nodes_loaded"));
            stats.setNodesDisabled(rs.getLong("nodes_disabled"));
            stats.setPurgedDataRows(rs.getLong("purged_data_rows"));
            stats.setPurgedDataEventRows(rs.getLong("purged_data_event_rows"));
            stats.setPurgedBatchOutgoingRows(rs.getLong("purged_batch_outgoing_rows"));
            stats.setPurgedBatchIncomingRows(rs.getLong("purged_batch_incoming_rows"));
            stats.setTriggersCreatedCount(rs.getLong("triggers_created_count"));
            stats.setTriggersRebuiltCount(rs.getLong("triggers_rebuilt_count"));
            stats.setTriggersRemovedCount(rs.getLong("triggers_removed_count"));
            stats.setTotalNodesPullTime(rs.getLong("total_nodes_pull_time"));
            stats.setTotalNodesPushTime(rs.getLong("total_nodes_push_time"));
            return stats;
        }
    }

    class ChannelStatsMapper
    implements ISqlRowMapper<ChannelStats> {
        ChannelStatsMapper() {
        }

        public ChannelStats mapRow(Row rs) {
            ChannelStats stats = new ChannelStats();
            stats.setNodeId(rs.getString("node_id"));
            if (rs.containsKey((Object)"host_name")) {
                stats.setHostName(rs.getString("host_name"));
            }
            if (rs.containsKey((Object)"channel_id")) {
                stats.setChannelId(rs.getString("channel_id"));
            }
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getDateTime("start_time")));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getDateTime("end_time")));
            stats.setDataRouted(rs.getLong("data_routed"));
            stats.setDataUnRouted(rs.getLong("data_unrouted"));
            stats.setDataEventInserted(rs.getLong("data_event_inserted"));
            stats.setDataExtracted(rs.getLong("data_extracted"));
            stats.setDataBytesExtracted(rs.getLong("data_bytes_extracted"));
            stats.setDataExtractedErrors(rs.getLong("data_extracted_errors"));
            stats.setDataSent(rs.getLong("data_sent"));
            stats.setDataBytesSent(rs.getLong("data_bytes_sent"));
            stats.setDataSentErrors(rs.getLong("data_sent_errors"));
            stats.setDataLoaded(rs.getLong("data_loaded"));
            stats.setDataBytesLoaded(rs.getLong("data_bytes_loaded"));
            stats.setDataLoadedErrors(rs.getLong("data_loaded_errors"));
            stats.setDataLoadedOutgoing(rs.getLong("data_loaded_outgoing"));
            stats.setDataLoadedOutgoingErrors(rs.getLong("data_loaded_outgoing_errors"));
            stats.setDataBytesLoadedOutgoing(rs.getLong("data_bytes_loaded_outgoing"));
            return stats;
        }
    }

    class JobStatsMapper
    implements ISqlRowMapper<JobStats> {
        JobStatsMapper() {
        }

        public JobStats mapRow(Row rs) {
            JobStats stats = new JobStats();
            stats.setNodeId(rs.getString("node_id"));
            stats.setHostName(rs.getString("host_name"));
            stats.setJobName(rs.getString("job_name"));
            stats.setStartTime(StatisticService.this.truncateToMinutes(rs.getDateTime("start_time")));
            stats.setEndTime(StatisticService.this.truncateToMinutes(rs.getDateTime("end_time")));
            stats.setProcessedCount(rs.getLong("processed_count"));
            stats.setErrorFlag(rs.getBoolean("error_flag"));
            stats.setErrorMessage(rs.getString("error_message"));
            return stats;
        }
    }
}

