/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.statistic.AbstractNodeHostStats;

public abstract class AbstractStatsByPeriodMap<T, M extends AbstractNodeHostStats>
extends TreeMap<Date, T> {
    private static final long serialVersionUID = 1L;

    public AbstractStatsByPeriodMap(Date start, Date end, List<M> list, int periodSizeInMinutes) {
        Iterator<M> stats = list.iterator();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        startCal.set(13, 0);
        startCal.set(14, 0);
        startCal.set(12, this.round(startCal.get(12)));
        Date periodStart = startCal.getTime();
        Date periodEnd = DateUtils.addMinutes((Date)periodStart, (int)periodSizeInMinutes);
        AbstractNodeHostStats stat = null;
        while (periodStart.before(end)) {
            if (stat == null && stats.hasNext()) {
                stat = (AbstractNodeHostStats)stats.next();
            }
            if (stat != null && (periodStart.equals(stat.getStartTime()) || periodStart.before(stat.getStartTime())) && periodEnd.after(stat.getStartTime())) {
                this.add(periodStart, stat);
                stat = null;
                continue;
            }
            if (stat != null && stat.getStartTime().before(periodStart)) {
                stat = null;
            }
            if (!this.containsKey(periodStart)) {
                this.addBlank(periodStart);
            }
            periodStart = periodEnd;
            periodEnd = DateUtils.addMinutes((Date)periodStart, (int)periodSizeInMinutes);
        }
    }

    protected abstract void addBlank(Date var1);

    protected abstract void add(Date var1, M var2);

    protected int round(int value) {
        return 5 * new BigDecimal((double)value / 5.0).setScale(2, RoundingMode.HALF_DOWN).intValue();
    }
}

