/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.transport.ISyncUrlExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBandwidthUrlSelector
implements ISyncUrlExtension,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static String PARAM_PRELOAD_ONLY = "initialLoadOnly";
    public static String PARAM_SAMPLE_SIZE = "sampleSize";
    public static String PARAM_SAMPLE_TTL = "sampleTTL";
    public static String PARAM_MAX_SAMPLE_DURATION = "maxSampleDuration";
    private long defaultSampleSize = 1000L;
    private long defaultSampleTTL = 60000L;
    private long defaultMaxSampleDuration = 2000L;
    protected long lastSampleTs;
    private Map<URI, List<SyncUrl>> cachedUrls = new HashMap<URI, List<SyncUrl>>();
    private INodeService nodeService;
    private IBandwidthService bandwidthService;

    public HttpBandwidthUrlSelector(INodeService nodeService, IBandwidthService bandwidthService) {
        this.nodeService = nodeService;
        this.bandwidthService = bandwidthService;
    }

    @Override
    public String resolveUrl(URI uri) {
        if (uri.toASCIIString().startsWith("ext")) {
            Map<String, String> params = this.getParameters(uri);
            List<SyncUrl> urls = null;
            if (!this.cachedUrls.containsKey(uri)) {
                urls = this.getUrls(params);
                this.cachedUrls.put(uri, urls);
            } else {
                urls = this.cachedUrls.get(uri);
            }
            boolean initialLoadOnly = this.isInitialLoadOnly(params);
            if (initialLoadOnly && this.nodeService != null && !this.nodeService.isDataLoadCompleted() || !initialLoadOnly) {
                long ts = System.currentTimeMillis();
                if (ts - this.getSampleTTL(params) > this.lastSampleTs) {
                    for (SyncUrl syncUrl : urls) {
                        syncUrl.kbps = this.bandwidthService.getDownloadKbpsFor(syncUrl.url, this.getSampleSize(params), this.getMaxSampleDuration(params));
                    }
                    this.lastSampleTs = ts;
                    Collections.sort(urls, new BestBandwidthSorter());
                }
                return urls.get((int)0).url;
            }
            Collections.sort(urls, new ListOrderSorter());
            return urls.get((int)0).url;
        }
        return uri.toString();
    }

    protected long getSampleSize(Map<String, String> params) {
        long sampleSize = this.defaultSampleSize;
        String val = params.get(PARAM_SAMPLE_SIZE);
        if (val != null) {
            try {
                sampleSize = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                this.log.error("Unable to parse sampleSize of {}", (Object)val);
            }
        }
        return sampleSize;
    }

    protected long getMaxSampleDuration(Map<String, String> params) {
        long maxSampleDuration = this.defaultMaxSampleDuration;
        String val = params.get(PARAM_MAX_SAMPLE_DURATION);
        if (val != null) {
            try {
                maxSampleDuration = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                this.log.error("Unable to parse sampleSize of {}", (Object)val);
            }
        }
        return maxSampleDuration;
    }

    protected long getSampleTTL(Map<String, String> params) {
        long sampleTTL = this.defaultSampleTTL;
        String val = params.get(PARAM_SAMPLE_TTL);
        if (val != null) {
            try {
                sampleTTL = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                this.log.error("Unable to parse sampleTTL of {}", (Object)val);
            }
        }
        return sampleTTL;
    }

    protected boolean isInitialLoadOnly(Map<String, String> params) {
        String val = params.get(PARAM_PRELOAD_ONLY);
        return val != null && val.equalsIgnoreCase("true");
    }

    protected List<SyncUrl> getUrls(Map<String, String> params) {
        ArrayList<SyncUrl> urls = new ArrayList<SyncUrl>();
        for (String key : params.keySet()) {
            try {
                int order = Integer.parseInt(key);
                urls.add(new SyncUrl(params.get(key), order));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return urls;
    }

    protected Map<String, String> getParameters(URI uri) {
        String query = uri.getQuery();
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] pair = param.split("=");
            if (pair.length <= 1) continue;
            String name = pair[0];
            String value = pair[1];
            map.put(name, value);
        }
        return map;
    }

    public void setDefaultSampleSize(long sampleSize) {
        this.defaultSampleSize = sampleSize;
    }

    public void setDefaultSampleTTL(long sampleTTL) {
        this.defaultSampleTTL = sampleTTL;
    }

    public void setDefaultMaxSampleDuration(long defaultMaxSampleDuration) {
        this.defaultMaxSampleDuration = defaultMaxSampleDuration;
    }

    static class BestBandwidthSorter
    implements Comparator<SyncUrl> {
        BestBandwidthSorter() {
        }

        @Override
        public int compare(SyncUrl o1, SyncUrl o2) {
            double thisVal = o1.kbps;
            double anotherVal = o2.kbps;
            return thisVal > anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    static class ListOrderSorter
    implements Comparator<SyncUrl> {
        ListOrderSorter() {
        }

        @Override
        public int compare(SyncUrl o1, SyncUrl o2) {
            int thisVal = o1.order;
            int anotherVal = o2.order;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    static class SyncUrl {
        String url;
        int order;
        double kbps;

        public SyncUrl(String url, int order) {
            this.url = url;
            this.order = order;
        }
    }
}

